/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import org.web3j.crypto.Hash;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class ContractUtils {
    public static final int SALT_SIZE = 32;
    public static final int ADDRESS_BYTE_SIZE = 20;

    public static byte[] generateContractAddress(byte[] address, BigInteger nonce) {
        ArrayList<RlpString> values = new ArrayList<RlpString>();
        values.add(RlpString.create((byte[])address));
        values.add(RlpString.create((BigInteger)nonce));
        RlpList rlpList = new RlpList(values);
        byte[] encoded = RlpEncoder.encode((RlpType)rlpList);
        byte[] hashed = Hash.sha3((byte[])encoded);
        return Arrays.copyOfRange(hashed, 12, hashed.length);
    }

    public static String generateContractAddress(String address, BigInteger nonce) {
        byte[] result = ContractUtils.generateContractAddress(Numeric.hexStringToByteArray((String)address), nonce);
        return Numeric.toHexString((byte[])result);
    }

    public static byte[] generateCreate2ContractAddress(byte[] address, byte[] salt, byte[] initCode) {
        if (address.length != 20) {
            throw new RuntimeException("Invalid address size");
        }
        if (salt.length != 32) {
            throw new RuntimeException("Invalid salt size");
        }
        byte[] hashedInitCode = Hash.sha3((byte[])initCode);
        byte[] buffer = new byte[1 + address.length + salt.length + hashedInitCode.length];
        buffer[0] = -1;
        int offset = 1;
        System.arraycopy(address, 0, buffer, offset, address.length);
        System.arraycopy(salt, 0, buffer, offset += address.length, salt.length);
        System.arraycopy(hashedInitCode, 0, buffer, offset += salt.length, hashedInitCode.length);
        byte[] hashed = Hash.sha3((byte[])buffer);
        return Arrays.copyOfRange(hashed, 12, hashed.length);
    }

    public static String generateCreate2ContractAddress(String address, byte[] salt, byte[] initCode) {
        byte[] result = ContractUtils.generateCreate2ContractAddress(Numeric.hexStringToByteArray((String)address), salt, initCode);
        return Numeric.toHexString((byte[])result);
    }
}

