/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.jpa.storage.SpaceStorage;
import org.exoplatform.social.core.search.DocumentWithMetadata;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.jsoup.Jsoup;

public class SpaceIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    public static final String TYPE = "space";
    public static final String SPACE_METADATA_OBJECT_TYPE = "space";
    private static final Log LOG = ExoLogger.getLogger(SpaceIndexingServiceConnector.class);
    private SpaceService spaceService;
    private SpaceStorage spaceStorage;
    private MetadataService metadataService;

    public SpaceIndexingServiceConnector(SpaceService spaceService, SpaceStorage spaceStorage, MetadataService metadataService, InitParams initParams) {
        super(initParams);
        this.spaceService = spaceService;
        this.spaceStorage = spaceStorage;
        this.metadataService = metadataService;
    }

    public String getConnectorName() {
        return "space";
    }

    public Document create(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        long ts = System.currentTimeMillis();
        LOG.debug("get space document for space id={}", new Object[]{id});
        Space space = this.spaceService.getSpaceById(id);
        if (space == null) {
            return null;
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("prettyName", space.getPrettyName());
        fields.put("displayName", space.getDisplayName());
        fields.put("description", this.htmlToText(space.getDescription()));
        fields.put("visibility", space.getVisibility());
        fields.put("registration", space.getRegistration());
        fields.put("templateId", String.valueOf(space.getTemplateId()));
        Date createdDate = new Date(space.getCreatedTime());
        DocumentWithMetadata document = new DocumentWithMetadata();
        document.setId(id);
        document.setLastUpdatedDate(createdDate);
        document.setFields(fields);
        document.setPermissions((Set)("hidden".equals(space.getVisibility()) ? new HashSet<String>(Arrays.asList(space.getMembers())) : Collections.singleton("all")));
        document.addListField("member", new HashSet(space.getMembers() == null ? Collections.emptyList() : Arrays.asList(space.getMembers())));
        document.addListField("pending", new HashSet(space.getPendingUsers() == null ? Collections.emptyList() : Arrays.asList(space.getPendingUsers())));
        document.addListField("invited", new HashSet(space.getInvitedUsers() == null ? Collections.emptyList() : Arrays.asList(space.getInvitedUsers())));
        document.addListField("manager", new HashSet(space.getManagers() == null ? Collections.emptyList() : Arrays.asList(space.getManagers())));
        document.addListField("publisher", new HashSet(space.getPublishers() == null ? Collections.emptyList() : Arrays.asList(space.getPublishers())));
        document.addListField("redactor", new HashSet(space.getRedactors() == null ? Collections.emptyList() : Arrays.asList(space.getRedactors())));
        this.addDocumentMetadata(document, id);
        LOG.info("space document generated for id={} name={} duration_ms={}", new Object[]{id, space.getPrettyName(), System.currentTimeMillis() - ts});
        return document;
    }

    public Document update(String id) {
        return this.create(id);
    }

    public List<String> getAllIds(int offset, int limit) {
        return this.spaceStorage.getSpaces(offset, limit).stream().map(Space::getId).toList();
    }

    public boolean isReindexOnUpgrade() {
        return true;
    }

    public String getMapping() {
        StringBuilder mapping = new StringBuilder().append("{").append("  \"properties\" : {\n").append("    \"prettyName\" : {\"type\" : \"keyword\"},\n").append("    \"displayName\" : {").append("      \"type\" : \"text\",").append("      \"analyzer\": \"ngram_analyzer\",").append("      \"search_analyzer\": \"ngram_analyzer_search\",").append("      \"index_options\": \"offsets\",").append("      \"fields\": {").append("        \"raw\": {").append("          \"type\": \"keyword\"").append("        }").append("      }").append("    },\n").append("    \"description\" : {\"type\" : \"text\", \"index_options\": \"offsets\"},\n").append("    \"visibility\" : {\"type\" : \"keyword\"},\n").append("    \"registration\" : {\"type\" : \"keyword\"},\n").append("    \"permissions\" : {\"type\" : \"keyword\"},\n").append("    \"pending\" : {\"type\" : \"keyword\"},\n").append("    \"invited\" : {\"type\" : \"keyword\"},\n").append("    \"manager\" : {\"type\" : \"keyword\"},\n").append("    \"publisher\" : {\"type\" : \"keyword\"},\n").append("    \"redactor\" : {\"type\" : \"keyword\"},\n").append("    \"lastUpdatedDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"}\n").append("  }\n").append("}");
        return mapping.toString();
    }

    private void addDocumentMetadata(DocumentWithMetadata document, String spaceId) {
        MetadataObject metadataObject = new MetadataObject("space", spaceId);
        List metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        document.setMetadataItems(metadataItems);
    }

    private String htmlToText(String source) {
        return source == null ? "" : Jsoup.parse((String)source).text();
    }
}

