/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.NewPortalConfigListener;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService$AjcClosure1;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.SiteFilter;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.picocontainer.Startable;

public class UserPortalConfigService
implements Startable {
    @Generated
    private final Object $lock = new Object[0];
    public static final String SITE_TEMPLATE_INSTANTIATED = "site.template.instantiated";
    private static final Log LOG;
    private static final String PUBLIC_SITE_NAME = "public";
    private static final Scope HOME_PAGE_URI_PREFERENCE_SCOPE;
    private static final String HOME_PAGE_URI_PREFERENCE_KEY = "HOME_PAGE_URI";
    public static final String DEFAULT_GLOBAL_PORTAL = "global";
    public static final String DEFAULT_GROUP_SITE_TEMPLATE = "group";
    public static final String DEFAULT_USER_SITE_TEMPLATE = "user";
    private LayoutService layoutService;
    private UserACL userAcl;
    private SettingService settingService;
    private ListenerService listenerService;
    private NavigationService navigationService;
    private NewPortalConfigListener newPortalConfigListener;
    private String globalPortal;
    private final ImportMode defaultImportMode;
    private PortalConfig metaPortalConfig;
    protected final SiteFilter siteFilter = new SiteFilter(SiteType.PORTAL, null, null, true, true, false, false, 0, 0);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public UserPortalConfigService(LayoutService layoutService, NavigationService navigationService, SettingService settingService, ListenerService listenerService, UserACL userAcl, InitParams params) {
        this.layoutService = layoutService;
        this.settingService = settingService;
        this.listenerService = listenerService;
        this.userAcl = userAcl;
        this.navigationService = navigationService;
        this.defaultImportMode = ImportMode.valueOf((String)this.getParam(params, "default.import.mode", ImportMode.CONSERVE.name()).toUpperCase());
        this.globalPortal = this.getParam(params, "global.portal", DEFAULT_GLOBAL_PORTAL);
        this.siteFilter.setExcludedSiteName(this.globalPortal);
    }

    public LayoutService getDataStorage() {
        return this.layoutService;
    }

    public ImportMode getDefaultImportMode() {
        return this.defaultImportMode;
    }

    public NavigationService getNavigationService() {
        return this.navigationService;
    }

    public UserACL getUserACL() {
        return this.userAcl;
    }

    public UserPortalConfig getUserPortalConfig(String portalName, String username) {
        return this.getUserPortalConfig(portalName, username, LocaleContextInfoUtils.getUserLocale((String)username));
    }

    public UserPortalConfig getUserPortalConfig(String portalName, String accessUser, Locale locale) {
        PortalConfig portal = this.layoutService.getPortalConfig(portalName);
        if (portal == null || !this.userAcl.hasAccessPermission(portal, this.userAcl.getUserIdentity(accessUser))) {
            return null;
        }
        return new UserPortalConfig(portal, this, portalName, accessUser, locale);
    }

    public void createSiteFromTemplate(SiteKey sourceSiteKey, SiteKey targetSiteKey) throws ObjectNotFoundException {
        this.createSiteFromTemplate(sourceSiteKey, targetSiteKey, null);
    }

    public void createSiteFromTemplate(SiteKey sourceSiteKey, SiteKey targetSiteKey, String permission) throws ObjectNotFoundException {
        this.layoutService.savePortalFromTemplate(sourceSiteKey, targetSiteKey, permission);
        this.layoutService.savePagesFromTemplate(sourceSiteKey, targetSiteKey, permission);
        this.navigationService.saveNavigationFromTemplate(sourceSiteKey, targetSiteKey);
        this.listenerService.broadcast(SITE_TEMPLATE_INSTANTIATED, (Object)sourceSiteKey, (Object)targetSiteKey);
    }

    public void createUserPortalConfig(String siteType, String siteName, String template) {
        NewPortalConfig portalConfig = null;
        if (StringUtils.isBlank((CharSequence)template)) {
            portalConfig = new NewPortalConfig();
            portalConfig.setUseMetaPortalLayout(true);
        } else {
            String templatePath = this.newPortalConfigListener.getTemplateConfig(siteType, template);
            portalConfig = new NewPortalConfig(templatePath);
            portalConfig.setTemplateName(template);
        }
        portalConfig.setOwnerType(siteType);
        this.newPortalConfigListener.createPortalConfig(portalConfig, siteName);
        this.newPortalConfigListener.createPage(portalConfig, siteName);
        this.newPortalConfigListener.createPageNavigation(portalConfig, siteName);
    }

    public void createUserPortalConfig(String siteType, String siteName, String template, String templatePath) {
        NewPortalConfig portalConfigPlugin = new NewPortalConfig(templatePath);
        portalConfigPlugin.setTemplateName(template);
        portalConfigPlugin.setOwnerType(siteType);
        this.newPortalConfigListener.createPortalConfig(portalConfigPlugin, siteName);
        this.newPortalConfigListener.createPage(portalConfigPlugin, siteName);
        this.newPortalConfigListener.createPageNavigation(portalConfigPlugin, siteName);
    }

    public void removeUserPortalConfig(String portalName) {
        this.removeUserPortalConfig(PortalConfig.PORTAL_TYPE, portalName);
    }

    public void removeUserPortalConfig(String ownerType, String ownerId) {
        PortalConfig config = this.layoutService.getPortalConfig(ownerType, ownerId);
        if (config != null) {
            this.layoutService.remove(config);
        }
    }

    @Deprecated(forRemoval=true, since="7.0")
    public PageContext getPage(PageKey pageRef) {
        ConversationState conversationState = ConversationState.getCurrent();
        return this.getPage(pageRef, conversationState == null ? null : conversationState.getIdentity());
    }

    public PageContext getPage(PageKey pageRef, String username) {
        Identity userAclIdentity = this.userAcl.getUserIdentity(username);
        return this.getPage(pageRef, userAclIdentity);
    }

    public List<PortalConfig> getUserPortalSites(String username) {
        Identity userAclIdentity = this.userAcl.getUserIdentity(username);
        List list = this.layoutService.getSites(this.siteFilter);
        return list.stream().filter(Objects::nonNull).filter(portalConfig -> this.userAcl.hasAccessPermission((PortalConfig)portalConfig, userAclIdentity)).sorted((s1, s2) -> {
            if (!s2.isDisplayed() && !s1.isDisplayed()) {
                if (StringUtils.equals((CharSequence)s1.getName(), (CharSequence)PUBLIC_SITE_NAME)) {
                    return -1;
                }
                if (StringUtils.equals((CharSequence)s2.getName(), (CharSequence)PUBLIC_SITE_NAME)) {
                    return 1;
                }
                return s2.getName().compareTo(s1.getName());
            }
            if (!s2.isDisplayed()) {
                return -2147483647;
            }
            if (!s1.isDisplayed()) {
                return Integer.MAX_VALUE;
            }
            int order = s1.getDisplayOrder() - s2.getDisplayOrder();
            return order == 0 ? s2.getName().compareTo(s1.getName()) : order;
        }).toList();
    }

    public String computePortalSitePath(String portalName, HttpServletRequest context) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(portalName);
        if (portalConfig == null) {
            return null;
        }
        Collection<UserNode> userNodes = this.getPortalSiteNavigations(portalName, SiteType.PORTAL.getName(), context);
        UserNode userNode = this.getFirstAllowedPageNode(userNodes);
        if (userNode == null) {
            return null;
        }
        return this.getDefaultUri(userNode, portalName);
    }

    public String computePortalPath(HttpServletRequest request) {
        List<PortalConfig> portalConfigList = this.getUserPortalSites(request.getRemoteUser());
        if (CollectionUtils.isEmpty(portalConfigList)) {
            return null;
        }
        return portalConfigList.stream().filter(PortalConfig::isDefaultSite).map(portalConfig -> this.computePortalSitePath(portalConfig.getName(), request)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Collection<UserNode> getPortalSiteNavigations(String siteName, String portalType, HttpServletRequest context) {
        UserPortalConfig userPortalConfig = this.getUserPortalConfig(siteName, context.getRemoteUser());
        if (userPortalConfig == null) {
            return Collections.emptyList();
        }
        UserPortal userPortal = userPortalConfig.getUserPortal();
        UserNavigation navigation = userPortal.getNavigation(new SiteKey(SiteType.valueOf((String)portalType.toUpperCase()), siteName));
        if (navigation == null) {
            return Collections.emptyList();
        }
        UserNodeFilterConfig builder = UserNodeFilterConfig.builder().withReadCheck().withVisibility(Visibility.DISPLAYED, Visibility.TEMPORAL).withTemporalCheck().build();
        UserNode rootNode = userPortal.getNode(navigation, org.exoplatform.portal.mop.navigation.Scope.ALL, builder, null);
        return rootNode != null ? rootNode.getChildren() : Collections.emptyList();
    }

    public UserNode getPortalSiteRootNode(String siteName, String siteType, HttpServletRequest request) {
        UserPortalConfig userPortalConfig = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)siteType, (CharSequence)PortalConfig.PORTAL_TYPE)) {
            userPortalConfig = this.getUserPortalConfig(siteName, request.getRemoteUser());
        } else {
            PortalConfig defaultPortalConfig = this.getUserPortalSites(request.getRemoteUser()).stream().findFirst().orElse(null);
            if (defaultPortalConfig != null) {
                userPortalConfig = this.getUserPortalConfig(defaultPortalConfig.getName(), request.getRemoteUser());
            }
        }
        if (userPortalConfig == null) {
            return null;
        }
        UserPortal userPortal = userPortalConfig.getUserPortal();
        UserNavigation navigation = userPortal.getNavigation(new SiteKey(SiteType.valueOf((String)siteType.toUpperCase()), siteName));
        if (navigation == null) {
            return null;
        }
        UserNodeFilterConfig builder = UserNodeFilterConfig.builder().withReadWriteCheck().withVisibility(Visibility.DISPLAYED, Visibility.TEMPORAL).withTemporalCheck().build();
        return userPortal.getNode(navigation, org.exoplatform.portal.mop.navigation.Scope.ALL, builder, null);
    }

    public UserNode getFirstAllowedPageNode(Collection<UserNode> userNodes) {
        return userNodes.stream().map(node -> {
            if (node.getPageRef() != null && this.layoutService.getPage(node.getPageRef()) != null) {
                return node;
            }
            if (node.getChildren() != null && !node.getChildren().isEmpty()) {
                return this.getFirstAllowedPageNode(node.getChildren());
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public String getFirstAllowedPageNode(String portalName, String portalType, String nodePath, HttpServletRequest request) {
        UserNode targetUserNode = this.getPortalSiteRootNode(portalName, portalType, request);
        if (targetUserNode == null) {
            return nodePath;
        }
        String[] pathNodesNames = nodePath.split("/");
        Iterator iterator = Arrays.stream(pathNodesNames).iterator();
        while (iterator.hasNext() && targetUserNode != null) {
            targetUserNode = targetUserNode.getChild((String)iterator.next());
        }
        String newPath = null;
        while (newPath == null) {
            if (targetUserNode == null) {
                return nodePath;
            }
            if (targetUserNode.getPageRef() != null) {
                newPath = targetUserNode.getURI();
                continue;
            }
            if (!targetUserNode.getChildren().isEmpty()) {
                targetUserNode = this.getFirstAllowedPageNode(targetUserNode.getChildren());
                continue;
            }
            targetUserNode = targetUserNode.getParent();
        }
        return newPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initListener(ComponentPlugin listener) {
        Object object = this.$lock;
        synchronized (object) {
            if (listener instanceof NewPortalConfigListener) {
                NewPortalConfigListener portalConfigListener = (NewPortalConfigListener)listener;
                if (this.newPortalConfigListener == null) {
                    this.newPortalConfigListener = portalConfigListener;
                } else {
                    this.newPortalConfigListener.mergePlugin(portalConfigListener);
                }
            }
        }
    }

    @ContainerTransactional
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        UserPortalConfigService$AjcClosure1 userPortalConfigService$AjcClosure1 = new UserPortalConfigService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(userPortalConfigService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public String getMetaPortal() {
        return this.newPortalConfigListener.getMetaPortal();
    }

    public String getUserHomePage(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return null;
        }
        SettingValue homePageSettingValue = this.settingService.get(Context.USER.id(username), HOME_PAGE_URI_PREFERENCE_SCOPE, HOME_PAGE_URI_PREFERENCE_KEY);
        if (homePageSettingValue != null && homePageSettingValue.getValue() != null) {
            return homePageSettingValue.getValue().toString();
        }
        return PropertyManager.getProperty((String)"exo.portal.user.defaultHome");
    }

    public String getDefaultPortalTemplate() {
        return this.newPortalConfigListener.getDefaultPortalTemplate();
    }

    public Set<String> getPortalTemplates() {
        return this.newPortalConfigListener.getTemplateConfigs(PortalConfig.PORTAL_TYPE);
    }

    public <T> T getConfig(String portalType, String portalName, Class<T> objectType, String parentLocation) {
        return this.newPortalConfigListener.getConfig(portalType, portalName, objectType, parentLocation);
    }

    public String getMetaPortalSkinName() {
        return this.metaPortalConfig != null && StringUtils.isNotBlank((CharSequence)this.metaPortalConfig.getSkin()) ? this.metaPortalConfig.getSkin() : null;
    }

    public PortalConfig getMetaPortalConfig() {
        return this.metaPortalConfig;
    }

    public void setMetaPortalConfig(PortalConfig metaPortalConfig) {
        this.metaPortalConfig = metaPortalConfig;
    }

    private PageContext getPage(PageKey pageRef, Identity userAclIdentity) {
        if (pageRef == null) {
            return null;
        }
        PageContext page = this.layoutService.getPageContext(pageRef);
        if (page == null || !this.userAcl.hasAccessPermission(page, userAclIdentity)) {
            return null;
        }
        return page;
    }

    private void loadMetaPortalConfig() {
        String metaPortal = this.getMetaPortal();
        if (metaPortal != null) {
            try {
                RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
                this.metaPortalConfig = this.getDataStorage().getPortalConfig(metaPortal);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot retrieve data of portal " + metaPortal), (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public void reloadConfig(String ownerType, String predefinedOwner, String location, String importMode, boolean overrideMode) {
        this.newPortalConfigListener.reloadConfig(ownerType, predefinedOwner, location, importMode, overrideMode);
    }

    private String getDefaultUri(UserNode node, String site) {
        Object uri = "/portal/" + site + "/";
        Page userNodePage = this.layoutService.getPage(node.getPageRef());
        uri = PageType.LINK.equals((Object)PageType.valueOf((String)userNodePage.getType())) ? userNodePage.getLink() : (String)uri + node.getURI();
        return uri;
    }

    private String getParam(InitParams params, String name, String defaultValue) {
        ValueParam valueParam = params == null ? null : params.getValueParam(name);
        return valueParam == null ? defaultValue : valueParam.getValue();
    }

    @Generated
    public String getGlobalPortal() {
        return this.globalPortal;
    }

    @Generated
    public void setGlobalPortal(String globalPortal) {
        this.globalPortal = globalPortal;
    }

    static {
        UserPortalConfigService.ajc$preClinit();
        LOG = ExoLogger.getLogger((String)"Portal:UserPortalConfigService");
        HOME_PAGE_URI_PREFERENCE_SCOPE = Scope.PORTAL.id("HOME");
    }

    static final /* synthetic */ void start_aroundBody0(UserPortalConfigService ajc$this, JoinPoint joinPoint) {
        try {
            if (ajc$this.newPortalConfigListener == null) {
                return;
            }
            ajc$this.newPortalConfigListener.run();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not import initial data", (Throwable)e);
        }
        ajc$this.loadMetaPortalConfig();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserPortalConfigService.java", UserPortalConfigService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.exoplatform.portal.config.UserPortalConfigService", "", "", "", "void"), 465);
    }
}

