/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.dao.RealizationDAO;
import io.meeds.gamification.entity.RealizationEntity;
import io.meeds.gamification.model.PiechartLeaderboard;
import io.meeds.gamification.model.ProfileReputation;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.StandardLeaderboard;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.RuleStorage;
import io.meeds.gamification.storage.mapper.RealizationMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class RealizationStorage {
    private ProgramStorage programStorage;
    private RuleStorage ruleStorage;
    private RealizationDAO gamificationHistoryDAO;

    public RealizationStorage(ProgramStorage programStorage, RuleStorage ruleStorage, RealizationDAO gamificationHistoryDAO) {
        this.programStorage = programStorage;
        this.ruleStorage = ruleStorage;
        this.gamificationHistoryDAO = gamificationHistoryDAO;
    }

    public List<RealizationDTO> getRealizationsByFilter(RealizationFilter realizationFilter, int offset, int limit) {
        List<Long> ids = this.gamificationHistoryDAO.findRealizationsByFilter(realizationFilter, offset, limit);
        return ids.stream().map(this::getRealizationById).toList();
    }

    public int countRealizationsByFilter(RealizationFilter realizationFilter) {
        return this.gamificationHistoryDAO.countRealizationsByFilter(realizationFilter);
    }

    public RealizationDTO getRealizationById(long id) {
        return RealizationMapper.fromEntity(this.programStorage, (RealizationEntity)this.gamificationHistoryDAO.find(Long.valueOf(id)));
    }

    public RealizationDTO updateRealization(RealizationDTO realization) {
        RealizationEntity realizationEntity = RealizationMapper.toEntity(this.ruleStorage, realization);
        realizationEntity = (RealizationEntity)this.gamificationHistoryDAO.update(realizationEntity);
        return RealizationMapper.fromEntity(this.programStorage, realizationEntity);
    }

    public RealizationDTO createRealization(RealizationDTO realization) {
        RealizationEntity realizationEntity = RealizationMapper.toEntity(this.ruleStorage, realization);
        realizationEntity.setId(null);
        realizationEntity.setCreatedDate(new Date());
        return RealizationMapper.fromEntity(this.programStorage, (RealizationEntity)this.gamificationHistoryDAO.create(realizationEntity));
    }

    public List<RealizationDTO> findRealizationsByObjectIdAndObjectType(String objectId, String objectType) {
        List<Long> ids = this.gamificationHistoryDAO.getRealizationsByObjectIdAndObjectType(objectId, objectType);
        return ids.stream().map(this::getRealizationById).toList();
    }

    public boolean hasPendingRealization(long ruleId, String earnerIdentityId) {
        RealizationFilter realizationFilter = new RealizationFilter();
        realizationFilter.setEarnerIds(new ArrayList<String>(Collections.singleton(earnerIdentityId)));
        realizationFilter.setEarnerType(IdentityType.USER);
        realizationFilter.setStatus(RealizationStatus.PENDING);
        realizationFilter.setRuleIds(new ArrayList<Long>(Collections.singleton(ruleId)));
        return this.gamificationHistoryDAO.countRealizationsByFilter(realizationFilter) > 0;
    }

    public int getLeaderboardRankByDates(IdentityType identityType, String earnerIdentityId, Date fromDate, Date toDate) {
        return this.gamificationHistoryDAO.getLeaderboardRankByDates(identityType, earnerIdentityId, fromDate, toDate);
    }

    public int getLeaderboardRankByDatesAndProgramIds(IdentityType identityType, String earnerIdentityId, Date fromDate, Date toDate, Long ... programIds) {
        return this.gamificationHistoryDAO.getLeaderboardRankByDatesAndProgramIds(identityType, earnerIdentityId, fromDate, toDate, programIds);
    }

    public int getLeaderboardRank(IdentityType identityType, String earnerIdentityId) {
        return this.gamificationHistoryDAO.getLeaderboardRank(identityType, earnerIdentityId);
    }

    public int getLeaderboardRankByProgramIds(IdentityType identityType, String earnerIdentityId, Long ... programIds) {
        return this.gamificationHistoryDAO.getLeaderboardRankByProgramIds(identityType, earnerIdentityId, programIds);
    }

    public List<StandardLeaderboard> getLeaderboardByDates(Date fromDate, Date toDate, IdentityType identityType, int offset, int limit) {
        return this.gamificationHistoryDAO.getLeaderboardByDates(fromDate, toDate, identityType, offset, limit);
    }

    public List<StandardLeaderboard> getLeaderboard(IdentityType identityType, int offset, int limit) {
        return this.gamificationHistoryDAO.getLeaderboard(identityType, offset, limit);
    }

    public List<StandardLeaderboard> getLeaderboardByDatesByProgramIds(Date fromDate, Date toDate, IdentityType identityType, int offset, int limit, Long ... programIds) {
        return this.gamificationHistoryDAO.getLeaderboardByDatesAndProgramIds(fromDate, toDate, identityType, offset, limit, programIds);
    }

    public List<StandardLeaderboard> getLeaderboardByProgramIds(IdentityType identityType, int offset, int limit, Long ... programIds) {
        return this.gamificationHistoryDAO.getLeaderboardByProgramIds(identityType, offset, limit, programIds);
    }

    public List<ProfileReputation> getScorePerProgramByIdentityId(String earnerIdentityId) {
        return this.gamificationHistoryDAO.getScorePerProgramByIdentityId(earnerIdentityId);
    }

    public List<PiechartLeaderboard> getLeaderboardStatsByIdentityIdAndDates(String earnerIdentityId, Long spaceId, Date startDate, Date endDate) {
        return this.gamificationHistoryDAO.getLeaderboardStatsByIdentityIdAndDates(earnerIdentityId, spaceId, startDate, endDate);
    }

    public List<PiechartLeaderboard> getLeaderboardStatsByIdentityId(String earnerIdentityId, Long spaceId) {
        return this.gamificationHistoryDAO.getLeaderboardStatsByIdentityId(earnerIdentityId, spaceId);
    }

    public long getScoreByIdentityIdAndBetweenDates(String earnerIdentityId, Date fromDate, Date toDate, Long ... programIds) {
        return this.gamificationHistoryDAO.getScoreByIdentityIdAndBetweenDates(earnerIdentityId, fromDate, toDate, programIds);
    }

    public long getScoreByIdentityId(String earnerIdentityId) {
        return this.gamificationHistoryDAO.getScoreByIdentityId(earnerIdentityId);
    }

    public Map<Long, Long> getScoresByIdentityIdsAndBetweenDates(List<String> earnersId, Date fromDate, Date toDate) {
        return this.gamificationHistoryDAO.getScoreByIdentityIdsAndBetweenDates(earnersId, fromDate, toDate);
    }

    public RealizationDTO findLastRealizationByRuleIdAndEarnerIdAndReceiverAndObjectId(long ruleId, String earnerId, String receiverId, String objectId, String objectType) {
        Long id = this.gamificationHistoryDAO.findLastRealizationByRuleIdAndEarnerIdAndReceiverAndObjectId(ruleId, earnerId, receiverId, objectId, objectType);
        return id == null || id == 0L ? null : this.getRealizationById(id);
    }

    public int countRealizationsByRuleIdAndEarnerId(String earnerIdentityId, long ruleId) {
        return this.gamificationHistoryDAO.countRealizationsByRuleIdAndEarnerId(earnerIdentityId, ruleId);
    }

    public int countRealizationsInPeriod(String earnerIdentityId, long ruleId, Date sinceDate) {
        return this.gamificationHistoryDAO.countRealizationsInPeriod(earnerIdentityId, ruleId, sinceDate);
    }

    public List<Long> getParticipantsBetweenDates(Date fromDate, Date toDate) {
        return this.gamificationHistoryDAO.getParticipantsBetweenDates(fromDate, toDate);
    }

    public long countParticipantsBetweenDates(Date fromDate, Date toDate) {
        return this.gamificationHistoryDAO.countParticipantsBetweenDates(fromDate, toDate);
    }
}

