/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.search;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.wiki.service.search.SearchResultType;

public class SearchResult {
    private static Log log = ExoLogger.getLogger(SearchResult.class);
    protected String wikiType;
    protected String wikiOwner;
    protected Identity wikiOwnerIdentity;
    protected Identity poster;
    protected String pageName;
    protected String attachmentName;
    protected String excerpt;
    protected String title;
    protected SearchResultType type;
    protected String url;
    protected long score;
    protected Calendar updatedDate;
    protected Calendar createdDate;
    protected Map<String, List<MetadataItem>> metadata;
    protected String lang;

    public SearchResult() {
    }

    public SearchResult(String wikiType, String wikiOwner, String pageName, String attachmentName, String excerpt, String title, SearchResultType type, Calendar updatedDate, Calendar createdDate) {
        this.wikiType = wikiType;
        this.wikiOwner = wikiOwner;
        this.pageName = pageName;
        this.attachmentName = attachmentName;
        this.excerpt = excerpt;
        this.title = title;
        this.type = type;
        this.updatedDate = updatedDate;
        this.createdDate = createdDate;
    }

    public SearchResult(String wikiType, Identity poster, Identity wikiOwnerIdentity, String pageName, String attachmentName, String excerpt, String title, SearchResultType type, Calendar updatedDate, Calendar createdDate) {
        this.wikiType = wikiType;
        this.poster = poster;
        this.wikiOwnerIdentity = wikiOwnerIdentity;
        this.pageName = pageName;
        this.attachmentName = attachmentName;
        this.excerpt = excerpt;
        this.title = title;
        this.type = type;
        this.updatedDate = updatedDate;
        this.createdDate = createdDate;
    }

    public String getExcerpt() {
        try {
            return HTMLSanitizer.sanitize((String)this.excerpt);
        }
        catch (Exception e) {
            log.error((Object)("Fail to sanitize input [" + this.excerpt + "], " + e.getMessage()), (Throwable)e);
            return "";
        }
    }

    @Generated
    public String getWikiType() {
        return this.wikiType;
    }

    @Generated
    public String getWikiOwner() {
        return this.wikiOwner;
    }

    @Generated
    public Identity getWikiOwnerIdentity() {
        return this.wikiOwnerIdentity;
    }

    @Generated
    public Identity getPoster() {
        return this.poster;
    }

    @Generated
    public String getPageName() {
        return this.pageName;
    }

    @Generated
    public String getAttachmentName() {
        return this.attachmentName;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public SearchResultType getType() {
        return this.type;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public long getScore() {
        return this.score;
    }

    @Generated
    public Calendar getUpdatedDate() {
        return this.updatedDate;
    }

    @Generated
    public Calendar getCreatedDate() {
        return this.createdDate;
    }

    @Generated
    public Map<String, List<MetadataItem>> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getLang() {
        return this.lang;
    }

    @Generated
    public void setWikiType(String wikiType) {
        this.wikiType = wikiType;
    }

    @Generated
    public void setWikiOwner(String wikiOwner) {
        this.wikiOwner = wikiOwner;
    }

    @Generated
    public void setWikiOwnerIdentity(Identity wikiOwnerIdentity) {
        this.wikiOwnerIdentity = wikiOwnerIdentity;
    }

    @Generated
    public void setPoster(Identity poster) {
        this.poster = poster;
    }

    @Generated
    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    @Generated
    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    @Generated
    public void setExcerpt(String excerpt) {
        this.excerpt = excerpt;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setType(SearchResultType type) {
        this.type = type;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setScore(long score) {
        this.score = score;
    }

    @Generated
    public void setUpdatedDate(Calendar updatedDate) {
        this.updatedDate = updatedDate;
    }

    @Generated
    public void setCreatedDate(Calendar createdDate) {
        this.createdDate = createdDate;
    }

    @Generated
    public void setMetadata(Map<String, List<MetadataItem>> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setLang(String lang) {
        this.lang = lang;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchResult)) {
            return false;
        }
        SearchResult other = (SearchResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getScore() != other.getScore()) {
            return false;
        }
        String this$wikiType = this.getWikiType();
        String other$wikiType = other.getWikiType();
        if (this$wikiType == null ? other$wikiType != null : !this$wikiType.equals(other$wikiType)) {
            return false;
        }
        String this$wikiOwner = this.getWikiOwner();
        String other$wikiOwner = other.getWikiOwner();
        if (this$wikiOwner == null ? other$wikiOwner != null : !this$wikiOwner.equals(other$wikiOwner)) {
            return false;
        }
        Identity this$wikiOwnerIdentity = this.getWikiOwnerIdentity();
        Identity other$wikiOwnerIdentity = other.getWikiOwnerIdentity();
        if (this$wikiOwnerIdentity == null ? other$wikiOwnerIdentity != null : !this$wikiOwnerIdentity.equals(other$wikiOwnerIdentity)) {
            return false;
        }
        Identity this$poster = this.getPoster();
        Identity other$poster = other.getPoster();
        if (this$poster == null ? other$poster != null : !this$poster.equals(other$poster)) {
            return false;
        }
        String this$pageName = this.getPageName();
        String other$pageName = other.getPageName();
        if (this$pageName == null ? other$pageName != null : !this$pageName.equals(other$pageName)) {
            return false;
        }
        String this$attachmentName = this.getAttachmentName();
        String other$attachmentName = other.getAttachmentName();
        if (this$attachmentName == null ? other$attachmentName != null : !this$attachmentName.equals(other$attachmentName)) {
            return false;
        }
        String this$excerpt = this.getExcerpt();
        String other$excerpt = other.getExcerpt();
        if (this$excerpt == null ? other$excerpt != null : !this$excerpt.equals(other$excerpt)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        SearchResultType this$type = this.getType();
        SearchResultType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Calendar this$updatedDate = this.getUpdatedDate();
        Calendar other$updatedDate = other.getUpdatedDate();
        if (this$updatedDate == null ? other$updatedDate != null : !((Object)this$updatedDate).equals(other$updatedDate)) {
            return false;
        }
        Calendar this$createdDate = this.getCreatedDate();
        Calendar other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        Map<String, List<MetadataItem>> this$metadata = this.getMetadata();
        Map<String, List<MetadataItem>> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        return !(this$lang == null ? other$lang != null : !this$lang.equals(other$lang));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SearchResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $score = this.getScore();
        result = result * 59 + (int)($score >>> 32 ^ $score);
        String $wikiType = this.getWikiType();
        result = result * 59 + ($wikiType == null ? 43 : $wikiType.hashCode());
        String $wikiOwner = this.getWikiOwner();
        result = result * 59 + ($wikiOwner == null ? 43 : $wikiOwner.hashCode());
        Identity $wikiOwnerIdentity = this.getWikiOwnerIdentity();
        result = result * 59 + ($wikiOwnerIdentity == null ? 43 : $wikiOwnerIdentity.hashCode());
        Identity $poster = this.getPoster();
        result = result * 59 + ($poster == null ? 43 : $poster.hashCode());
        String $pageName = this.getPageName();
        result = result * 59 + ($pageName == null ? 43 : $pageName.hashCode());
        String $attachmentName = this.getAttachmentName();
        result = result * 59 + ($attachmentName == null ? 43 : $attachmentName.hashCode());
        String $excerpt = this.getExcerpt();
        result = result * 59 + ($excerpt == null ? 43 : $excerpt.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        SearchResultType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Calendar $updatedDate = this.getUpdatedDate();
        result = result * 59 + ($updatedDate == null ? 43 : ((Object)$updatedDate).hashCode());
        Calendar $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        Map<String, List<MetadataItem>> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SearchResult(wikiType=" + this.getWikiType() + ", wikiOwner=" + this.getWikiOwner() + ", wikiOwnerIdentity=" + String.valueOf(this.getWikiOwnerIdentity()) + ", poster=" + String.valueOf(this.getPoster()) + ", pageName=" + this.getPageName() + ", attachmentName=" + this.getAttachmentName() + ", excerpt=" + this.getExcerpt() + ", title=" + this.getTitle() + ", type=" + String.valueOf((Object)this.getType()) + ", url=" + this.getUrl() + ", score=" + this.getScore() + ", updatedDate=" + String.valueOf(this.getUpdatedDate()) + ", createdDate=" + String.valueOf(this.getCreatedDate()) + ", metadata=" + String.valueOf(this.getMetadata()) + ", lang=" + this.getLang() + ")";
    }
}

