/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UISiteBody;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;

@ComponentConfig
public class UISharedLayout
extends UIContainer {
    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        PortalRequestContext portalRequestContext = PortalRequestContext.getCurrentInstance();
        portalRequestContext.startServerTime("UISharedLayout");
        try {
            if (this.isShowSharedLayout(portalRequestContext)) {
                this.processContainerRender(context);
            } else {
                this.processSiteBodyRender(context);
            }
        }
        finally {
            portalRequestContext.endServerTime("UISharedLayout");
        }
    }

    public boolean isShowSharedLayout(PortalRequestContext requestContext) {
        boolean showSharedLayout;
        boolean bl = showSharedLayout = !requestContext.isHideSharedLayout() && !this.hidePageSharedLayout();
        if (requestContext.getUserPortalConfig() != null && requestContext.getUserPortalConfig().getPortalConfig() != null) {
            showSharedLayout = showSharedLayout && requestContext.getSiteType() != SiteType.GROUP_TEMPLATE && requestContext.getSiteType() != SiteType.PORTAL_TEMPLATE && (requestContext.getSiteType() != SiteType.PORTAL || this.showSiteSharedLayout(requestContext) || this.showPageSharedLayout());
        }
        return showSharedLayout;
    }

    protected void processSiteBodyRender(WebuiRequestContext context) throws Exception {
        UISiteBody uiSiteBody = this.findFirstComponentOfType(UISiteBody.class);
        uiSiteBody.processRender(context);
    }

    protected void processContainerRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    private boolean showSiteSharedLayout(PortalRequestContext requestContext) {
        return requestContext.getUserPortalConfig().getPortalConfig().isDisplayed();
    }

    private boolean hidePageSharedLayout() {
        return Util.getUIPage() != null && Util.getUIPage().isHideSharedLayout();
    }

    private boolean showPageSharedLayout() {
        return !this.hidePageSharedLayout() && Util.getUIPage() != null && Util.getUIPage().isShowSharedLayout();
    }
}

