/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.model.SiteTemplate;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.util.EntityMapper;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteFilter;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.attachment.AttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SiteTemplateService {
    public static final String SITE_TEMPLATE_BASE = "basic";
    public static final String TEMPLATE_CREATED_EVENT = "layout.siteTemplate.created";
    public static final String TEMPLATE_UPDATED_EVENT = "layout.siteTemplate.updated";
    public static final String TEMPLATE_DELETED_EVENT = "layout.siteTemplate.deleted";
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private NavigationService navigationService;
    @Autowired
    private UserPortalConfigService portalConfigService;
    @Autowired
    private LayoutAclService aclService;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private ListenerService listenerService;

    public List<SiteTemplate> getSiteTemplates(Locale locale) {
        SiteFilter siteFilter = new SiteFilter();
        siteFilter.setSiteType(SiteType.PORTAL_TEMPLATE);
        List sites = this.layoutService.getSites(siteFilter);
        return sites.stream().map(s -> this.toSiteTemplateDetails((PortalConfig)s, locale)).toList();
    }

    public SiteTemplate getSiteTemplate(long id) throws ObjectNotFoundException {
        return this.getSiteTemplate(id, null);
    }

    public SiteTemplate getSiteTemplate(long id, Locale locale) throws ObjectNotFoundException {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(id);
        if (portalConfig == null || !StringUtils.equalsIgnoreCase((CharSequence)portalConfig.getType(), (CharSequence)PortalConfig.PORTAL_TEMPLATE)) {
            throw new ObjectNotFoundException(String.format("Site Template with id %s doesn't exists", id));
        }
        return this.toSiteTemplateDetails(portalConfig, locale);
    }

    public SiteTemplate createSiteTemplate(SiteTemplate siteTemplate, String username) throws IllegalAccessException, ObjectAlreadyExistsException {
        if (!this.aclService.isAdministrator(username)) {
            throw new IllegalAccessException();
        }
        if (this.layoutService.getPortalConfig(SiteKey.portalTemplate((String)siteTemplate.getLayout())) != null) {
            throw new ObjectAlreadyExistsException((Object)String.format("Site Template with name %s already exists", siteTemplate.getLayout()));
        }
        return this.createSiteTemplate(siteTemplate, null, username, true);
    }

    public SiteTemplate createSiteTemplate(SiteTemplate siteTemplate) {
        return this.createSiteTemplate(siteTemplate, null, null, true);
    }

    public SiteTemplate updateSiteTemplate(SiteTemplate siteTemplate, String username) throws IllegalAccessException, ObjectNotFoundException {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteTemplate.getId());
        if (portalConfig == null || !StringUtils.equalsIgnoreCase((CharSequence)portalConfig.getType(), (CharSequence)PortalConfig.PORTAL_TEMPLATE)) {
            throw new ObjectNotFoundException(String.format("Site with id %s doesn't exist", siteTemplate.getId()));
        }
        if (!this.aclService.isAdministrator(username)) {
            throw new IllegalAccessException();
        }
        return this.updateSiteTemplate(siteTemplate, username, true);
    }

    public SiteTemplate updateSiteTemplate(SiteTemplate siteTemplate) {
        return this.updateSiteTemplate(siteTemplate, null, true);
    }

    public void deleteSiteTemplate(long id, String username) throws IllegalAccessException, ObjectNotFoundException {
        SiteTemplate siteTemplate = this.getSiteTemplate(id);
        if (!this.aclService.isAdministrator(username) || siteTemplate.isSystem()) {
            throw new IllegalAccessException(String.format("Site with id %s can't be deleted by user %s", id, username));
        }
        SiteKey siteKey = SiteKey.portalTemplate((String)siteTemplate.getLayout());
        this.navigationService.destroyNavigation(siteKey);
        this.layoutService.removePages(siteKey);
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        this.layoutService.remove(portalConfig);
        this.listenerService.broadcast(TEMPLATE_DELETED_EVENT, (Object)siteTemplate, (Object)username);
    }

    public SiteTemplate saveAsSiteTemplate(SiteTemplate siteTemplate, long siteId, String username) throws IllegalAccessException, ObjectNotFoundException, ObjectAlreadyExistsException {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteId);
        if (portalConfig == null) {
            throw new ObjectNotFoundException(String.format("Site with id %s doesn't exists", siteId));
        }
        if (!this.aclService.isAdministrator(username)) {
            throw new IllegalAccessException();
        }
        if (this.layoutService.getPortalConfig(SiteKey.portalTemplate((String)siteTemplate.getLayout())) != null) {
            throw new ObjectAlreadyExistsException((Object)String.format("Site Template with name %s already exists", siteTemplate.getLayout()));
        }
        return this.createSiteTemplate(siteTemplate, new SiteKey(portalConfig.getType(), portalConfig.getName()), username, true);
    }

    private SiteTemplate createSiteTemplate(SiteTemplate siteTemplate, SiteKey sourceSiteKey, String username, boolean broadcast) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(SiteKey.portalTemplate((String)siteTemplate.getLayout()));
        if (portalConfig == null) {
            this.portalConfigService.createSiteFromTemplate(sourceSiteKey == null ? SiteKey.portalTemplate((String)SITE_TEMPLATE_BASE) : sourceSiteKey, SiteKey.portalTemplate((String)siteTemplate.getLayout()));
            portalConfig = this.layoutService.getPortalConfig(SiteKey.portalTemplate((String)siteTemplate.getLayout()));
        }
        siteTemplate.setId(portalConfig.getId());
        SiteTemplate createdSiteTemplate = this.updateSiteTemplate(siteTemplate, portalConfig);
        if (broadcast) {
            this.listenerService.broadcast(TEMPLATE_CREATED_EVENT, (Object)createdSiteTemplate, (Object)username);
        }
        return createdSiteTemplate;
    }

    private SiteTemplate updateSiteTemplate(SiteTemplate siteTemplate, String username, boolean broadcast) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteTemplate.getId());
        SiteTemplate updatedSiteTemplate = this.updateSiteTemplate(siteTemplate, portalConfig);
        if (broadcast) {
            this.listenerService.broadcast(TEMPLATE_UPDATED_EVENT, (Object)updatedSiteTemplate, (Object)username);
        }
        return updatedSiteTemplate;
    }

    private SiteTemplate updateSiteTemplate(SiteTemplate siteTemplate, PortalConfig portalConfig) {
        portalConfig.setLabel(siteTemplate.getName());
        portalConfig.setDescription(siteTemplate.getDescription());
        portalConfig.setRemovable(!siteTemplate.isSystem());
        portalConfig.setIcon(siteTemplate.getIcon());
        portalConfig.setAccessPermissions(new String[]{"Everyone"});
        portalConfig.setEditPermission(this.getAdministratorsPermission());
        portalConfig.setProperty("SITE_ENABLED", String.valueOf(!siteTemplate.isDisabled()));
        this.layoutService.save(portalConfig);
        return this.toSiteTemplateDetails(portalConfig, null);
    }

    private SiteTemplate toSiteTemplateDetails(PortalConfig portalConfig, Locale locale) {
        SiteTemplate siteTemplate = EntityMapper.toSiteTemplate(portalConfig);
        if (locale != null) {
            this.computeSiteTemplateAttributes(locale, portalConfig, siteTemplate);
        }
        return siteTemplate;
    }

    private void computeSiteTemplateAttributes(Locale locale, PortalConfig portalConfig, SiteTemplate siteTemplate) {
        siteTemplate.setName(this.translationService.getTranslationLabelOrDefault("siteTemplate", portalConfig.getId(), "title", locale));
        siteTemplate.setDescription(this.translationService.getTranslationLabelOrDefault("siteTemplate", portalConfig.getId(), "description", locale));
        siteTemplate.setIllustrationId(this.getSiteTemplateAttributes(portalConfig.getId()));
    }

    private long getSiteTemplateAttributes(long siteTemplateId) {
        List attachmentFileIds = this.attachmentService.getAttachmentFileIds("siteTemplate", String.valueOf(siteTemplateId));
        if (CollectionUtils.isNotEmpty((Collection)attachmentFileIds)) {
            return Long.parseLong((String)attachmentFileIds.get(0));
        }
        return 0L;
    }

    private String getAdministratorsPermission() {
        return "*:" + this.aclService.getAdministratorsGroup();
    }
}

