/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity.mutation;

import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;

public class EntityTableMapping
implements TableMapping {
    private final String tableName;
    private final int relativePosition;
    private final KeyMapping keyMapping;
    private final BitSet flags = new BitSet();
    private final int[] attributeIndexes;
    private final TableMapping.MutationDetails insertDetails;
    private final TableMapping.MutationDetails updateDetails;
    private final TableMapping.MutationDetails deleteDetails;

    public EntityTableMapping(String tableName, int relativePosition, KeyMapping keyMapping, boolean isOptional, boolean isInverse, boolean isIdentifierTable, int[] attributeIndexes, Expectation insertExpectation, String insertCustomSql, boolean insertCallable, Expectation updateExpectation, String updateCustomSql, boolean updateCallable, boolean cascadeDeleteEnabled, Expectation deleteExpectation, String deleteCustomSql, boolean deleteCallable, boolean dynamicUpdate, boolean dynamicInsert) {
        this.tableName = tableName;
        this.relativePosition = relativePosition;
        this.keyMapping = keyMapping;
        this.attributeIndexes = attributeIndexes;
        this.insertDetails = new TableMapping.MutationDetails(MutationType.INSERT, insertExpectation, insertCustomSql, insertCallable, dynamicInsert);
        this.updateDetails = new TableMapping.MutationDetails(MutationType.UPDATE, updateExpectation, updateCustomSql, updateCallable, dynamicUpdate);
        this.deleteDetails = new TableMapping.MutationDetails(MutationType.DELETE, deleteExpectation, deleteCustomSql, deleteCallable);
        if (isOptional) {
            this.flags.set(Flag.OPTIONAL.ordinal());
        }
        if (isInverse) {
            this.flags.set(Flag.INVERSE.ordinal());
        }
        if (isIdentifierTable) {
            this.flags.set(Flag.ID_TABLE.ordinal());
        }
        if (cascadeDeleteEnabled) {
            this.flags.set(Flag.CASCADE_DELETE.ordinal());
        }
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public TableDetails.KeyDetails getKeyDetails() {
        return this.keyMapping;
    }

    @Override
    public int getRelativePosition() {
        return this.relativePosition;
    }

    @Override
    public boolean isOptional() {
        return this.flags.get(Flag.OPTIONAL.ordinal());
    }

    @Override
    public boolean isInverse() {
        return this.flags.get(Flag.INVERSE.ordinal());
    }

    @Override
    public boolean isIdentifierTable() {
        return this.flags.get(Flag.ID_TABLE.ordinal());
    }

    public KeyMapping getKeyMapping() {
        return this.keyMapping;
    }

    public boolean hasColumns() {
        return this.attributeIndexes.length > 0;
    }

    public boolean containsAttributeColumns(int attributeIndex) {
        return ArrayHelper.contains(this.attributeIndexes, attributeIndex);
    }

    public int[] getAttributeIndexes() {
        return this.attributeIndexes;
    }

    @Override
    public TableMapping.MutationDetails getInsertDetails() {
        return this.insertDetails;
    }

    public Expectation getInsertExpectation() {
        return this.getInsertDetails().getExpectation();
    }

    public String getInsertCustomSql() {
        return this.getInsertDetails().getCustomSql();
    }

    public boolean isInsertCallable() {
        return this.getInsertDetails().isCallable();
    }

    @Override
    public TableMapping.MutationDetails getUpdateDetails() {
        return this.updateDetails;
    }

    public Expectation getUpdateExpectation() {
        return this.getUpdateDetails().getExpectation();
    }

    public String getUpdateCustomSql() {
        return this.getUpdateDetails().getCustomSql();
    }

    public boolean isUpdateCallable() {
        return this.getUpdateDetails().isCallable();
    }

    @Override
    public boolean isCascadeDeleteEnabled() {
        return this.flags.get(Flag.CASCADE_DELETE.ordinal());
    }

    @Override
    public TableMapping.MutationDetails getDeleteDetails() {
        return this.deleteDetails;
    }

    public Expectation getDeleteExpectation() {
        return this.getDeleteDetails().getExpectation();
    }

    public String getDeleteCustomSql() {
        return this.getDeleteDetails().getCustomSql();
    }

    public boolean isDeleteCallable() {
        return this.getDeleteDetails().isCallable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityTableMapping that = (EntityTableMapping)o;
        return this.tableName.equals(that.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.tableName);
    }

    public String toString() {
        return "TableMapping(" + this.tableName + ")";
    }

    public static class KeyColumn
    implements TableDetails.KeyColumn {
        private final String tableName;
        private final String columnName;
        private final String writeExpression;
        private final boolean formula;
        private final JdbcMapping jdbcMapping;

        public KeyColumn(String tableName, String columnName, String writeExpression, boolean formula, JdbcMapping jdbcMapping) {
            this.tableName = tableName;
            this.columnName = columnName;
            this.writeExpression = writeExpression;
            this.formula = formula;
            this.jdbcMapping = jdbcMapping;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public String getContainingTableExpression() {
            return this.tableName;
        }

        @Override
        public String getWriteExpression() {
            return this.writeExpression;
        }

        @Override
        public String getSelectionExpression() {
            return this.columnName;
        }

        @Override
        public JdbcMapping getJdbcMapping() {
            return this.jdbcMapping;
        }

        @Override
        public boolean isFormula() {
            return this.formula;
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public boolean isInsertable() {
            return !this.formula;
        }

        @Override
        public boolean isUpdateable() {
            return false;
        }

        @Override
        public boolean isPartitioned() {
            return false;
        }

        @Override
        public String getColumnDefinition() {
            return null;
        }

        @Override
        public Long getLength() {
            return null;
        }

        @Override
        public Integer getPrecision() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public Integer getTemporalPrecision() {
            return null;
        }

        @Override
        public String getCustomReadExpression() {
            return null;
        }

        @Override
        public String getCustomWriteExpression() {
            return null;
        }
    }

    public static class KeyMapping
    implements TableDetails.KeyDetails,
    SelectableMappings {
        private final List<KeyColumn> keyColumns;
        private final ModelPart identifierPart;

        public KeyMapping(List<KeyColumn> keyColumns, ModelPart identifierPart) {
            assert (keyColumns.size() == identifierPart.getJdbcTypeCount());
            this.keyColumns = keyColumns;
            this.identifierPart = identifierPart;
        }

        public void breakDownKeyJdbcValues(Object domainValue, KeyValueConsumer valueConsumer, SharedSessionContractImplementor session) {
            this.identifierPart.forEachJdbcValue(domainValue, this.keyColumns, valueConsumer, (selectionIndex, keys, consumer, jdbcValue, jdbcMapping) -> consumer.consume(jdbcValue, (KeyColumn)keys.get(selectionIndex)), session);
        }

        @Override
        public int getColumnCount() {
            return this.keyColumns.size();
        }

        public List<KeyColumn> getKeyColumns() {
            return this.keyColumns;
        }

        @Override
        public KeyColumn getKeyColumn(int position) {
            return this.keyColumns.get(position);
        }

        @Override
        public void forEachKeyColumn(TableDetails.KeyColumnConsumer consumer) {
            for (int i = 0; i < this.keyColumns.size(); ++i) {
                consumer.consume(i, this.keyColumns.get(i));
            }
        }

        public void forEachKeyColumn(Consumer<KeyColumn> keyColumnConsumer) {
            this.keyColumns.forEach(keyColumnConsumer);
        }

        @Override
        public int getJdbcTypeCount() {
            return this.keyColumns.size();
        }

        @Override
        public SelectableMapping getSelectable(int columnIndex) {
            return this.keyColumns.get(columnIndex);
        }

        @Override
        public int forEachSelectable(int offset, SelectableConsumer consumer) {
            for (int i = 0; i < this.keyColumns.size(); ++i) {
                consumer.accept(i, this.keyColumns.get(i));
            }
            return this.getJdbcTypeCount();
        }
    }

    @FunctionalInterface
    public static interface KeyValueConsumer {
        public void consume(Object var1, KeyColumn var2);
    }

    private static enum Flag {
        OPTIONAL,
        INVERSE,
        ID_TABLE,
        CASCADE_DELETE;

    }
}

