/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.application;

import io.meeds.portal.application.model.StaticApplicationState;
import jakarta.servlet.ServletContext;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.PortalStateManager;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;

public class StaticPortalStateManager
extends PortalStateManager {
    private static final String PORTAL_STATIC_WEB_UI_FEATURE = "portal.staticWebUIComponents";
    private static final String APPLICATION_ATTRIBUTE_PREFIX = "portal.";
    private ExoFeatureService featureService;

    @Override
    public UIApplication restoreUIRootComponent(WebuiRequestContext context) {
        if (this.getFeatureService().isActiveFeature(PORTAL_STATIC_WEB_UI_FEATURE)) {
            context.setStateManager(this);
            WebuiApplication app = (WebuiApplication)context.getApplication();
            ServletContext servletContext = this.getServletContext();
            String key = this.getStaticKey(context);
            StaticApplicationState appState = null;
            if (servletContext != null) {
                appState = (StaticApplicationState)servletContext.getAttribute(APPLICATION_ATTRIBUTE_PREFIX + key);
            }
            return appState == null ? this.createStaticUIApplication(context, app) : appState.getApplication();
        }
        return super.restoreUIRootComponent(context);
    }

    @Override
    public void storeUIRootComponent(WebuiRequestContext context) {
        if (this.getFeatureService().isActiveFeature(PORTAL_STATIC_WEB_UI_FEATURE)) {
            UIApplication uiapp = context.getUIApplication();
            if (uiapp != null) {
                this.getServletContext().setAttribute(APPLICATION_ATTRIBUTE_PREFIX + this.getStaticKey(context), (Object)new StaticApplicationState(uiapp));
            }
        } else {
            super.storeUIRootComponent(context);
        }
    }

    private UIApplication createStaticUIApplication(WebuiRequestContext context, WebuiApplication app) {
        String uiRootClass = app.getConfigurationManager().getApplication().getUIRootComponent().trim();
        Class<?> type = Class.forName(uiRootClass, true, Thread.currentThread().getContextClassLoader());
        return (UIApplication)app.createUIComponent(type, null, null, context);
    }

    private String getStaticKey(WebuiRequestContext webuiRC) {
        if (webuiRC instanceof PortletRequestContext) {
            PortletRequestContext portletRC = (PortletRequestContext)webuiRC;
            return portletRC.getApplication().getApplicationId() + "/" + portletRC.getWindowId();
        }
        return "PortalApplication";
    }

    private ServletContext getServletContext() {
        return PortalRequestContext.getCurrentInstance().getRequest().getServletContext();
    }

    public ExoFeatureService getFeatureService() {
        if (this.featureService == null) {
            this.featureService = (ExoFeatureService)ExoContainerContext.getService(ExoFeatureService.class);
        }
        return this.featureService;
    }
}

