/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.entity;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.exoplatform.social.core.jpa.storage.entity.ProfilePropertyOptionEntity;
import org.hibernate.annotations.BatchSize;

@Entity(name="SocProfileSettingEntity")
@Table(name="SOC_PROFILE_PROPERTY_SETTING ")
@NamedQueries(value={@NamedQuery(name="SocProfileSettingEntity.findProfileSettingByName", query="SELECT c FROM SocProfileSettingEntity c WHERE c.propertyName = :name"), @NamedQuery(name="SocProfileSettingEntity.findSynchronizedSettings", query="SELECT c FROM SocProfileSettingEntity c WHERE c.isGroupSynchronized = true"), @NamedQuery(name="SocProfileSettingEntity.findOrderedSettings", query="SELECT c FROM SocProfileSettingEntity c order by c.order"), @NamedQuery(name="SocProfileSettingEntity.countChildProperties", query="SELECT COUNT(c) FROM SocProfileSettingEntity c WHERE c.parentId = :id")})
public class ProfilePropertySettingEntity
implements Serializable {
    private static final long serialVersionUID = -2657229462239171339L;
    @Id
    @SequenceGenerator(name="SEQ_SOC_PROPERTY_SETTING_ID", sequenceName="SEQ_SOC_PROPERTY_SETTING_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SOC_PROPERTY_SETTING_ID")
    @Column(name="PROPERTY_SETTING_ID")
    private Long id;
    @Column(name="PROPERTY_NAME", nullable=false)
    private String propertyName;
    @Column(name="VISIBLE")
    private boolean isVisible;
    @Column(name="EDITABLE")
    private boolean isEditable;
    @Column(name="PARENT_ID")
    private Long parentId;
    @Column(name="PROPERTY_ORDER")
    private Long order;
    @Column(name="ACTIVE")
    private boolean isActive;
    @Column(name="REQUIRED_PROPERTY")
    private boolean isRequired;
    @Column(name="MULTI_VALUED")
    private boolean isMultiValued;
    @Column(name="GROUP_SYNCHRONIZED")
    private boolean isGroupSynchronized;
    @Column(name="IS_HIDDENABLE")
    private boolean isHiddenable;
    @Column(name="IS_DROPDOWN")
    private boolean isDropdownList;
    @Column(name="INDEX_IN_ANALYTICS")
    private boolean indexInAnalytics;
    @Column(name="PROPERTY_TYPE")
    private String propertyType;
    @BatchSize(size=10)
    @OneToMany(mappedBy="propertySetting", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<ProfilePropertyOptionEntity> propertyOptions;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="UPDATED_DATE", nullable=false)
    private Date updatedDate = new Date();

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getId().toString());
        builder.append(":").append(this.getPropertyName());
        builder.append(":").append(this.isEditable());
        builder.append(":").append(this.isActive());
        builder.append(":").append(this.isDropdownList());
        builder.append(":").append(this.isVisible());
        builder.append(":").append(this.getOrder());
        builder.append(":").append(this.isMultiValued());
        builder.append(":").append(this.isRequired());
        builder.append(":").append(this.isGroupSynchronized());
        builder.append(":").append(this.isHiddenable());
        builder.append(":").append(this.isIndexInAnalytics());
        builder.append(":").append(this.getPropertyType());
        builder.append(":").append(this.getParentId());
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfilePropertySettingEntity other = (ProfilePropertySettingEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Generated
    public ProfilePropertySettingEntity() {
    }

    @Generated
    public ProfilePropertySettingEntity(Long id, String propertyName, boolean isVisible, boolean isEditable, Long parentId, Long order, boolean isActive, boolean isRequired, boolean isMultiValued, boolean isGroupSynchronized, boolean isHiddenable, boolean isDropdownList, boolean indexInAnalytics, String propertyType, List<ProfilePropertyOptionEntity> propertyOptions, Date updatedDate) {
        this.id = id;
        this.propertyName = propertyName;
        this.isVisible = isVisible;
        this.isEditable = isEditable;
        this.parentId = parentId;
        this.order = order;
        this.isActive = isActive;
        this.isRequired = isRequired;
        this.isMultiValued = isMultiValued;
        this.isGroupSynchronized = isGroupSynchronized;
        this.isHiddenable = isHiddenable;
        this.isDropdownList = isDropdownList;
        this.indexInAnalytics = indexInAnalytics;
        this.propertyType = propertyType;
        this.propertyOptions = propertyOptions;
        this.updatedDate = updatedDate;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getPropertyName() {
        return this.propertyName;
    }

    @Generated
    public boolean isVisible() {
        return this.isVisible;
    }

    @Generated
    public boolean isEditable() {
        return this.isEditable;
    }

    @Generated
    public Long getParentId() {
        return this.parentId;
    }

    @Generated
    public Long getOrder() {
        return this.order;
    }

    @Generated
    public boolean isActive() {
        return this.isActive;
    }

    @Generated
    public boolean isRequired() {
        return this.isRequired;
    }

    @Generated
    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    @Generated
    public boolean isGroupSynchronized() {
        return this.isGroupSynchronized;
    }

    @Generated
    public boolean isHiddenable() {
        return this.isHiddenable;
    }

    @Generated
    public boolean isDropdownList() {
        return this.isDropdownList;
    }

    @Generated
    public boolean isIndexInAnalytics() {
        return this.indexInAnalytics;
    }

    @Generated
    public String getPropertyType() {
        return this.propertyType;
    }

    @Generated
    public List<ProfilePropertyOptionEntity> getPropertyOptions() {
        return this.propertyOptions;
    }

    @Generated
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Generated
    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    @Generated
    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    @Generated
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    @Generated
    public void setOrder(Long order) {
        this.order = order;
    }

    @Generated
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Generated
    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Generated
    public void setMultiValued(boolean isMultiValued) {
        this.isMultiValued = isMultiValued;
    }

    @Generated
    public void setGroupSynchronized(boolean isGroupSynchronized) {
        this.isGroupSynchronized = isGroupSynchronized;
    }

    @Generated
    public void setHiddenable(boolean isHiddenable) {
        this.isHiddenable = isHiddenable;
    }

    @Generated
    public void setDropdownList(boolean isDropdownList) {
        this.isDropdownList = isDropdownList;
    }

    @Generated
    public void setIndexInAnalytics(boolean indexInAnalytics) {
        this.indexInAnalytics = indexInAnalytics;
    }

    @Generated
    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType;
    }

    @Generated
    public void setPropertyOptions(List<ProfilePropertyOptionEntity> propertyOptions) {
        this.propertyOptions = propertyOptions;
    }

    @Generated
    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }
}

