/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.util.function.BiConsumer;
import org.springframework.validation.Errors;
import org.springframework.validation.SimpleErrors;
import org.springframework.validation.TypedValidator;

public interface Validator {
    public boolean supports(Class<?> var1);

    public void validate(Object var1, Errors var2);

    default public Errors validateObject(Object target) {
        SimpleErrors errors = new SimpleErrors(target);
        this.validate(target, errors);
        return errors;
    }

    public static <T> Validator forInstanceOf(Class<T> targetClass, BiConsumer<T, Errors> delegate) {
        return new TypedValidator<T>(targetClass, targetClass::isAssignableFrom, delegate);
    }

    public static <T> Validator forType(Class<T> targetClass, BiConsumer<T, Errors> delegate) {
        return new TypedValidator<T>(targetClass, targetClass::equals, delegate);
    }
}

