/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.openid;

import com.github.scribejava.core.model.OAuth2AccessToken;
import io.meeds.oauth.spi.AccessTokenContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class OpenIdAccessTokenContext
extends AccessTokenContext
implements Serializable {
    private static final long serialVersionUID = -7038197192745766989L;
    public final OAuth2AccessToken accessToken;
    private Map<String, String> customClaims;

    public OpenIdAccessTokenContext(OAuth2AccessToken tokenData, String ... scopes) {
        super(scopes);
        if (tokenData == null) {
            throw new IllegalArgumentException("tokenData can't be null");
        }
        this.customClaims = new HashMap<String, String>();
        this.accessToken = tokenData;
    }

    public OpenIdAccessTokenContext(OAuth2AccessToken tokenData, String scopeAsString) {
        super(scopeAsString);
        if (tokenData == null) {
            throw new IllegalArgumentException("tokenData can't be null");
        }
        this.customClaims = new HashMap<String, String>();
        this.accessToken = tokenData;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken.getAccessToken();
    }

    public OAuth2AccessToken getTokenData() {
        return this.accessToken;
    }

    public void addCustomClaims(Map<String, String> newCustomClaims) {
        this.customClaims.putAll(newCustomClaims);
    }

    public Map<String, String> getCustomClaims() {
        return this.customClaims;
    }
}

