/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.github.plugin;

import io.meeds.gamification.plugin.EventPlugin;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class GithubEventPlugin
extends EventPlugin {
    public static final String EVENT_TYPE = "github";

    public String getEventType() {
        return EVENT_TYPE;
    }

    public List<String> getTriggers() {
        return List.of("addIssueLabel", "pushCode", "pullRequestValidated", "reviewPullRequest", "validatePullRequest", "creatPullRequest", "pullRequestReviewComment", "commentPullRequest", "createIssue", "addIssueLabel", "requestReviewForPullRequest", "commentIssue");
    }

    public boolean isValidEvent(Map<String, String> eventProperties, String triggerDetails) {
        String desiredOrganizationId = eventProperties.get("organizationId");
        List desiredRepositoryIds = eventProperties.get("repositoryIds") != null ? Arrays.asList(eventProperties.get("repositoryIds").split(",")) : Collections.emptyList();
        Map<String, String> triggerDetailsMop = GithubEventPlugin.stringToMap(triggerDetails);
        return desiredOrganizationId.equals(triggerDetailsMop.get("organizationId")) && (CollectionUtils.isEmpty(desiredRepositoryIds) || desiredRepositoryIds.contains(triggerDetailsMop.get("repositoryId")));
    }

    private static Map<String, String> stringToMap(String mapAsString) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        mapAsString = mapAsString.substring(1, mapAsString.length() - 1);
        for (String pair : pairs = mapAsString.split(", ")) {
            String[] keyValue = pair.split(": ");
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            map.put(key, value);
        }
        return map;
    }
}

