/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.es.client;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticClientException;
import org.exoplatform.commons.search.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.commons.search.es.client.ElasticResponse;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class ElasticClient {
    public static final int DEFAULT_MAX_HTTP_POOL_CONNECTIONS = 100;
    private static final String ES_INDEX_CLIENT_DEFAULT = "http://127.0.0.1:9200";
    private static final Log LOG = ExoLogger.getExoLogger(ElasticClient.class);
    protected String urlClient = "http://127.0.0.1:9200";
    protected HttpClient client;
    protected ElasticIndexingAuditTrail auditTrail;

    protected ElasticClient(ElasticIndexingAuditTrail auditTrail) {
        if (auditTrail == null) {
            throw new IllegalArgumentException("AuditTrail is null");
        }
        this.auditTrail = auditTrail;
    }

    protected ElasticResponse sendHttpPostRequest(String url, String content) {
        ElasticResponse response;
        try {
            HttpPost httpTypeRequest = new HttpPost(url);
            if (StringUtils.isNotBlank((CharSequence)content)) {
                httpTypeRequest.setEntity((HttpEntity)new StringEntity(content, ContentType.APPLICATION_JSON));
            }
            response = (ElasticResponse)this.client.execute((ClassicHttpRequest)httpTypeRequest, this::handleHttpResponse);
            LOG.debug("Sent request to ES:\n Method = POST \nURI =  {} \nContent = {}", new Object[]{url, content});
            this.logResultDependingOnStatusCode(url, response);
        }
        catch (IOException e) {
            throw new ElasticClientException(e);
        }
        return response;
    }

    protected ElasticResponse sendHttpPutRequest(String url, String content) {
        ElasticResponse response;
        try {
            HttpPut httpTypeRequest = new HttpPut(url);
            if (StringUtils.isNotBlank((CharSequence)content)) {
                httpTypeRequest.setEntity((HttpEntity)new StringEntity(content, ContentType.APPLICATION_JSON));
            }
            response = (ElasticResponse)this.client.execute((ClassicHttpRequest)httpTypeRequest, this::handleHttpResponse);
            LOG.debug("Sent request to ES:\n Method = PUT \nURI =  '{}' \nContent = '{}'", new Object[]{url, content});
            this.logResultDependingOnStatusCode(url, response);
        }
        catch (IOException e) {
            throw new ElasticClientException(e);
        }
        return response;
    }

    protected ElasticResponse sendHttpDeleteRequest(String url) {
        ElasticResponse response;
        try {
            HttpDelete httpDeleteRequest = new HttpDelete(url);
            response = (ElasticResponse)this.client.execute((ClassicHttpRequest)httpDeleteRequest, this::handleHttpResponse);
            LOG.debug("Sent request to ES:\n Method = DELETE \nURI =  {}", new Object[]{url});
            this.logResultDependingOnStatusCode(url, response);
        }
        catch (IOException e) {
            throw new ElasticClientException(e);
        }
        return response;
    }

    protected ElasticResponse sendHttpGetRequest(String url) {
        ElasticResponse response;
        try {
            HttpGet httpGetRequest = new HttpGet(url);
            response = (ElasticResponse)this.client.execute((ClassicHttpRequest)httpGetRequest, this::handleHttpResponse);
            LOG.debug("Sent request to ES:\n Method = GET \nURI =  {}", new Object[]{url});
        }
        catch (IOException e) {
            throw new ElasticClientException(e);
        }
        return response;
    }

    protected ElasticResponse sendHttpHeadRequest(String url) {
        ElasticResponse response;
        try {
            HttpHead httpHeadRequest = new HttpHead(url);
            response = (ElasticResponse)this.client.execute((ClassicHttpRequest)httpHeadRequest, this::handleHttpResponse);
            LOG.debug("Sent request to ES:\n Method = HEAD \nURI =  {}", new Object[]{url});
        }
        catch (IOException e) {
            throw new ElasticClientException(e);
        }
        return response;
    }

    protected void initHttpClient() {
        this.client = this.getHttpClient();
    }

    protected HttpClient getHttpClient() {
        HttpClientConnectionManager clientConnectionManager = this.getClientConnectionManager();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().disableAutomaticRetries().setConnectionManager(clientConnectionManager).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy());
        if (StringUtils.isNotBlank((CharSequence)this.getEsUsernameProperty())) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials(this.getEsUsernameProperty(), this.getEsPasswordProperty().toCharArray()));
            CloseableHttpClient httpClient = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            LOG.debug("Basic authentication for ES activated with username = {}", new Object[]{this.getEsUsernameProperty()});
            return httpClient;
        }
        LOG.debug((Object)"Basic authentication for ES not activated");
        return httpClientBuilder.build();
    }

    private ElasticResponse handleHttpResponse(ClassicHttpResponse httpResponse) throws IOException {
        HttpEntity entity = httpResponse.getEntity();
        int statusCode = httpResponse.getCode();
        try {
            return new ElasticResponse(EntityUtils.toString((HttpEntity)entity), statusCode);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Error while parsing http response with code " + statusCode + " and response " + entity, e);
        }
    }

    private void logResultDependingOnStatusCode(String url, ElasticResponse response) {
        if (ElasticIndexingAuditTrail.isError(response.getStatusCode())) {
            LOG.error("Error when trying to send request to ES. Url: {}, StatusCode: {}, Message: {}", new Object[]{url, response.getStatusCode(), response.getMessage()});
        } else {
            LOG.debug("Success request to ES. Url: {}, StatusCode: {}, Message: {}", new Object[]{url, response.getStatusCode(), response.getMessage()});
        }
    }

    protected abstract String getEsUsernameProperty();

    protected abstract String getEsPasswordProperty();

    protected abstract HttpClientConnectionManager getClientConnectionManager();

    protected int getMaxConnections() {
        return 100;
    }
}

