/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.config.NoSuchDataException;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.jdbc.entity.ComponentEntity;
import org.exoplatform.portal.jdbc.entity.PermissionEntity;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.mop.SiteFilter;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.dao.SiteDAO;
import org.exoplatform.portal.mop.importer.Status;
import org.exoplatform.portal.mop.storage.LayoutStorage;
import org.exoplatform.portal.mop.storage.NavigationStorage;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.portal.mop.storage.SiteStorage;
import org.exoplatform.portal.mop.storage.SiteStorageImpl$AjcClosure1;
import org.exoplatform.portal.mop.storage.utils.MOPUtils;
import org.exoplatform.portal.pom.data.ComponentData;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SiteStorageImpl
implements SiteStorage {
    private static final String DEFAULT_SHAREDLAYOUT_PATH = "war:/conf/portal/portal/sharedlayout.xml";
    private static final String IMPORTED_STATUS;
    private static final Log LOG;
    private static final String FILE_API_NAME_SPACE = "sites";
    private SettingService settingService;
    private ConfigurationManager configurationManager;
    private NavigationStorage navigationStorage;
    private PageStorage pageStorage;
    private LayoutStorage layoutStorage;
    private SiteDAO siteDAO;
    private final UploadService uploadService;
    private final FileService fileService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public SiteStorageImpl(SettingService settingService, ConfigurationManager configurationManager, NavigationStorage navigationStorage, PageStorage pageStorage, LayoutStorage layoutStorage, SiteDAO siteDAO, UploadService uploadService, FileService fileService) {
        this.navigationStorage = navigationStorage;
        this.pageStorage = pageStorage;
        this.layoutStorage = layoutStorage;
        this.settingService = settingService;
        this.configurationManager = configurationManager;
        this.siteDAO = siteDAO;
        this.uploadService = uploadService;
        this.fileService = fileService;
    }

    public void create(PortalConfig config) {
        if (StringUtils.isNotBlank((CharSequence)config.getBannerUploadId())) {
            Long bannerFileId = this.saveSiteBanner(config.getBannerUploadId(), config.getBannerFileId());
            config.setBannerFileId(bannerFileId == null ? 0L : bannerFileId);
        }
        this.create(config.build());
    }

    public void create(PortalData config) {
        SiteEntity entity = new SiteEntity();
        this.buildSiteEntity(entity, config);
        entity = (SiteEntity)this.siteDAO.create(entity);
        this.savePermissions(entity.getId(), config);
    }

    public void save(PortalConfig config) {
        if (StringUtils.isNotBlank((CharSequence)config.getBannerUploadId())) {
            Long bannerFileId = this.saveSiteBanner(config.getBannerUploadId(), config.getBannerFileId());
            config.setBannerFileId(bannerFileId == null ? 0L : bannerFileId);
        }
        this.save(config.build());
    }

    public void save(PortalData config) {
        SiteKey siteKey = new SiteKey(config.getKey().getType(), config.getKey().getId());
        SiteEntity entity = this.siteDAO.findByKey(siteKey);
        if (entity == null) {
            throw new IllegalStateException("Cannot update portal " + config.getName() + " that does not exist");
        }
        this.buildSiteEntity(entity, config);
        entity = (SiteEntity)this.siteDAO.update(entity);
        this.savePermissions(entity.getId(), config);
    }

    public void remove(PortalConfig config) {
        this.remove(config.build());
    }

    public void remove(PortalData config) {
        SiteKey siteKey = new SiteKey(config.getKey().getType(), config.getKey().getId());
        this.remove(siteKey);
    }

    @ExoTransactional
    public void remove(SiteKey siteKey) {
        SiteKey siteKey2 = siteKey;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)siteKey2);
        Object[] objectArray = new Object[]{this, siteKey2, joinPoint};
        SiteStorageImpl$AjcClosure1 siteStorageImpl$AjcClosure1 = new SiteStorageImpl$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(siteStorageImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public PortalConfig getPortalConfig(String ownerType, String portalName) {
        SiteKey siteKey = new SiteKey(ownerType, portalName);
        PortalData data = this.getPortalConfig(siteKey);
        return data != null ? new PortalConfig(data) : null;
    }

    public PortalData getPortalConfig(PortalKey key) {
        SiteKey siteKey = new SiteKey(key.getType(), key.getId());
        return this.getPortalConfig(siteKey);
    }

    public PortalData getPortalConfig(SiteKey siteKey) {
        SiteEntity entity = this.siteDAO.findByKey(siteKey);
        if (entity != null) {
            return this.buildPortalData(entity);
        }
        return null;
    }

    public PortalData getPortalConfig(long siteId) {
        SiteEntity entity = (SiteEntity)this.siteDAO.find(Long.valueOf(siteId));
        return this.buildPortalData(entity);
    }

    public List<String> getSiteNames(SiteType siteType, int offset, int limit) {
        return switch (siteType) {
            case SiteType.PORTAL -> this.siteDAO.findPortalSites(offset, limit);
            case SiteType.GROUP -> this.siteDAO.findGroupSites(offset, limit);
            case SiteType.SPACE -> this.siteDAO.findSpaceSites(offset, limit);
            case SiteType.USER -> this.siteDAO.findUserSites(offset, limit);
            default -> throw new IllegalArgumentException("Unexpected value: " + siteType);
        };
    }

    public Status getImportStatus() {
        SettingValue setting = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), IMPORTED_STATUS);
        if (setting != null) {
            String value = (String)setting.getValue();
            try {
                return Status.getStatus((int)Integer.parseInt(value));
            }
            catch (Exception ex) {
                LOG.error((Object)"Can't parse setting value of import status", (Throwable)ex);
            }
        }
        return null;
    }

    public void saveImportStatus(Status status) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(null), IMPORTED_STATUS, SettingValue.create((String)String.valueOf(status.status())));
    }

    public Container getSharedLayout(String siteName) {
        Object path = null;
        path = StringUtils.isBlank((CharSequence)siteName) ? DEFAULT_SHAREDLAYOUT_PATH : "war:/conf/portal/portal/sharedlayout-" + siteName + ".xml";
        try {
            InputStream inputStream = this.configurationManager.getInputStream((String)path);
            String out = IOUtil.getStreamContentAsString((InputStream)inputStream);
            ByteArrayInputStream is = new ByteArrayInputStream(out.getBytes(StandardCharsets.UTF_8));
            IBindingFactory bfact = BindingDirectory.getFactory(Container.class);
            UnmarshallingContext uctx = (UnmarshallingContext)bfact.createUnmarshallingContext();
            uctx.setDocument((InputStream)is, null, "UTF-8", false);
            Container container = (Container)uctx.unmarshalElement();
            MOPUtils.generateStorageName((ModelObject)container);
            return container;
        }
        catch (IOException e) {
            if (StringUtils.isNotBlank((CharSequence)siteName)) {
                return this.getSharedLayout(null);
            }
            throw new IllegalStateException("Unable to read file with path: " + (String)path, e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to parse shared layout foud in path: " + (String)path, e);
        }
    }

    public List<SiteKey> getSitesKeys(SiteFilter siteFilter) {
        return this.siteDAO.findSitesKeys(siteFilter);
    }

    private void buildSiteEntity(SiteEntity entity, PortalData config) {
        entity.setDescription(config.getDescription());
        entity.setLabel(config.getLabel());
        entity.setLocale(config.getLocale());
        entity.setName(config.getName());
        entity.setSiteType(SiteType.valueOf((String)config.getKey().getType().toUpperCase()));
        entity.setDefaultSiteBody(config.isDefaultLayout());
        entity.setSkin(config.getSkin());
        String propertiesString = "{}";
        Map properties = config.getProperties();
        if (properties != null) {
            propertiesString = new JSONObject(properties).toJSONString();
        }
        entity.setProperties(propertiesString);
        ArrayList<ComponentData> children = new ArrayList<ComponentData>();
        children.add((ComponentData)config.getPortalLayout());
        JSONArray siteBody = MOPUtils.parseJsonArray(entity.getSiteBody());
        List<ComponentEntity> newSiteBody = this.layoutStorage.saveChildren(siteBody, children);
        entity.setChildren(newSiteBody);
        entity.setSiteBody(((JSONArray)entity.toJSON().get((Object)"children")).toJSONString());
        entity.setDisplayed(config.isDisplayed());
        entity.setDisplayOrder(config.getDisplayOrder());
        entity.setBannerFileId(config.getBannerFileId());
    }

    private PortalData buildPortalData(SiteEntity entity) {
        if (entity == null) {
            return null;
        }
        JSONArray siteBody = MOPUtils.parseJsonArray(entity.getSiteBody());
        List<ComponentData> children = this.layoutStorage.buildChildren(siteBody);
        ContainerData rootContainer = null;
        if (children.isEmpty()) {
            throw new IllegalStateException("site doens't has root container layout");
        }
        rootContainer = (ContainerData)children.get(0);
        List<String> access = this.layoutStorage.getPermissions(SiteEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.ACCESS);
        List<String> editPermissionsList = this.layoutStorage.getPermissions(SiteEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.EDIT);
        String editPermission = CollectionUtils.isEmpty(editPermissionsList) ? null : editPermissionsList.get(0);
        HashMap properties = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)entity.getProperties())) {
            JSONObject jProp = MOPUtils.parseJsonObject(entity.getProperties());
            jProp.forEach((key, value) -> {
                if (key != null && value != null) {
                    properties.put(key.toString(), value.toString());
                }
            });
        }
        return new PortalData("site_" + entity.getId(), entity.getName(), entity.getSiteType().getName(), entity.getLocale(), entity.getLabel(), entity.getDescription(), access, editPermission, Collections.unmodifiableMap(properties), entity.getSkin(), rootContainer, entity.isDefaultSiteBody(), entity.isDisplayed(), entity.getDisplayOrder(), entity.getBannerFileId());
    }

    private void savePermissions(Long id, PortalData config) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.layoutStorage.savePermissions(SiteEntity.class.getName(), id, PermissionEntity.TYPE.ACCESS, config.getAccessPermissions());
        this.layoutStorage.savePermissions(SiteEntity.class.getName(), id, PermissionEntity.TYPE.EDIT, Arrays.asList(config.getEditPermission()));
    }

    private Long saveSiteBanner(String uploadId, Long oldFileId) {
        UploadResource uploadResource;
        if (uploadId == null || uploadId.isBlank()) {
            throw new IllegalArgumentException("uploadId is mandatory");
        }
        if (oldFileId != null && oldFileId != 0L) {
            this.fileService.deleteFile(oldFileId.longValue());
        }
        if ((uploadResource = this.uploadService.getUploadResource(uploadId)) == null) {
            throw new IllegalStateException("Can't find uploaded resource with id : " + uploadId);
        }
        try {
            FileInputStream inputStream = new FileInputStream(uploadResource.getStoreLocation());
            FileItem fileItem = new FileItem(null, uploadResource.getFileName(), uploadResource.getMimeType(), FILE_API_NAME_SPACE, (long)uploadResource.getUploadedSize(), new Date(), IdentityConstants.SYSTEM, false, (InputStream)inputStream);
            fileItem = this.fileService.writeFile(fileItem);
            Long l = fileItem != null && fileItem.getFileInfo() != null ? fileItem.getFileInfo().getId() : null;
            return l;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while saving site image file", e);
        }
        finally {
            this.uploadService.removeUploadResource(uploadResource.getUploadId());
        }
    }

    static {
        SiteStorageImpl.ajc$preClinit();
        IMPORTED_STATUS = Status.class.getName();
        LOG = ExoLogger.getExoLogger(SiteStorageImpl.class);
    }

    static /* synthetic */ void remove_aroundBody0(SiteStorageImpl ajc$this, SiteKey siteKey, JoinPoint joinPoint) {
        PortalData config = ajc$this.getPortalConfig(siteKey);
        if (config == null) {
            throw new NoSuchDataException("Could not remove non existing portal " + siteKey);
        }
        SiteEntity entity = ajc$this.siteDAO.findByKey(siteKey);
        String siteBody = entity.getSiteBody();
        JSONArray children = MOPUtils.parseJsonArray(siteBody);
        ajc$this.layoutStorage.deleteChildren(children);
        ajc$this.layoutStorage.deletePermissions(SiteEntity.class.getName(), entity.getId());
        ajc$this.navigationStorage.destroyNavigation(siteKey);
        ajc$this.pageStorage.destroyPages(siteKey);
        ajc$this.siteDAO.delete(entity);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SiteStorageImpl.java", SiteStorageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.exoplatform.portal.mop.storage.SiteStorageImpl", "org.exoplatform.portal.mop.SiteKey", "siteKey", "", "void"), 171);
    }
}

