/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage.utils;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.jdbc.entity.WindowEntity;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.gatein.common.io.IOTools;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class MOPUtils {
    public static void generateStorageName(ModelObject obj) {
        if (obj instanceof Container) {
            Container container = (Container)obj;
            for (ModelObject child : container.getChildren()) {
                MOPUtils.generateStorageName(child);
            }
        } else if (obj instanceof Application) {
            obj.setStorageName(UUID.randomUUID().toString());
        }
    }

    public static org.gatein.api.site.SiteType convertSiteType(SiteType siteType) {
        if (siteType == null) {
            return null;
        }
        return switch (siteType) {
            case SiteType.GROUP -> org.gatein.api.site.SiteType.SPACE;
            case SiteType.PORTAL -> org.gatein.api.site.SiteType.SITE;
            case SiteType.USER -> org.gatein.api.site.SiteType.DASHBOARD;
            default -> null;
        };
    }

    public static JSONArray parseJsonArray(String content) {
        try {
            JSONParser parser = new JSONParser();
            return (JSONArray)parser.parse(content);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Error parsing JSON content: " + content, e);
        }
    }

    public static JSONObject parseJsonObject(String content) {
        try {
            JSONParser parser = new JSONParser();
            return (JSONObject)parser.parse(content);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Error parsing JSON content: " + content, e);
        }
    }

    public static String toJSONString(Map<?, ?> properties) {
        JSONObject json = new JSONObject(properties);
        return json.toJSONString();
    }

    public static Serializable unserialize(byte[] bytes) {
        try {
            return IOTools.unserialize((byte[])bytes);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error unserializing bytes", e);
        }
    }

    public static byte[] serialize(Serializable obj) {
        try {
            return IOTools.serialize((Serializable)obj);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error serializing object: " + obj, e);
        }
    }

    public static ApplicationType<Portlet> convertAppType(WindowEntity.AppType appType) {
        if (appType == WindowEntity.AppType.PORTLET) {
            return ApplicationType.PORTLET;
        }
        return null;
    }

    private MOPUtils() {
    }
}

