/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import jakarta.servlet.ServletContext;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.cache.future.FutureMap;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.BinaryOutput;
import org.exoplatform.commons.utils.ByteArrayOutput;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.portal.resource.AbstractResourceService;
import org.exoplatform.portal.resource.CachedStylesheet;
import org.exoplatform.portal.resource.CommentBlockHandler;
import org.exoplatform.portal.resource.CompositeResourceResolver;
import org.exoplatform.portal.resource.CompositeSkin;
import org.exoplatform.portal.resource.GateInSkinConfigDeployer;
import org.exoplatform.portal.resource.RenderingException;
import org.exoplatform.portal.resource.Resource;
import org.exoplatform.portal.resource.ResourceRenderer;
import org.exoplatform.portal.resource.SimpleSkin;
import org.exoplatform.portal.resource.Skin;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinConfigPlugin;
import org.exoplatform.portal.resource.SkinKey;
import org.exoplatform.portal.resource.SkinVisitor;
import org.exoplatform.portal.resource.SkipCommentReader;
import org.exoplatform.portal.resource.compressor.ResourceCompressor;
import org.exoplatform.portal.resource.compressor.ResourceType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.URIWriter;
import org.exoplatform.web.url.MimeType;
import org.gatein.portal.controller.resource.ResourceRequestHandler;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebAppListener;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="management"), @Property(key="type", value="skin")})
@ManagedDescription(value="Skin service")
@RESTEndpoint(path="skinservice")
public class SkinService
extends AbstractResourceService
implements Startable {
    protected static Log log = ExoLogger.getLogger((String)"portal.SkinService");
    private static final String LEFT_P = "\\(";
    private static final String RIGHT_P = "\\)";
    private static final Pattern IMPORT_PATTERN = Pattern.compile("(@import\\s+url\\(['\"]?)([^'\";]+.css)(['\"]?\\)\\s*;)");
    private static final Pattern BACKGROUND_PATTERN = Pattern.compile("(background[^;])+([^;]*;)");
    private static final Pattern FONT_FACE_PATTERN = Pattern.compile("(src[^;])+([^;]*;)");
    private static final Pattern URL_PATTERN = Pattern.compile("(url\\(['\"]?)([^'\";\\)]+)(['\"]?\\))");
    private static final Pattern LT = Pattern.compile(".*/\\*.*orientation=lt.*\\*/.*");
    private static final Pattern RT = Pattern.compile(".*/\\*.*orientation=rt.*\\*/.*");
    public static final String DEFAULT_SKIN_PARAM_NAME = "skin.default";
    private static final String DEFAULT_SKIN = "Enterprise";
    public static final String CUSTOM_MODULE_ID = "customModule";
    private final WebAppListener deployer;
    private final Map<SkinKey, SkinConfig> portalSkins_;
    private final Map<SkinKey, SkinConfig> customPortalSkins_;
    private final Map<SkinKey, SkinConfig> skinConfigs_;
    private final HashSet<String> availableSkins_;
    private final FutureMap<String, CachedStylesheet, SkinContext> ltCache;
    private final FutureMap<String, CachedStylesheet, SkinContext> rtCache;
    private final Map<String, Set<String>> portletThemes_;
    private String defaultSkin;
    final String portalContainerName;
    final String id = Long.toString(System.currentTimeMillis());
    public static final long MAX_AGE;

    public SkinService(InitParams initParams, ExoContainerContext context, ResourceCompressor compressor) {
        super(compressor);
        ValueParam defaultSkinValueParam;
        Loader<String, CachedStylesheet, SkinContext> loader = new Loader<String, CachedStylesheet, SkinContext>(){

            public CachedStylesheet retrieve(SkinContext context, String key) throws Exception {
                Resource skin = SkinService.this.getCSSResource(key, key);
                if (skin == null) {
                    return null;
                }
                StringBuffer sb = new StringBuffer();
                SkinService.this.processCSSRecursively(context.controller, sb, true, skin, context.orientation);
                String css = sb.toString();
                try {
                    if (SkinService.this.compressor.isSupported(ResourceType.STYLESHEET)) {
                        css = SkinService.this.compressor.compress(css, ResourceType.STYLESHEET);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Error when compressing CSS " + key + " for orientation " + context + " will use normal CSS instead"), (Throwable)e);
                }
                return new CachedStylesheet(css);
            }
        };
        this.portalSkins_ = new LinkedHashMap<SkinKey, SkinConfig>();
        this.customPortalSkins_ = new LinkedHashMap<SkinKey, SkinConfig>();
        this.skinConfigs_ = new LinkedHashMap<SkinKey, SkinConfig>(20);
        this.availableSkins_ = new HashSet(5);
        this.ltCache = new FutureMap((Loader)loader);
        this.rtCache = new FutureMap((Loader)loader);
        this.portletThemes_ = new HashMap<String, Set<String>>();
        this.portalContainerName = context.getPortalContainerName();
        this.deployer = new GateInSkinConfigDeployer(this.portalContainerName, this);
        this.defaultSkin = DEFAULT_SKIN;
        if (initParams != null && (defaultSkinValueParam = initParams.getValueParam(DEFAULT_SKIN_PARAM_NAME)) != null && StringUtils.isNotEmpty((CharSequence)defaultSkinValueParam.getValue())) {
            this.defaultSkin = defaultSkinValueParam.getValue();
        }
        this.addResourceResolver(new CompositeResourceResolver(this.portalContainerName, this.skinConfigs_));
    }

    public void addSkinConfig(SkinConfigPlugin skinConfigPlugin) {
        if (!skinConfigPlugin.getAvailableSkins().isEmpty()) {
            for (String newSkin : skinConfigPlugin.getAvailableSkins()) {
                this.availableSkins_.add(newSkin);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)skinConfigPlugin.getDefaultSkin())) {
            this.defaultSkin = skinConfigPlugin.getDefaultSkin();
        }
    }

    public String getDefaultSkin() {
        if (!this.availableSkins_.contains(this.defaultSkin)) {
            log.warn("Skin \"{}\" does not exist, switching to skin \"Default\" as the default skin", new Object[]{this.defaultSkin});
            this.defaultSkin = DEFAULT_SKIN;
        }
        return this.defaultSkin;
    }

    public void addCategoryTheme(String categoryName) {
        if (!this.portletThemes_.containsKey(categoryName)) {
            this.portletThemes_.put(categoryName, new HashSet());
        }
    }

    @Deprecated
    public void addPortalSkin(String module, String skinName, String cssPath, ServletContext scontext) {
        this.addPortalSkin(module, skinName, cssPath);
    }

    public void addPortalSkin(String module, String skinName, String cssPath) {
        this.addPortalSkin(module, skinName, cssPath, Integer.MAX_VALUE, false);
    }

    @Deprecated
    public void addPortalSkin(String module, String skinName, String cssPath, ServletContext scontext, boolean overwrite) {
        this.addPortalSkin(module, skinName, cssPath, overwrite);
    }

    public void addPortalSkin(String module, String skinName, String cssPath, boolean overwrite) {
        this.addPortalSkin(module, skinName, cssPath, Integer.MAX_VALUE, overwrite);
    }

    public void addPortalSkin(String module, String skinName, String cssPath, int priority, boolean overwrite) {
        this.availableSkins_.add(skinName);
        SkinKey key = new SkinKey(module, skinName);
        SkinConfig skinConfig = this.portalSkins_.get(key);
        if (skinConfig == null || overwrite) {
            if (priority < 0) {
                priority = Integer.MAX_VALUE;
            }
            skinConfig = new SimpleSkin(this, module, skinName, cssPath, priority);
            if (module.startsWith(CUSTOM_MODULE_ID)) {
                skinConfig.setType("custom-skin");
                this.customPortalSkins_.put(key, skinConfig);
            } else {
                skinConfig.setType("portal-skin");
                this.portalSkins_.put(key, skinConfig);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding Portal skin : Bind " + key + " to " + skinConfig));
            }
        }
    }

    public void addPortalSkin(String module, String skinName, String cssPath, int priority, boolean overwrite, boolean filtered) {
        this.availableSkins_.add(skinName);
        SkinKey key = new SkinKey(module, skinName);
        SkinConfig skinConfig = this.portalSkins_.get(key);
        if (skinConfig == null || overwrite) {
            if (priority < 0) {
                priority = Integer.MAX_VALUE;
            }
            SimpleSkin skin = new SimpleSkin(module, skinName, cssPath, priority, filtered);
            if (module.startsWith(CUSTOM_MODULE_ID)) {
                skin.setType("custom-skin");
                this.customPortalSkins_.put(key, skin);
            } else {
                skin.setType("portal-skin");
                this.portalSkins_.put(key, skin);
            }
        }
    }

    @Deprecated
    public void addPortalSkin(String module, String skinName, String cssPath, String cssData) {
        throw new UnsupportedOperationException("This method is not supported anymore.");
    }

    @Deprecated
    public void addSkin(String module, String skinName, String cssPath, ServletContext scontext) {
        this.addSkin(module, skinName, cssPath);
    }

    public void addSkin(String module, String skinName, String cssPath) {
        this.addSkin(module, skinName, cssPath, Integer.MAX_VALUE, false);
    }

    @Deprecated
    public void addSkin(String module, String skinName, String cssPath, ServletContext scontext, boolean overwrite) {
        this.addSkin(module, skinName, cssPath, overwrite);
    }

    public void addSkin(String module, String skinName, String cssPath, boolean overwrite) {
        this.addSkin(module, skinName, cssPath, Integer.MAX_VALUE, overwrite);
    }

    public void addSkin(String module, String skinName, String cssPath, int priority, boolean overwrite) {
        this.addSkin(module, skinName, cssPath, priority, overwrite, null);
    }

    public void addSkin(String module, String skinName, String cssPath, int priority, boolean overwrite, List<String> additionalModules) {
        this.availableSkins_.add(skinName);
        SkinKey key = new SkinKey(module, skinName);
        SkinConfig skinConfig = this.skinConfigs_.get(key);
        if (skinConfig == null || overwrite) {
            if (priority < 0) {
                priority = Integer.MAX_VALUE;
            }
            skinConfig = new SimpleSkin(module, skinName, cssPath, priority, additionalModules);
            skinConfig.setType("portlet-skin");
            this.skinConfigs_.put(key, skinConfig);
        }
    }

    @Deprecated
    public void addSkin(String module, String skinName, String cssPath, String cssData) {
        this.availableSkins_.add(skinName);
        SkinKey key = new SkinKey(module, skinName);
        SkinConfig skinConfig = this.skinConfigs_.get(key);
        if (skinConfig == null) {
            skinConfig = new SimpleSkin(this, module, skinName, cssPath);
            skinConfig.setType("custom");
            this.skinConfigs_.put(key, skinConfig);
        }
        this.ltCache.remove((Serializable)((Object)cssPath));
        this.rtCache.remove((Serializable)((Object)cssPath));
    }

    public Skin merge(Collection<SkinConfig> skins) {
        return this.merge(skins, null);
    }

    public Skin merge(Collection<SkinConfig> skins, String id) {
        return new CompositeSkin(this, skins, id);
    }

    public void addTheme(String categoryName, List<String> themesName) {
        if (!this.portletThemes_.containsKey(categoryName)) {
            this.portletThemes_.put(categoryName, new HashSet());
        }
        Set<String> catThemes = this.portletThemes_.get(categoryName);
        for (String theme : themesName) {
            catThemes.add(theme);
        }
    }

    public Set<String> getAvailableSkinNames() {
        return this.availableSkins_;
    }

    public String getCSS(ControllerContext context, boolean compress) {
        try {
            final ByteArrayOutput output = new ByteArrayOutput();
            boolean success = this.renderCSS(context, new ResourceRenderer(){

                @Override
                public BinaryOutput getOutput() {
                    return output;
                }

                @Override
                public void setExpiration(long seconds) {
                }
            }, compress);
            if (success) {
                return output.getString();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (RenderingException e) {
            return null;
        }
    }

    public boolean renderCSS(ControllerContext context, ResourceRenderer renderer, boolean compress) throws RenderingException, IOException {
        String dir = context.getParameter(ResourceRequestHandler.ORIENTATION_QN);
        Orientation orientation = "rt".equals(dir) ? Orientation.RT : Orientation.LT;
        String resource = "/" + context.getParameter(ResourceRequestHandler.RESOURCE_QN) + ".css";
        if (!compress) {
            StringBuffer sb = new StringBuffer();
            Resource skin = this.getCSSResource(resource, resource);
            if (skin != null) {
                this.processCSSRecursively(context, sb, false, skin, orientation);
                byte[] bytes = sb.toString().getBytes("UTF-8");
                renderer.setExpiration(MAX_AGE);
                if (context.getResponse() != null) {
                    context.getResponse().setContentLength(bytes.length);
                }
                renderer.getOutput().write(bytes);
                return true;
            }
        } else {
            FutureMap<String, CachedStylesheet, SkinContext> cache = orientation == Orientation.LT ? this.ltCache : this.rtCache;
            CachedStylesheet cachedCss = (CachedStylesheet)cache.get((Object)new SkinContext(context, orientation), (Object)resource);
            if (cachedCss != null) {
                renderer.setExpiration(MAX_AGE);
                if (context.getResponse() != null) {
                    context.getResponse().setContentLength(cachedCss.getLength());
                }
                cachedCss.writeTo(renderer.getOutput());
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public String getMergedCSS(ControllerContext context, String path) {
        return this.getCSS(context, true);
    }

    public Collection<SkinConfig> getPortalSkins(String skinName) {
        if (StringUtils.isEmpty((CharSequence)skinName)) {
            skinName = this.getDefaultSkin();
        }
        Set<SkinKey> keys = this.portalSkins_.keySet();
        ArrayList<SkinConfig> portalSkins = new ArrayList<SkinConfig>();
        for (SkinKey key : keys) {
            SkinConfig skinConfig;
            if (!key.getName().equals(skinName) || (skinConfig = this.portalSkins_.get(key)).isFiltered()) continue;
            portalSkins.add(skinConfig);
        }
        Collections.sort(portalSkins, new Comparator<SkinConfig>(){

            @Override
            public int compare(SkinConfig o1, SkinConfig o2) {
                return o1.getCSSPriority() - o2.getCSSPriority();
            }
        });
        return portalSkins;
    }

    public Collection<SkinConfig> findSkins(SkinVisitor visitor) {
        return visitor.getSkins(this.portalSkins_.entrySet(), this.skinConfigs_.entrySet());
    }

    public Collection<SkinConfig> getCustomPortalSkins(String skinName) {
        if (StringUtils.isEmpty((CharSequence)skinName)) {
            skinName = this.getDefaultSkin();
        }
        Set<SkinKey> keys = this.customPortalSkins_.keySet();
        ArrayList<SkinConfig> customPortalSkins = new ArrayList<SkinConfig>();
        for (SkinKey key : keys) {
            SkinConfig skinConfig;
            if (!key.getName().equals(skinName) || (skinConfig = this.customPortalSkins_.get(key)).isFiltered()) continue;
            customPortalSkins.add(skinConfig);
        }
        Collections.sort(customPortalSkins, new Comparator<SkinConfig>(){

            @Override
            public int compare(SkinConfig o1, SkinConfig o2) {
                return o1.getCSSPriority() - o2.getCSSPriority();
            }
        });
        return customPortalSkins;
    }

    public Map<String, Set<String>> getPortletThemes() {
        return this.portletThemes_;
    }

    public SkinConfig getSkin(String module, String skinName) {
        SkinConfig config;
        if (StringUtils.isBlank((CharSequence)skinName)) {
            skinName = this.getDefaultSkin();
        }
        if ((config = this.skinConfigs_.get(new SkinKey(module, skinName))) == null) {
            config = this.skinConfigs_.get(new SkinKey(module, this.getDefaultSkin()));
        }
        return config;
    }

    public SkinConfig getPortalSkin(String module, String skinName) {
        SkinConfig portalSkin = this.getPortalSkin(module, skinName, this.portalSkins_);
        if (portalSkin == null) {
            portalSkin = this.getPortalSkin(module, skinName, this.customPortalSkins_);
        }
        return portalSkin;
    }

    @Deprecated
    public void invalidatePortalSkinCache(String portalName, String skinName) {
        SkinKey key = new SkinKey(portalName, skinName);
        this.skinConfigs_.remove(key);
    }

    public void invalidateCachedSkin(String path) {
        this.ltCache.remove((Serializable)((Object)path));
        this.rtCache.remove((Serializable)((Object)path));
    }

    public long getLastModified(ControllerContext context) {
        CachedStylesheet cachedCSS;
        String resource = "/" + context.getParameter(ResourceRequestHandler.RESOURCE_QN) + ".css";
        FutureMap<String, CachedStylesheet, SkinContext> cache = this.ltCache;
        Orientation orientation = Orientation.LT;
        String dir = context.getParameter(ResourceRequestHandler.ORIENTATION_QN);
        if ("rt".equals(dir)) {
            orientation = Orientation.RT;
            cache = this.rtCache;
        }
        if ((cachedCSS = (CachedStylesheet)cache.get((Object)new SkinContext(context, orientation), (Object)resource)) == null) {
            return System.currentTimeMillis();
        }
        return cachedCSS.getLastModified();
    }

    @Deprecated
    public void remove(String module, String skinName) {
        this.removeSkin(module, skinName);
    }

    public void removeSkin(String module, String skinName) {
        SkinKey key = skinName == null || skinName.length() == 0 ? new SkinKey(module, this.getDefaultSkin()) : new SkinKey(module, skinName);
        this.removeSkin(key);
    }

    public void removeSkin(SkinKey key) {
        if (key == null) {
            return;
        }
        SkinConfig remove = this.skinConfigs_.remove(key);
        if (remove != null && StringUtils.isNotBlank((CharSequence)remove.getCSSPath())) {
            this.invalidateCachedSkin(remove.getCSSPath());
        }
    }

    public void removePortalSkin(String module, String skinName) {
        SkinKey key = StringUtils.isBlank((CharSequence)skinName) ? new SkinKey(module, this.getDefaultSkin()) : new SkinKey(module, skinName);
        this.removePortalSkin(key);
    }

    public void removePortalSkin(SkinKey key) {
        if (key == null) {
            return;
        }
        SkinConfig remove = null;
        remove = key.getModule().startsWith(CUSTOM_MODULE_ID) ? this.customPortalSkins_.remove(key) : this.portalSkins_.remove(key);
        if (remove != null && StringUtils.isNotBlank((CharSequence)remove.getCSSPath())) {
            this.invalidateCachedSkin(remove.getCSSPath());
        }
    }

    @Deprecated
    public void remove(List<SkinKey> keys) throws Exception {
        this.removeSkins(keys);
    }

    public void removeSkins(List<SkinKey> keys) {
        if (keys == null) {
            return;
        }
        for (SkinKey key : keys) {
            this.removeSkin(key);
        }
    }

    public void removeSupportedSkin(String skinName) {
        this.availableSkins_.remove(skinName);
    }

    public int size() {
        return this.skinConfigs_.size();
    }

    private Resource getCSSResource(String cssPath, String outerCssFile) {
        Resource resource = this.mainResolver.resolve(cssPath);
        if (resource == null && log.isErrorEnabled()) {
            String logMessage;
            if (!cssPath.equals(outerCssFile)) {
                int lastIndexOfSlash = cssPath.lastIndexOf(47);
                String loadedCssFile = lastIndexOfSlash >= 0 ? cssPath.substring(lastIndexOfSlash + 1) : cssPath;
                logMessage = "Invalid <CSS FILE> configuration, please check the @import url(" + loadedCssFile + ") in " + outerCssFile + " , SkinService could not load the skin " + cssPath;
            } else {
                logMessage = "Not found <CSS FILE>, the path " + cssPath + " is invalid, SkinService could not load the skin " + cssPath;
            }
            log.error((Object)logMessage);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCSSRecursively(ControllerContext context, Appendable appendable, boolean merge, Resource skin, Orientation orientation) throws RenderingException, IOException {
        if (skin == null) {
            return;
        }
        String basePath = skin.getContextPath() + skin.getParentPath();
        Reader tmp = skin.read();
        if (tmp == null) {
            throw new RenderingException("No skin resolved for path " + skin.getResourcePath());
        }
        SkipCommentReader reader = new SkipCommentReader(tmp, new CommentBlockHandler.OrientationCommentBlockHandler());
        try {
            String line = ((BufferedReader)reader).readLine();
            while (line != null) {
                line = this.proccessOrientation(line, orientation);
                line = this.processURL(BACKGROUND_PATTERN, line, basePath);
                line = this.processURL(FONT_FACE_PATTERN, line, basePath);
                Matcher matcher = IMPORT_PATTERN.matcher(line);
                while (matcher.find()) {
                    Object includedPath = matcher.group(2);
                    if (!((String)includedPath).startsWith("/")) {
                        includedPath = basePath + (String)includedPath;
                    }
                    StringBuffer strReplace = new StringBuffer();
                    if (merge) {
                        Resource ssskin = this.getCSSResource((String)includedPath, basePath + skin.getFileName());
                        this.processCSSRecursively(context, strReplace, merge, ssskin, orientation);
                    } else {
                        String resource = ((String)includedPath).substring(1, ((String)includedPath).length() - ".css".length());
                        HashMap<QualifiedName, String> params = new HashMap<QualifiedName, String>();
                        params.put(ResourceRequestHandler.VERSION_QN, ResourceRequestHandler.VERSION);
                        params.put(ResourceRequestHandler.ORIENTATION_QN, orientation == Orientation.RT ? "rt" : "lt");
                        params.put(ResourceRequestHandler.COMPRESS_QN, merge ? "min" : "");
                        params.put(WebAppController.HANDLER_PARAM, "skin");
                        params.put(ResourceRequestHandler.RESOURCE_QN, resource);
                        StringBuilder embeddedPath = new StringBuilder();
                        context.renderURL(params, new URIWriter((Appendable)embeddedPath, MimeType.PLAIN));
                        strReplace.append(matcher.group(1));
                        strReplace.append((CharSequence)embeddedPath);
                        strReplace.append(matcher.group(3));
                    }
                    String str = strReplace.toString().replaceAll("\\$", "\\\\\\$");
                    str = str.replaceAll("(\\\\[0-9a-fA-F]{4})", "\\\\$1");
                    matcher.appendReplacement((StringBuffer)appendable, str);
                }
                matcher.appendTail((StringBuffer)appendable);
                line = ((BufferedReader)reader).readLine();
                if (line == null) continue;
                appendable.append("\n");
            }
        }
        finally {
            Safe.close((Closeable)reader);
        }
    }

    private String processURL(Pattern pattern, String line, String basePath) {
        Matcher patternMatcher = pattern.matcher(line);
        StringBuffer tmpBuilder = new StringBuffer();
        while (patternMatcher.find()) {
            StringBuilder fontFaceReplace = new StringBuilder();
            Matcher urlMatcher = URL_PATTERN.matcher(patternMatcher.group());
            StringBuffer tmpURL = new StringBuffer();
            while (urlMatcher.find()) {
                if (urlMatcher.group(2).startsWith("\"/") || urlMatcher.group(2).startsWith("'/") || urlMatcher.group(2).startsWith("/")) continue;
                StringBuilder urlBuilder = new StringBuilder();
                urlBuilder.append(urlMatcher.group(1));
                urlBuilder.append(basePath);
                urlBuilder.append(urlMatcher.group(2));
                urlBuilder.append(urlMatcher.group(3));
                urlMatcher.appendReplacement(tmpURL, urlBuilder.toString());
            }
            urlMatcher.appendTail(tmpURL);
            patternMatcher.appendReplacement(tmpBuilder, tmpURL.toString());
        }
        patternMatcher.appendTail(tmpBuilder);
        return tmpBuilder.toString();
    }

    private String proccessOrientation(String line, Orientation orientation) {
        Pattern orientationPattern = orientation == Orientation.LT ? RT : LT;
        Matcher matcher = orientationPattern.matcher(line);
        StringBuffer tmpBuilder = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(tmpBuilder, "");
        }
        matcher.appendTail(tmpBuilder);
        return tmpBuilder.toString();
    }

    private SkinConfig getPortalSkin(String module, String skinName, Map<SkinKey, SkinConfig> portalSkins) {
        SkinConfig config;
        if (StringUtils.isEmpty((CharSequence)skinName)) {
            skinName = this.getDefaultSkin();
        }
        if ((config = portalSkins.get(new SkinKey(module, skinName))) == null) {
            config = portalSkins.get(new SkinKey(module, this.getDefaultSkin()));
        }
        return config;
    }

    @Managed
    @ManagedDescription(value="The list of registered skins identifiers")
    public String[] getSkinList() {
        ArrayList<String> availableSkin = new ArrayList<String>();
        for (String skin : this.availableSkins_) {
            availableSkin.add(skin);
        }
        Collections.sort(availableSkin);
        return availableSkin.toArray(new String[availableSkin.size()]);
    }

    @Managed
    @ManagedDescription(value="Reload all skins")
    @Impact(value=ImpactType.WRITE)
    public void reloadSkins() {
        this.ltCache.clear();
        this.rtCache.clear();
    }

    @Managed
    @ManagedDescription(value="Reload a specified skin")
    public void reloadSkin(@ManagedDescription(value="The skin id") @ManagedName(value="skinId") String skinId) {
        this.ltCache.remove((Serializable)((Object)skinId));
        this.rtCache.remove((Serializable)((Object)skinId));
    }

    public void start() {
        ServletContainerFactory.getServletContainer().addWebAppListener(this.deployer);
    }

    public void stop() {
        ServletContainerFactory.getServletContainer().removeWebAppListener(this.deployer);
    }

    static {
        long seconds = 31536000L;
        String propValue = PropertyManager.getProperty((String)"gatein.assets.css.max-age");
        if (propValue != null) {
            try {
                seconds = Long.valueOf(propValue);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"The gatein.assets.css.max-age property is not set properly.");
            }
        }
        MAX_AGE = seconds;
    }

    static class SkinContext {
        final ControllerContext controller;
        final Orientation orientation;

        SkinContext(ControllerContext controller, Orientation orientation) {
            this.controller = controller;
            this.orientation = orientation;
        }
    }
}

