/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.layout.model.PageTemplate;
import io.meeds.layout.model.PageTemplateDescriptor;
import io.meeds.layout.model.PageTemplateDescriptorList;
import io.meeds.layout.plugin.PageTemplateAttachmentPlugin;
import io.meeds.layout.plugin.PageTemplateTranslationPlugin;
import io.meeds.layout.rest.model.LayoutModel;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PageTemplateImportService$AjcClosure1;
import io.meeds.layout.service.PageTemplateImportService$AjcClosure3;
import io.meeds.layout.service.PageTemplateService;
import io.meeds.layout.util.JsonUtils;
import io.meeds.social.translation.plugin.TranslationPlugin;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.ModelUnmarshaller;
import org.exoplatform.portal.config.model.UnmarshalledObject;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.upload.UploadResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PageTemplateImportService {
    private static final Scope PAGE_TEMPLATE_IMPORT_SCOPE;
    private static final Context PAGE_TEMPLATE_CONTEXT;
    private static final Log LOG;
    private static final Random RANDOM;
    @Autowired
    private LayoutAclService layoutAclService;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private LocaleConfigService localeConfigService;
    @Autowired
    private PageTemplateService pageTemplateService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private ConfigurationManager configurationManager;
    @Autowired
    private PageTemplateAttachmentPlugin pageTemplateAttachmentPlugin;
    @Autowired
    private PageTemplateTranslationPlugin pageTemplateTranslationPlugin;
    @Value(value="${meeds.pages.import.override:false}")
    private boolean forceReimportTemplates;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @PostConstruct
    @ContainerTransactional
    public void init() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        PageTemplateImportService$AjcClosure1 pageTemplateImportService$AjcClosure1 = new PageTemplateImportService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(pageTemplateImportService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ContainerTransactional
    public void importPageTemplates() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        PageTemplateImportService$AjcClosure3 pageTemplateImportService$AjcClosure3 = new PageTemplateImportService$AjcClosure3(objectArray);
        ContainerTransactionalAspect.aspectOf().around(pageTemplateImportService$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    protected List<PageTemplateDescriptor> parseDescriptors(URL url) {
        List<PageTemplateDescriptor> list;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                PageTemplateDescriptorList list2 = JsonUtils.fromJsonString(content, PageTemplateDescriptorList.class);
                list = list2.getDescriptors();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("An unkown error happened while parsing page templates from url {}", new Object[]{url, e});
                    return Collections.emptyList();
                }
            }
            inputStream.close();
        }
        return list;
    }

    protected void importDescriptor(PageTemplateDescriptor descriptor) {
        String descriptorId = descriptor.getId();
        long oldTemplateId = this.getAlreadyImportedTemplateId(descriptorId);
        if (this.forceReimportTemplates || oldTemplateId == 0L) {
            this.importPageTemplate(descriptor, oldTemplateId);
        } else {
            LOG.info("Ignore re-importing Page Template {}", new Object[]{descriptorId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importPageTemplate(PageTemplateDescriptor d, long oldTemplateId) {
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.layoutAclService.getSuperUserConversationState());
        try {
            LOG.info("Importing Page Template {}", new Object[]{d.getId()});
            PageTemplate pageTemplate = this.createPageTemplate(d, oldTemplateId);
            if (oldTemplateId == 0L || pageTemplate.getId() != oldTemplateId) {
                LOG.info("Importing Page Template {} title translations", new Object[]{d.getId()});
                this.saveTemplateNames(d, pageTemplate);
                LOG.info("Importing Page Template {} description translations", new Object[]{d.getId()});
                this.saveTemplateDescriptions(d, pageTemplate);
                LOG.info("Importing Page Template {} illustration", new Object[]{d.getId()});
                this.saveTemplateIllustration(pageTemplate.getId(), d.getIllustrationPath());
                this.settingService.set(PAGE_TEMPLATE_CONTEXT, PAGE_TEMPLATE_IMPORT_SCOPE, d.getId(), SettingValue.create((String)String.valueOf(pageTemplate.getId())));
            }
            LOG.info("Importing Page Template {} finished successfully", new Object[]{d.getId()});
        }
        catch (Exception e) {
            LOG.warn("An error occurred while importing page template {}", new Object[]{d.getId(), e});
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    protected void saveTemplateNames(PageTemplateDescriptor d, PageTemplate pageTemplate) {
        d.getNames().forEach((k, v) -> this.saveTranslationLabel("pageTemplate", pageTemplate.getId(), "title", Locale.forLanguageTag(k), (String)v));
        String defaultName = d.getNames().get("en");
        this.localeConfigService.getLocalConfigs().stream().filter(config -> !StringUtils.equals((CharSequence)config.getLocale().toLanguageTag(), (CharSequence)"en")).forEach(config -> this.saveTranslationLabel("pageTemplate", pageTemplate.getId(), "title", config.getLocale(), defaultName));
    }

    protected void saveTemplateDescriptions(PageTemplateDescriptor d, PageTemplate pageTemplate) {
        d.getDescriptions().forEach((k, v) -> this.saveTranslationLabel("pageTemplate", pageTemplate.getId(), "description", Locale.forLanguageTag(k), (String)v));
        String defaultDescription = d.getDescriptions().get("en");
        this.localeConfigService.getLocalConfigs().stream().filter(config -> !StringUtils.equals((CharSequence)config.getLocale().toLanguageTag(), (CharSequence)"en")).forEach(config -> this.saveTranslationLabel("pageTemplate", pageTemplate.getId(), "description", config.getLocale(), defaultDescription));
    }

    protected PageTemplate createPageTemplate(PageTemplateDescriptor d, long oldTemplateId) {
        PageTemplate pageTemplate = null;
        if (oldTemplateId > 0L) {
            pageTemplate = this.pageTemplateService.getPageTemplate(oldTemplateId);
        }
        boolean isNew = false;
        if (pageTemplate == null) {
            pageTemplate = new PageTemplate();
            isNew = true;
        }
        try (InputStream is = this.configurationManager.getInputStream(d.getLayoutPath());){
            String xml = IOUtil.getStreamContentAsString((InputStream)is);
            Container layout = this.fromXML(xml);
            pageTemplate.setContent(JsonUtils.toJsonString(new LayoutModel((ModelObject)layout)));
        }
        if (isNew) {
            return this.pageTemplateService.createPageTemplate(pageTemplate);
        }
        return this.pageTemplateService.updatePageTemplate(pageTemplate);
    }

    protected void saveTranslationLabel(String objectType, long id, String fieldName, Locale locale, String label) {
        this.translationService.saveTranslationLabel(objectType, id, fieldName, locale, label);
    }

    protected void saveTemplateIllustration(long pageTemplateId, String imagePath) {
        try {
            URL resource = this.configurationManager.getResource(imagePath);
            String uploadId = "PageTemplateIllustration" + RANDOM.nextLong();
            UploadResource uploadResource = new UploadResource(uploadId);
            uploadResource.setFileName(new File(resource.getPath()).getName());
            uploadResource.setMimeType("image/png");
            uploadResource.setStatus(1);
            uploadResource.setStoreLocation(resource.getPath());
            UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
            this.attachmentService.saveAttachment(uploadedAttachmentDetail, "pageTemplate", String.valueOf(pageTemplateId), null, RestUtils.getCurrentUserIdentityId());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while saving Image '%s' as attachment for template '%s'", imagePath, pageTemplateId), e);
        }
    }

    protected Container fromXML(String xml) {
        UnmarshalledObject obj = ModelUnmarshaller.unmarshall(Container.class, (byte[])xml.getBytes(StandardCharsets.UTF_8));
        return (Container)obj.getObject();
    }

    protected long getAlreadyImportedTemplateId(String descriptorId) {
        try {
            SettingValue settingValue = this.settingService.get(PAGE_TEMPLATE_CONTEXT, PAGE_TEMPLATE_IMPORT_SCOPE, descriptorId);
            return settingValue == null || settingValue.getValue() == null ? 0L : Long.parseLong(settingValue.getValue().toString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    static {
        PageTemplateImportService.ajc$preClinit();
        PAGE_TEMPLATE_IMPORT_SCOPE = Scope.APPLICATION.id("PAGE_TEMPLATE_IMPORT");
        PAGE_TEMPLATE_CONTEXT = Context.GLOBAL.id("PAGE_TEMPLATE");
        LOG = ExoLogger.getLogger(PageTemplateImportService.class);
        RANDOM = new Random();
    }

    static /* synthetic */ void init_aroundBody0(PageTemplateImportService ajc$this, JoinPoint joinPoint) {
        ajc$this.translationService.addPlugin((TranslationPlugin)ajc$this.pageTemplateTranslationPlugin);
        ajc$this.attachmentService.addPlugin((AttachmentPlugin)ajc$this.pageTemplateAttachmentPlugin);
        CompletableFuture.runAsync(ajc$this::importPageTemplates);
    }

    static /* synthetic */ void importPageTemplates_aroundBody2(PageTemplateImportService ajc$this, JoinPoint joinPoint) {
        LOG.info((Object)"Importing Page Templates");
        try {
            Enumeration<URL> templateFiles = PortalContainer.getInstance().getPortalClassLoader().getResources("page-templates.json");
            Collections.list(templateFiles).stream().map(ajc$this::parseDescriptors).flatMap(Collection::stream).sorted((d1, d2) -> {
                if (d1.getOrder() == d2.getOrder()) {
                    return d1.getId().compareTo(d2.getId());
                }
                return d1.getOrder() - d2.getOrder();
            }).forEach(ajc$this::importDescriptor);
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occurred while importing page templates", (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PageTemplateImportService.java", PageTemplateImportService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "io.meeds.layout.service.PageTemplateImportService", "", "", "", "void"), 115);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importPageTemplates", "io.meeds.layout.service.PageTemplateImportService", "", "", "", "void"), 123);
    }
}

