/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.data.redis.RedisConnectionDetails;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.autoconfigure.data.redis.RedisUrlSyntaxException;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.util.ClassUtils;

abstract class RedisConnectionConfiguration {
    private static final boolean COMMONS_POOL2_AVAILABLE = ClassUtils.isPresent((String)"org.apache.commons.pool2.ObjectPool", (ClassLoader)RedisConnectionConfiguration.class.getClassLoader());
    private final RedisProperties properties;
    private final RedisStandaloneConfiguration standaloneConfiguration;
    private final RedisSentinelConfiguration sentinelConfiguration;
    private final RedisClusterConfiguration clusterConfiguration;
    private final RedisConnectionDetails connectionDetails;
    private final SslBundles sslBundles;

    protected RedisConnectionConfiguration(RedisProperties properties, RedisConnectionDetails connectionDetails, ObjectProvider<RedisStandaloneConfiguration> standaloneConfigurationProvider, ObjectProvider<RedisSentinelConfiguration> sentinelConfigurationProvider, ObjectProvider<RedisClusterConfiguration> clusterConfigurationProvider, ObjectProvider<SslBundles> sslBundles) {
        this.properties = properties;
        this.standaloneConfiguration = (RedisStandaloneConfiguration)standaloneConfigurationProvider.getIfAvailable();
        this.sentinelConfiguration = (RedisSentinelConfiguration)sentinelConfigurationProvider.getIfAvailable();
        this.clusterConfiguration = (RedisClusterConfiguration)clusterConfigurationProvider.getIfAvailable();
        this.connectionDetails = connectionDetails;
        this.sslBundles = (SslBundles)sslBundles.getIfAvailable();
    }

    protected final RedisStandaloneConfiguration getStandaloneConfig() {
        if (this.standaloneConfiguration != null) {
            return this.standaloneConfiguration;
        }
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName(this.connectionDetails.getStandalone().getHost());
        config.setPort(this.connectionDetails.getStandalone().getPort());
        config.setUsername(this.connectionDetails.getUsername());
        config.setPassword(RedisPassword.of((String)this.connectionDetails.getPassword()));
        config.setDatabase(this.connectionDetails.getStandalone().getDatabase());
        return config;
    }

    protected final RedisSentinelConfiguration getSentinelConfig() {
        if (this.sentinelConfiguration != null) {
            return this.sentinelConfiguration;
        }
        if (this.connectionDetails.getSentinel() != null) {
            RedisSentinelConfiguration config = new RedisSentinelConfiguration();
            config.master(this.connectionDetails.getSentinel().getMaster());
            config.setSentinels(this.createSentinels(this.connectionDetails.getSentinel()));
            config.setUsername(this.connectionDetails.getUsername());
            String password = this.connectionDetails.getPassword();
            if (password != null) {
                config.setPassword(RedisPassword.of((String)password));
            }
            config.setSentinelUsername(this.connectionDetails.getSentinel().getUsername());
            String sentinelPassword = this.connectionDetails.getSentinel().getPassword();
            if (sentinelPassword != null) {
                config.setSentinelPassword(RedisPassword.of((String)sentinelPassword));
            }
            config.setDatabase(this.connectionDetails.getSentinel().getDatabase());
            return config;
        }
        return null;
    }

    protected final RedisClusterConfiguration getClusterConfiguration() {
        if (this.clusterConfiguration != null) {
            return this.clusterConfiguration;
        }
        RedisProperties.Cluster clusterProperties = this.properties.getCluster();
        if (this.connectionDetails.getCluster() != null) {
            RedisClusterConfiguration config = new RedisClusterConfiguration(this.getNodes(this.connectionDetails.getCluster()));
            if (clusterProperties != null && clusterProperties.getMaxRedirects() != null) {
                config.setMaxRedirects(clusterProperties.getMaxRedirects().intValue());
            }
            config.setUsername(this.connectionDetails.getUsername());
            String password = this.connectionDetails.getPassword();
            if (password != null) {
                config.setPassword(RedisPassword.of((String)password));
            }
            return config;
        }
        return null;
    }

    private List<String> getNodes(RedisConnectionDetails.Cluster cluster) {
        return cluster.getNodes().stream().map(node -> "%s:%d".formatted(node.host(), node.port())).toList();
    }

    protected final RedisProperties getProperties() {
        return this.properties;
    }

    protected SslBundles getSslBundles() {
        return this.sslBundles;
    }

    protected boolean isSslEnabled() {
        return this.getProperties().getSsl().isEnabled();
    }

    protected boolean isPoolEnabled(RedisProperties.Pool pool) {
        Boolean enabled = pool.getEnabled();
        return enabled != null ? enabled : COMMONS_POOL2_AVAILABLE;
    }

    private List<RedisNode> createSentinels(RedisConnectionDetails.Sentinel sentinel) {
        ArrayList<RedisNode> nodes = new ArrayList<RedisNode>();
        for (RedisConnectionDetails.Node node : sentinel.getNodes()) {
            nodes.add(new RedisNode(node.host(), node.port()));
        }
        return nodes;
    }

    protected final boolean urlUsesSsl() {
        return RedisConnectionConfiguration.parseUrl(this.properties.getUrl()).isUseSsl();
    }

    protected final RedisConnectionDetails getConnectionDetails() {
        return this.connectionDetails;
    }

    static ConnectionInfo parseUrl(String url) {
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            if (!"redis".equals(scheme) && !"rediss".equals(scheme)) {
                throw new RedisUrlSyntaxException(url);
            }
            boolean useSsl = "rediss".equals(scheme);
            String username = null;
            String password = null;
            if (uri.getUserInfo() != null) {
                String candidate = uri.getUserInfo();
                int index = candidate.indexOf(58);
                if (index >= 0) {
                    username = candidate.substring(0, index);
                    password = candidate.substring(index + 1);
                } else {
                    password = candidate;
                }
            }
            return new ConnectionInfo(uri, useSsl, username, password);
        }
        catch (URISyntaxException ex) {
            throw new RedisUrlSyntaxException(url, ex);
        }
    }

    static class ConnectionInfo {
        private final URI uri;
        private final boolean useSsl;
        private final String username;
        private final String password;

        ConnectionInfo(URI uri, boolean useSsl, String username, String password) {
            this.uri = uri;
            this.useSsl = useSsl;
            this.username = username;
            this.password = password;
        }

        URI getUri() {
            return this.uri;
        }

        boolean isUseSsl() {
            return this.useSsl;
        }

        String getUsername() {
            return this.username;
        }

        String getPassword() {
            return this.password;
        }
    }
}

