/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleArrayJdbcType;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleArrayJdbcTypeConstructor
implements JdbcTypeConstructor {
    @Override
    public JdbcType resolveType(TypeConfiguration typeConfiguration, Dialect dialect, BasicType<?> elementType, ColumnTypeInformation columnTypeInformation) {
        String typeName;
        String string = typeName = columnTypeInformation == null ? null : columnTypeInformation.getTypeName();
        if (typeName == null || typeName.isBlank()) {
            typeName = OracleArrayJdbcType.getTypeName(elementType.getJavaTypeDescriptor(), dialect);
        }
        return new OracleArrayJdbcType(elementType.getJdbcType(), typeName);
    }

    @Override
    public JdbcType resolveType(TypeConfiguration typeConfiguration, Dialect dialect, JdbcType elementType, ColumnTypeInformation columnTypeInformation) {
        return new OracleArrayJdbcType(elementType, columnTypeInformation == null ? null : columnTypeInformation.getTypeName());
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 2003;
    }
}

