/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.concurrent;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gatein.common.concurrent.ObjectRef;

public class BoundedBuffer<T>
implements Iterable<T> {
    private final int maxSize;
    private ObjectRef<T> last;
    private ObjectRef<T> first;
    private int size;

    public BoundedBuffer(int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("Buffer size needs to be greater than zero");
        }
        this.maxSize = maxSize;
        this.size = 0;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T t) {
        ObjectRef<T> added = new ObjectRef<T>(t);
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            if (this.first == null) {
                this.first = added;
                this.last = this.first;
                this.size = 1;
            } else {
                ObjectRef<T> tmp = this.first;
                this.first = added;
                tmp.next = this.first;
                if (this.size < this.maxSize) {
                    ++this.size;
                } else {
                    this.last = this.last.next;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        int size;
        ObjectRef<T> last;
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            last = this.last;
            size = this.size;
        }
        if (size == 0) {
            return Collections.emptyList().iterator();
        }
        return new BoundedIterator(last, size);
    }

    private static final class BoundedIterator<T>
    implements Iterator<T> {
        final int size;
        ObjectRef<T> current;
        int count = 0;

        private BoundedIterator(ObjectRef<T> current, int size) {
            this.current = current;
            this.size = size;
            this.count = 0;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.size && this.current != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object next = this.current.object;
            this.current = this.current.next;
            ++this.count;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

