/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.List;

public class HsqlDeque<E>
extends BaseList<E>
implements List<E> {
    private E[] list = new Object[16];
    private int firstindex = 0;
    private int endindex = 0;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public boolean offer(E e) {
        return this.add(e);
    }

    public E remove() {
        return this.removeFirst();
    }

    public E poll() {
        if (this.elementCount == 0) {
            return null;
        }
        return this.removeFirst();
    }

    public E element() {
        return this.getFirst();
    }

    public E peek() {
        if (this.elementCount == 0) {
            return null;
        }
        return this.getFirst();
    }

    public void push(E e) {
        this.addFirst(e);
    }

    public E pop() {
        return this.removeFirst();
    }

    public E getFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.firstindex];
    }

    public E getLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.endindex - 1];
    }

    @Override
    public E get(int n) throws IndexOutOfBoundsException {
        int n2 = this.getInternalIndex(n);
        return this.list[n2];
    }

    @Override
    public void add(int n, E e) throws IndexOutOfBoundsException {
        if (n == this.elementCount) {
            this.add(e);
            return;
        }
        this.resetCapacity();
        int n2 = this.getInternalIndex(n);
        if (n2 < this.endindex && this.endindex < this.list.length) {
            System.arraycopy(this.list, n2, this.list, n2 + 1, this.endindex - n2);
            ++this.endindex;
        } else {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex - 1, n2 - this.firstindex);
            --this.firstindex;
            --n2;
        }
        this.list[n2] = e;
        ++this.elementCount;
    }

    @Override
    public E set(int n, E e) throws IndexOutOfBoundsException {
        int n2 = this.getInternalIndex(n);
        E e2 = this.list[n2];
        this.list[n2] = e;
        return e2;
    }

    public E removeFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        E e = this.list[this.firstindex];
        this.list[this.firstindex] = null;
        ++this.firstindex;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.firstindex == this.list.length) {
            this.firstindex = 0;
        }
        return e;
    }

    public E removeLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        --this.endindex;
        E e = this.list[this.endindex];
        this.list[this.endindex] = null;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.endindex == 0) {
            this.endindex = this.list.length;
        }
        return e;
    }

    public E peekFirst() {
        return this.getFirst();
    }

    public E peekLast() {
        return this.getLast();
    }

    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    public E pollFirst() {
        if (this.elementCount == 0) {
            return null;
        }
        return this.removeFirst();
    }

    public E pollLast() {
        if (this.elementCount == 0) {
            return null;
        }
        return this.removeLast();
    }

    public boolean removeFirstOccurrence(Object object) {
        int n = this.indexOf(object);
        if (n < 1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public boolean removeLastOccurrence(Object object) {
        int n = this.lastIndexOf(object);
        if (n < 1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public Iterator<E> descendingIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e) {
        this.resetCapacity();
        if (this.endindex == this.list.length) {
            this.endindex = 0;
        }
        this.list[this.endindex] = e;
        ++this.elementCount;
        ++this.endindex;
        return true;
    }

    public void addLast(E e) {
        this.add(e);
    }

    public void addFirst(E e) {
        this.resetCapacity();
        --this.firstindex;
        if (this.firstindex < 0) {
            this.firstindex = this.list.length - 1;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        this.list[this.firstindex] = e;
        ++this.elementCount;
    }

    @Override
    public void clear() {
        if (this.elementCount == 0) {
            return;
        }
        this.elementCount = 0;
        this.endindex = 0;
        this.firstindex = 0;
        Arrays.fill(this.list, null);
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.elementCount; ++i) {
            int n = this.firstindex + i;
            if (n >= this.list.length) {
                n -= this.list.length;
            }
            if (this.list[n] == object) {
                return i;
            }
            if (object == null || !this.comparator.equals(object, this.list[n])) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        for (int i = this.elementCount - 1; i >= 0; --i) {
            int n = this.firstindex + i;
            if (n < 0) {
                n += this.list.length;
            }
            if (this.list[n] == object) {
                return i;
            }
            if (object == null || !this.comparator.equals(object, this.list[n])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public E remove(int n) {
        int n2 = this.getInternalIndex(n);
        E e = this.list[n2];
        if (n2 == this.firstindex) {
            this.list[this.firstindex] = null;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else if (n2 > this.firstindex) {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex + 1, n2 - this.firstindex);
            this.list[this.firstindex] = null;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else {
            System.arraycopy(this.list, n2 + 1, this.list, n2, this.endindex - n2 - 1);
            --this.endindex;
            this.list[this.endindex] = null;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        }
        return e;
    }

    private int getInternalIndex(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.firstindex + n;
        if (n2 >= this.list.length) {
            n2 -= this.list.length;
        }
        return n2;
    }

    private void resetCapacity() {
        if (this.elementCount < this.list.length) {
            return;
        }
        Object[] objectArray = new Object[this.list.length * 2];
        System.arraycopy(this.list, this.firstindex, objectArray, this.firstindex, this.list.length - this.firstindex);
        if (this.endindex <= this.firstindex) {
            System.arraycopy(this.list, 0, objectArray, this.list.length, this.endindex);
            this.endindex = this.list.length + this.endindex;
        }
        this.list = objectArray;
    }

    public <T> T[] toArray(T[] objectArray) {
        int n;
        if (objectArray.length < this.elementCount) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.elementCount);
        }
        if ((n = this.list.length - this.firstindex) > this.elementCount) {
            n = this.elementCount;
        }
        System.arraycopy(this.list, this.firstindex, objectArray, 0, n);
        if (this.endindex <= this.firstindex) {
            System.arraycopy(this.list, 0, objectArray, n, this.endindex);
        }
        return objectArray;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        return this.toArray(objectArray);
    }

    public List<E> subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }
}

