/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.portal.application.ApplicationStatistic;
import org.picocontainer.Startable;

@Managed
@ManagedDescription(value="Application statistic service")
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="statistic"), @Property(key="type", value="application")})
@RESTEndpoint(path="applicationstatistic")
public class ApplicationStatisticService
implements Startable {
    private final ConcurrentMap<String, ApplicationStatistic> apps = new ConcurrentHashMap<String, ApplicationStatistic>();

    public ApplicationStatistic findApplicationStatistic(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Parameter 'applicationId' is required.");
        }
        ApplicationStatistic result = (ApplicationStatistic)this.apps.get(name);
        if (result == null) {
            String safeName = name.replaceAll("[^a-zA-Z0-9_\\-\\./]+", "");
            throw new IllegalArgumentException("There is no such application with applicationId '" + safeName + "'.");
        }
        return result;
    }

    @Managed
    @ManagedDescription(value="The list of application identifiers sorted alphabetically")
    public String[] getApplicationList() {
        ArrayList list = new ArrayList(this.apps.keySet());
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    public ApplicationStatistic getApplicationStatistic(String appId) {
        ApplicationStatistic existing;
        ApplicationStatistic app = (ApplicationStatistic)this.apps.get(appId);
        if (app == null && (existing = this.apps.putIfAbsent(appId, app = new ApplicationStatistic(appId))) != null) {
            app = existing;
        }
        return app;
    }

    @Managed
    @ManagedDescription(value="The maximum execution time of a specified application in seconds")
    @Impact(value=ImpactType.READ)
    public double getMaxTime(@ManagedDescription(value="The application id") @ManagedName(value="applicationId") String appId) {
        ApplicationStatistic app = this.findApplicationStatistic(appId);
        return this.toSeconds(app.getMaxTime());
    }

    @Managed
    @ManagedDescription(value="The minimum execution time of a specified application in seconds")
    @Impact(value=ImpactType.READ)
    public double getMinTime(@ManagedDescription(value="The application id") @ManagedName(value="applicationId") String appId) {
        ApplicationStatistic app = this.findApplicationStatistic(appId);
        return this.toSeconds(app.getMinTime());
    }

    @Managed
    @ManagedDescription(value="Return the average execution time of a specified application in seconds")
    @Impact(value=ImpactType.READ)
    public double getAverageTime(@ManagedDescription(value="The application id") @ManagedName(value="applicationId") String appId) {
        ApplicationStatistic app = this.findApplicationStatistic(appId);
        return this.toSeconds(app.getAverageTime());
    }

    @Managed
    @ManagedDescription(value="The execution count of a specified application")
    @Impact(value=ImpactType.READ)
    public long getExecutionCount(@ManagedDescription(value="The application id") @ManagedName(value="applicationId") String appId) {
        ApplicationStatistic app = this.findApplicationStatistic(appId);
        return app.executionCount();
    }

    @Managed
    @ManagedDescription(value="The list of the 10 slowest applications")
    public String[] getSlowestApplications() {
        return this.getApplicationsSortedByAverageTime(true);
    }

    @Managed
    @ManagedDescription(value="The list of the 10 fastest applications")
    public String[] getFastestApplications() {
        return this.getApplicationsSortedByAverageTime(false);
    }

    private String[] getApplicationsSortedByAverageTime(boolean desc) {
        ArrayList<ApplicationStatistic> list = new ArrayList<ApplicationStatistic>();
        for (ApplicationStatistic app : this.apps.values()) {
            if (!(app.getAverageTime() > 0.0)) continue;
            list.add(app);
        }
        Collections.sort(list, new Comparator<ApplicationStatistic>(this){

            @Override
            public int compare(ApplicationStatistic o1, ApplicationStatistic o2) {
                return (int)Math.signum(o1.getAverageTime() - o2.getAverageTime());
            }
        });
        if (desc) {
            Collections.reverse(list);
        }
        List<ApplicationStatistic> sub = list.subList(0, Math.min(list.size(), 10));
        return this.asIds(sub);
    }

    @Managed
    @ManagedDescription(value="The list of the 10 most executed applications")
    public String[] getMostExecutedApplications() {
        ArrayList<ApplicationStatistic> list = new ArrayList<ApplicationStatistic>();
        for (ApplicationStatistic app : this.apps.values()) {
            if (app.executionCount() <= 0L) continue;
            list.add(app);
        }
        Collections.sort(list, new Comparator<ApplicationStatistic>(this){

            @Override
            public int compare(ApplicationStatistic o1, ApplicationStatistic o2) {
                long diff = o1.executionCount() - o2.executionCount();
                return diff == 0L ? 0 : (diff > 0L ? -1 : 1);
            }
        });
        List<ApplicationStatistic> sub = list.subList(0, Math.min(list.size(), 10));
        return this.asIds(sub);
    }

    private String[] asIds(List<ApplicationStatistic> list) {
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i).getAppId();
        }
        return array;
    }

    private double toSeconds(double value) {
        return value == -1.0 ? -1.0 : value / 1000.0;
    }

    public void start() {
    }

    public void stop() {
    }
}

