/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIItemSelector;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/portal/webui/portal/UILanguageSelector.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class})})
public class UILanguageSelector
extends UIContainer {
    private String name_ = "UIChangeLanguage";

    public UILanguageSelector() throws Exception {
        LocaleConfigService configService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        Locale currentLocale = Util.getPortalRequestContext().getLocale();
        SelectItemOption localeItem = null;
        ArrayList<SelectItemOption> optionsList = new ArrayList<SelectItemOption>();
        for (Object object : configService.getLocalConfigs()) {
            String translation;
            LocaleConfig localeConfig = (LocaleConfig)object;
            Locale locale = localeConfig.getLocale();
            Object lang = locale.getLanguage();
            String country = locale.getCountry();
            ResourceBundle currentLocaleResourceBundle = this.getResourceBundle(currentLocale);
            ResourceBundle localeResourceBundle = this.getResourceBundle(locale);
            String key = "Locale." + (String)lang;
            Object displayName = null;
            try {
                String translation2 = currentLocaleResourceBundle.getString(key);
                displayName = translation2;
            }
            catch (MissingResourceException e) {
                displayName = this.capitalizeFirstLetter(locale.getDisplayLanguage(currentLocale));
            }
            Object localedName = null;
            try {
                translation = localeResourceBundle.getString(key);
                localedName = translation;
            }
            catch (MissingResourceException e) {
                localedName = this.capitalizeFirstLetter(locale.getDisplayLanguage(locale));
            }
            if (country != null && country.length() > 0) {
                lang = (String)lang + "_" + country;
                key = "Locale." + (String)lang;
                try {
                    translation = currentLocaleResourceBundle.getString(key);
                    displayName = translation;
                }
                catch (MissingResourceException e) {
                    displayName = this.capitalizeFirstLetter(locale.getDisplayLanguage(currentLocale)) + " - " + this.capitalizeFirstLetter(locale.getDisplayCountry(currentLocale));
                }
                try {
                    translation = localeResourceBundle.getString(key);
                    localedName = translation;
                }
                catch (MissingResourceException e) {
                    localedName = this.capitalizeFirstLetter(locale.getDisplayLanguage(locale)) + " - " + this.capitalizeFirstLetter(locale.getDisplayCountry(locale));
                }
            }
            if (localedName == null || ((String)localedName).length() == 0) {
                localedName = "???";
            }
            localeItem = locale.getDisplayName().equalsIgnoreCase(currentLocale.getDisplayName()) ? new SelectItemOption((String)displayName, lang, (String)localedName, "", true) : new SelectItemOption((String)displayName, lang, (String)localedName, "");
            optionsList.add(localeItem);
        }
        Collections.sort(optionsList, new LanguagesComparator(this));
        ArrayList<SelectItemCategory> contientsCategories = new ArrayList<SelectItemCategory>();
        SelectItemCategory category = new SelectItemCategory("Languages");
        category.setSelectItemOptions(optionsList);
        contientsCategories.add(category);
        UIItemSelector selector = new UIItemSelector("Language");
        selector.setItemCategories(contientsCategories);
        selector.setRendered(true);
        this.addChild((UIComponent)selector);
    }

    public String getName() {
        return this.name_;
    }

    private String capitalizeFirstLetter(String word) {
        if (word == null) {
            return null;
        }
        if (word.length() == 0) {
            return word;
        }
        StringBuilder result = new StringBuilder(word);
        result.replace(0, 1, result.substring(0, 1).toUpperCase());
        return result.toString();
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        ExoContainer appContainer = ExoContainerContext.getCurrentContainer();
        ResourceBundleService service = (ResourceBundleService)appContainer.getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle res = service.getResourceBundle("locale.portal.webui", locale);
        return res;
    }

    private class LanguagesComparator
    implements Comparator<SelectItemOption> {
        private LanguagesComparator(UILanguageSelector uILanguageSelector) {
        }

        @Override
        public int compare(SelectItemOption item0, SelectItemOption item1) {
            return item0.getLabel().compareToIgnoreCase(item1.getLabel());
        }
    }

    public static class SaveActionListener
    extends EventListener<UILanguageSelector> {
        public void execute(Event<UILanguageSelector> event) throws Exception {
            WebuiRequestContext rContext = event.getRequestContext();
            String language = event.getRequestContext().getRequestParameter("language");
            PortalRequestContext prqCtx = PortalRequestContext.getCurrentInstance();
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            uiMaskWS.createEvent("Close", Event.Phase.DECODE, rContext).broadcast();
            if (language == null || language.isEmpty() || language.trim().equals(prqCtx.getLocale().getLanguage())) {
                if (prqCtx.getRemoteUser() != null) {
                    this.saveLocaleToUserProfile(prqCtx);
                }
                return;
            }
            LocaleConfigService localeConfigService = (LocaleConfigService)((UILanguageSelector)((Object)event.getSource())).getApplicationComponent(LocaleConfigService.class);
            LocaleConfig localeConfig = localeConfigService.getLocaleConfig(language);
            if (localeConfig == null) {
                localeConfig = localeConfigService.getDefaultLocaleConfig();
            }
            prqCtx.setLocale(localeConfig.getLocale());
            if (prqCtx.getRequestLocale() != null) {
                NodeURL url = ((NodeURL)prqCtx.createURL(NodeURL.TYPE)).setNode(Util.getUIPortal().getNavPath());
                url.setLocale(prqCtx.getLocale());
                prqCtx.sendRedirect(url.toString());
            }
        }

        private void saveLocaleToUserProfile(PortalRequestContext context) throws Exception {
            String currLocale;
            ExoContainer container = context.getApplication().getApplicationServiceContainer();
            OrganizationService svc = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            UserProfile userProfile = svc.getUserProfileHandler().findUserProfileByName(context.getRemoteUser());
            if (userProfile != null && userProfile.getUserInfoMap() != null && ((currLocale = (String)userProfile.getUserInfoMap().get("user.language")) == null || currLocale.trim().equals(""))) {
                userProfile.getUserInfoMap().put("user.language", LocaleContextInfo.getLocaleAsString((Locale)context.getLocale()));
                svc.getUserProfileHandler().saveUserProfile(userProfile, false);
            }
        }
    }
}

