/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public enum SpaceAccessType {
    INVITED_SPACE("social.space.access.invited-space"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            return space != null && SpaceAccessType.getSpaceService().isInvitedUser(space, remoteId);
        }
    }
    ,
    JOIN_SPACE("social.space.access.join-space"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            return space != null && "open".equals(space.getRegistration());
        }
    }
    ,
    REQUESTED_JOIN_SPACE("social.space.access.requested-join-space"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            return space != null && "validation".equals(space.getRegistration()) && SpaceAccessType.getSpaceService().isPendingUser(space, remoteId);
        }
    }
    ,
    REQUEST_JOIN_SPACE("social.space.access.request-join-space"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            return space != null && "validation".equals(space.getRegistration());
        }
    }
    ,
    CLOSED_SPACE("social.space.access.closed-space"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            return space != null && "closed".equals(space.getRegistration()) && !"hidden".equals(space.getVisibility());
        }
    }
    ,
    SPACE_NOT_FOUND("social.space.access.space-not-found"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            return space == null || "closed".equals(space.getRegistration()) && "hidden".equals(space.getVisibility());
        }
    };

    private final String name;
    public static final String ACCESSED_TYPE_KEY = "social.accessed.space.type.key";
    public static final String ACCESSED_SPACE_ID_KEY = "social.accessed.space.id.key";
    public static final String ACCESSED_SPACE_PRETTY_NAME_KEY = "social.accessed.space.prettyName.key";
    public static final String ACCESSED_SPACE_DISPLAY_NAME_KEY = "social.accessed.space.displayName.key";
    public static final String ACCESSED_SPACE_REQUEST_PATH_KEY = "social.accessed.space.request.path.key";

    private SpaceAccessType(String name) {
        this.name = name;
    }

    private static SpaceService getSpaceService() {
        return (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
    }

    public String toString() {
        return this.name;
    }

    public abstract boolean doCheck(String var1, Space var2);

    public String getName() {
        return this.name;
    }
}

