/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.search;

import io.meeds.news.filter.NewsFilter;
import io.meeds.news.search.NewsESSearchResult;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.tag.TagService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class NewsSearchConnector {
    private static final Log LOG = ExoLogger.getLogger(NewsSearchConnector.class);
    private static final String SEARCH_QUERY_FILE_PATH_PARAM = "query.file.path";
    public static final String SEARCH_QUERY_TERM = "\"must\":{ \"query_string\" :{\n        \"fields\": [\"body\", \"posterName\"],\n        \"default_operator\": \"AND\",\n        \"query\": \"@term@\"}\n        },";
    private final ConfigurationManager configurationManager;
    private final IdentityManager identityManager;
    private final ActivityStorage activityStorage;
    private final ElasticSearchingClient client;
    private final String index;
    private final String searchType;
    private String searchQueryFilePath;
    private String searchQuery;

    public NewsSearchConnector(ConfigurationManager configurationManager, IdentityManager identityManager, ActivityStorage activityStorage, ElasticSearchingClient client, InitParams initParams) {
        this.configurationManager = configurationManager;
        this.identityManager = identityManager;
        this.activityStorage = activityStorage;
        this.client = client;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        this.searchType = param.getProperty("searchType");
        if (initParams.containsKey((Object)SEARCH_QUERY_FILE_PATH_PARAM)) {
            this.searchQueryFilePath = initParams.getValueParam(SEARCH_QUERY_FILE_PATH_PARAM).getValue();
            try {
                this.retrieveSearchQuery();
            }
            catch (Exception e) {
                LOG.error("Can't read elasticsearch search query from path {}", new Object[]{this.searchQueryFilePath, e});
            }
        }
    }

    public List<NewsESSearchResult> search(Identity viewerIdentity, NewsFilter filter) {
        if (viewerIdentity == null) {
            throw new IllegalArgumentException("Viewer identity is mandatory");
        }
        if (filter.getOffset() < 0) {
            throw new IllegalArgumentException("Offset must be positive");
        }
        if (filter.getLimit() < 0) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        if (StringUtils.isBlank((CharSequence)filter.getSearchText()) && !filter.isFavorites() && CollectionUtils.isEmpty(filter.getTagNames())) {
            throw new IllegalArgumentException("Filter term is mandatory");
        }
        Set streamFeedOwnerIds = this.activityStorage.getStreamFeedOwnerIds(viewerIdentity);
        String esQuery = this.buildQueryStatement(viewerIdentity, streamFeedOwnerIds, filter);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildResult(jsonResponse);
    }

    private String buildQueryStatement(Identity viewerIdentity, Set<Long> streamFeedOwnerIds, NewsFilter filter) {
        Map<String, List<String>> metadataFilters = this.buildMetadataFilter(filter, viewerIdentity);
        String termQuery = this.buildTermQueryStatement(filter.getSearchText());
        String favoriteQuery = this.buildFavoriteQueryStatement(metadataFilters.get(FavoriteService.METADATA_TYPE.getName()));
        String tagsQuery = this.buildTagsQueryStatement(metadataFilters.get(TagService.METADATA_TYPE.getName()));
        return this.retrieveSearchQuery().replace("@term_query@", termQuery).replace("@favorite_query@", favoriteQuery).replace("@tags_query@", tagsQuery).replace("@permissions@", StringUtils.join(streamFeedOwnerIds, (String)",")).replace("@offset@", String.valueOf(filter.getOffset())).replace("@limit@", String.valueOf(filter.getLimit()));
    }

    private List<NewsESSearchResult> buildResult(String jsonResponse) {
        Map json;
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<NewsESSearchResult> results = new ArrayList<NewsESSearchResult>();
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return results;
        }
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            try {
                JSONArray bodyExcepts;
                NewsESSearchResult newsSearchResult = new NewsESSearchResult();
                JSONObject jsonHitObject = (JSONObject)jsonHit;
                JSONObject hitSource = (JSONObject)jsonHitObject.get((Object)"_source");
                String id = (String)hitSource.get((Object)"id");
                String posterId = (String)hitSource.get((Object)"posterId");
                String spaceDisplayName = (String)hitSource.get((Object)"spaceDisplayName");
                String newsActivityId = (String)hitSource.get((Object)"newsActivityId");
                Long postedTime = this.parseLong(hitSource, "postedTime");
                Long lastUpdatedTime = this.parseLong(hitSource, "lastUpdatedTime");
                String title = (String)hitSource.get((Object)"title");
                String body = (String)hitSource.get((Object)"body");
                JSONObject highlightSource = (JSONObject)jsonHitObject.get((Object)"highlight");
                ArrayList<String> excerpts = new ArrayList();
                if (highlightSource != null && (bodyExcepts = (JSONArray)highlightSource.get((Object)"body")) != null) {
                    excerpts = Arrays.asList((String[])bodyExcepts.toArray((Object[])new String[0]));
                }
                newsSearchResult.setId(id);
                newsSearchResult.setTitle(title);
                if (posterId != null) {
                    Identity posterIdentity = this.identityManager.getOrCreateIdentity("organization", posterId);
                    newsSearchResult.setPoster(posterIdentity);
                }
                newsSearchResult.setPostedTime(postedTime);
                newsSearchResult.setLastUpdatedTime(lastUpdatedTime);
                newsSearchResult.setSpaceDisplayName(spaceDisplayName);
                newsSearchResult.setActivityId(newsActivityId);
                String portalName = PortalContainer.getCurrentPortalContainerName();
                String portalOwner = CommonsUtils.getCurrentPortalOwner();
                newsSearchResult.setNewsUrl("/" + portalName + "/" + portalOwner + "/activity?id=" + newsActivityId);
                newsSearchResult.setBody(body);
                newsSearchResult.setExcerpts(excerpts);
                results.add(newsSearchResult);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error processing news search result item, ignore it from results", (Throwable)e);
            }
        }
        return results;
    }

    private String buildTermQueryStatement(String term) {
        if (StringUtils.isBlank((CharSequence)term)) {
            return term;
        }
        term = this.removeSpecialCharacters(term);
        return SEARCH_QUERY_TERM.replace("@term@", term);
    }

    private Long parseLong(JSONObject hitSource, String key) {
        String value = (String)hitSource.get((Object)key);
        return StringUtils.isBlank((CharSequence)value) ? null : Long.valueOf(Long.parseLong(value));
    }

    private String retrieveSearchQuery() {
        if (StringUtils.isBlank((CharSequence)this.searchQuery) || PropertyManager.isDevelopping()) {
            try {
                InputStream queryFileIS = this.configurationManager.getInputStream(this.searchQueryFilePath);
                this.searchQuery = IOUtil.getStreamContentAsString((InputStream)queryFileIS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving search query from file: " + this.searchQueryFilePath, e);
            }
        }
        return this.searchQuery;
    }

    private String removeSpecialCharacters(String string) {
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").replaceAll("'", " ");
        return string;
    }

    private String buildFavoriteQueryStatement(List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        return "{\"terms\":{" + "\"metadatas.favorites.metadataName.keyword\": [\"" + StringUtils.join(values, (String)"\",\"") + "\"]}},";
    }

    private String buildTagsQueryStatement(List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        List tagsQueryParts = values.stream().map(value -> "{\"term\": {\n" + "            \"metadatas.tags.metadataName.keyword\": {\n" + "              \"value\": \"" + value + "\",\n" + "              \"case_insensitive\":true\n" + "            }\n" + "          }}").collect(Collectors.toList());
        return ",\"should\": [\n" + StringUtils.join(tagsQueryParts, (String)",") + "      ],\n" + "      \"minimum_should_match\": 1";
    }

    private Map<String, List<String>> buildMetadataFilter(NewsFilter filter, Identity viewerIdentity) {
        HashMap<String, List<String>> metadataFilters = new HashMap<String, List<String>>();
        if (filter.isFavorites()) {
            metadataFilters.put(FavoriteService.METADATA_TYPE.getName(), Collections.singletonList(viewerIdentity.getId()));
        }
        if (CollectionUtils.isNotEmpty(filter.getTagNames())) {
            metadataFilters.put(TagService.METADATA_TYPE.getName(), filter.getTagNames());
        }
        return metadataFilters;
    }
}

