/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.unique;

import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.unique.AlterTableUniqueDelegate;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

public class CreateTableUniqueDelegate
extends AlterTableUniqueDelegate {
    public CreateTableUniqueDelegate(Dialect dialect) {
        super(dialect);
    }

    @Override
    public String getColumnDefinitionUniquenessFragment(Column column, SqlStringGenerationContext context) {
        return context.isMigration() ? super.getColumnDefinitionUniquenessFragment(column, context) : (column.isUnique() ? " unique" : "");
    }

    @Override
    public String getTableCreationUniqueConstraintsFragment(Table table, SqlStringGenerationContext context) {
        if (context.isMigration()) {
            return super.getTableCreationUniqueConstraintsFragment(table, context);
        }
        StringBuilder fragment = new StringBuilder();
        for (UniqueKey uniqueKey : table.getUniqueKeys().values()) {
            if (CreateTableUniqueDelegate.isSingleColumnUnique(table, uniqueKey)) continue;
            this.appendUniqueConstraint(fragment, uniqueKey);
        }
        return fragment.toString();
    }

    protected void appendUniqueConstraint(StringBuilder fragment, UniqueKey uniqueKey) {
        fragment.append(", ");
        if (uniqueKey.isNameExplicit()) {
            fragment.append("constraint ").append(uniqueKey.getName()).append(" ");
        }
        fragment.append(this.uniqueConstraintSql(uniqueKey));
    }

    private static boolean isSingleColumnUnique(Table table, UniqueKey uniqueKey) {
        return uniqueKey.getColumns().size() == 1 && (uniqueKey.getColumn(0).isUnique() || table.getColumn(uniqueKey.getColumn(0)).isUnique());
    }

    @Override
    public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
        return context.isMigration() ? super.getAlterTableToAddUniqueKeyCommand(uniqueKey, metadata, context) : "";
    }

    @Override
    public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
        return context.isMigration() ? super.getAlterTableToDropUniqueKeyCommand(uniqueKey, metadata, context) : "";
    }
}

