/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.storage;

import io.meeds.gamification.twitter.dao.TwitterTweetDAO;
import io.meeds.gamification.twitter.entity.TwitterTweetEntity;
import io.meeds.gamification.twitter.model.Tweet;
import io.meeds.gamification.twitter.storage.mapper.TwitterTweetMapper;
import java.util.List;
import java.util.Set;

public class TwitterTweetStorage {
    private final TwitterTweetDAO twitterTweetDAO;

    public TwitterTweetStorage(TwitterTweetDAO twitterTweetDAO) {
        this.twitterTweetDAO = twitterTweetDAO;
    }

    public Tweet addTweetToWatch(Tweet tweet) {
        Tweet existsTweet = this.getTweetByLink(tweet.getTweetLink());
        if (existsTweet == null) {
            TwitterTweetEntity twitterTweetEntity = TwitterTweetMapper.toEntity(tweet);
            twitterTweetEntity = (TwitterTweetEntity)this.twitterTweetDAO.create(twitterTweetEntity);
            return TwitterTweetMapper.fromEntity(twitterTweetEntity);
        }
        return null;
    }

    public Tweet updateTweetReactions(long tweetId, Set<String> likers, Set<String> retweeters) {
        TwitterTweetEntity twitterTweetEntity = (TwitterTweetEntity)this.twitterTweetDAO.find(Long.valueOf(tweetId));
        twitterTweetEntity.setLikers(likers);
        twitterTweetEntity.setRetweeters(retweeters);
        return TwitterTweetMapper.fromEntity((TwitterTweetEntity)this.twitterTweetDAO.update(twitterTweetEntity));
    }

    public List<Long> getTweets(int offset, int limit) {
        return this.twitterTweetDAO.getTweetsIds(offset, limit);
    }

    public int countTweets() {
        return this.twitterTweetDAO.count().intValue();
    }

    public Tweet getTweetById(Long tweetId) {
        return TwitterTweetMapper.fromEntity((TwitterTweetEntity)this.twitterTweetDAO.find(tweetId));
    }

    public Tweet getTweetByLink(String tweetLink) {
        TwitterTweetEntity twitterTweetEntity = this.twitterTweetDAO.getTweetByLink(tweetLink);
        return TwitterTweetMapper.fromEntity(twitterTweetEntity);
    }

    public Tweet deleteTweet(long tweetId) {
        TwitterTweetEntity twitterTweetEntity = (TwitterTweetEntity)this.twitterTweetDAO.find(Long.valueOf(tweetId));
        if (twitterTweetEntity != null) {
            this.twitterTweetDAO.delete(twitterTweetEntity);
        }
        return TwitterTweetMapper.fromEntity(twitterTweetEntity);
    }
}

