/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.elasticsearch.storage;

import io.meeds.analytics.elasticsearch.model.ElasticsearchResponse;
import io.meeds.analytics.elasticsearch.storage.ElasticsearchAnalyticsStorage$AjcClosure1;
import io.meeds.analytics.elasticsearch.storage.ElasticsearchAnalyticsStorage$AjcClosure3;
import io.meeds.analytics.elasticsearch.storage.ElasticsearchAnalyticsStorage$AjcClosure5;
import io.meeds.analytics.elasticsearch.storage.ElasticsearchConfiguration;
import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.model.StatisticDataQueueEntry;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.aspectj.AnnotationCacheAspect;
import org.springframework.stereotype.Component;

@Component
public class ElasticsearchAnalyticsStorage {
    private static final Log LOG;
    private static final long DAY_IN_MS = 86400000L;
    private static final String DAY_DATE_FORMAT = "yyyy-MM-dd";
    public static final DateTimeFormatter DAY_DATE_FORMATTER;
    @Autowired
    private ElasticsearchConfiguration elasticsearchConfiguration;
    @Autowired
    @Qualifier(value="elasticsearchHttpClient")
    private HttpClient httpClient;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    @PostConstruct
    public void init() {
        try {
            this.checkIndexTemplateExistence();
            CompletableFuture.runAsync(this::sendRolloverRequest);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while initializing Elasticsearch connection", (Throwable)e);
        }
    }

    public void sendCreateBulkDocumentsRequest(List<StatisticDataQueueEntry> dataQueueEntries) {
        if (dataQueueEntries == null || dataQueueEntries.isEmpty()) {
            return;
        }
        LOG.debug("Indexing in bulk {} documents", new Object[]{dataQueueEntries.size()});
        this.sendCreateIndexRequest();
        StringBuilder request = new StringBuilder();
        for (StatisticDataQueueEntry statisticDataQueueEntry : dataQueueEntries) {
            String singleDocumentQuery = this.getCreateDocumentRequestContent(String.valueOf(statisticDataQueueEntry.getId()), statisticDataQueueEntry.getStatisticData());
            request.append(singleDocumentQuery);
        }
        LOG.debug("Create documents request to ES: {}", new Object[]{request});
        this.sendPutRequest("_bulk", request.toString());
        this.sendRefreshIndex();
    }

    public String search(String esQuery) {
        ElasticsearchResponse elasticResponse = this.sendPostRequest(this.elasticsearchConfiguration.getIndexAlias() + "/_search", esQuery);
        String response = elasticResponse.getMessage();
        int statusCode = elasticResponse.getStatusCode();
        if (StringUtils.isBlank((CharSequence)response)) {
            response = "Empty response was sent by ES";
        } else if (!this.isError(elasticResponse)) {
            JSONObject json = null;
            try {
                json = new JSONObject(response);
                if (json.has("status") && this.isError(json.getInt("status"))) {
                    throw new IllegalStateException("Error occured while requesting ES HTTP error code: '" + statusCode + "', HTTP response: '" + response + "'");
                }
            }
            catch (JSONException e) {
                throw new IllegalStateException("Error occured while requesting ES HTTP code: '" + statusCode + "', Error parsing response to JSON format, content = '" + response + "'", e);
            }
        }
        return response;
    }

    public String retrieveAllAnalyticsIndexesMapping() {
        ElasticsearchResponse response = this.sendGetRequest(this.elasticsearchConfiguration.getIndexAlias() + "/_mapping", false);
        if (this.isError(response)) {
            LOG.warn("Error getting mapping of analytics : - \t\tcode : {} - \t\tmessage: {}", new Object[]{response.getStatusCode(), response.getMessage()});
            return null;
        }
        return response.getMessage();
    }

    public ElasticsearchResponse sendGetRequest(String uri) {
        return this.sendGetRequest(uri, true);
    }

    public ElasticsearchResponse sendGetRequest(String uri, boolean handleResponse) {
        ElasticsearchResponse response = this.sendHttpGetRequest(this.elasticsearchConfiguration.getUrlClient() + "/" + uri);
        if (handleResponse) {
            return this.handleESResponse(response, uri, null);
        }
        return response;
    }

    public ElasticsearchResponse sendHeadRequest(String uri) {
        ElasticsearchResponse response = this.sendHttpHeadRequest(this.elasticsearchConfiguration.getUrlClient() + "/" + uri);
        return this.handleESResponse(response, uri, null);
    }

    public ElasticsearchResponse sendPutRequest(String uri, String content) {
        ElasticsearchResponse response = this.sendHttpPutRequest(this.elasticsearchConfiguration.getUrlClient() + "/" + uri, content);
        return this.handleESResponse(response, uri, content);
    }

    public ElasticsearchResponse sendDeleteRequest(String uri) {
        ElasticsearchResponse response = this.sendHttpDeleteRequest(this.elasticsearchConfiguration.getUrlClient() + "/" + uri);
        return this.handleESResponse(response, uri, null);
    }

    public ElasticsearchResponse sendPostRequest(String uri, String content) {
        ElasticsearchResponse response = this.sendHttpPostRequest(this.elasticsearchConfiguration.getUrlClient() + "/" + uri, content);
        return this.handleESResponse(response, uri, content);
    }

    private boolean sendCreateIndexRequest() {
        String index = this.getIndex();
        if (this.sendIsIndexExistsRequest(index)) {
            LOG.debug("Index {} already exists. Index creation requests will not be sent.", new Object[]{index});
            return false;
        }
        this.sendTurnOffWriteOnAllAnalyticsIndexes();
        this.sendCreateIndex(index);
        if (this.sendIsIndexExistsRequest(index)) {
            LOG.info("New analytics index {} created.", new Object[]{index});
            return true;
        }
        throw new IllegalStateException("Error creating index " + index + " on elasticsearch");
    }

    private void sendTurnOffWriteOnAllAnalyticsIndexes() {
        if (this.sendIsIndexExistsRequest(this.elasticsearchConfiguration.getIndexAlias())) {
            String esQuery = this.getTurnOffWriteOnAllAnalyticsIndexes();
            try {
                this.sendPostRequest("_aliases", esQuery);
                LOG.info((Object)"All analytics indexes switched to RO mode to prepare creation of a new index");
            }
            catch (Exception e) {
                LOG.warn((Object)"Analytics old indexes seems to not be turned off on write access");
            }
        }
    }

    @Cacheable(value={"analytics.indexExists"})
    private boolean sendIsIndexExistsRequest(String esIndex) {
        String string = esIndex;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return Conversions.booleanValue((Object)AnnotationCacheAspect.aspectOf().ajc$around$org_springframework_cache_aspectj_AbstractCacheAspect$1$2bc714b5((Object)this, (AroundClosure)new ElasticsearchAnalyticsStorage$AjcClosure1(objectArray), joinPoint));
    }

    @CacheEvict(value={"analytics.indexExists"})
    private void sendCreateIndex(String index) {
        String string = index;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AnnotationCacheAspect.aspectOf().ajc$around$org_springframework_cache_aspectj_AbstractCacheAspect$1$2bc714b5((Object)this, (AroundClosure)new ElasticsearchAnalyticsStorage$AjcClosure3(objectArray), joinPoint);
    }

    private boolean sendIsIndexTemplateExistsRequest() {
        ElasticsearchResponse responseExists = this.sendGetRequest("_index_template/" + this.elasticsearchConfiguration.getIndexTemplateName(), false);
        return responseExists.getStatusCode() == 200;
    }

    private void sendRefreshIndex() {
        this.sendRefreshIndex(this.elasticsearchConfiguration.getIndexAlias());
    }

    private void sendRefreshIndex(String index) {
        this.sendPostRequest(index + "/_refresh", null);
    }

    private ElasticsearchResponse sendHttpPostRequest(String url, String content) {
        HttpPost httpTypeRequest = new HttpPost(url);
        if (StringUtils.isNotBlank((CharSequence)content)) {
            httpTypeRequest.setEntity((HttpEntity)new StringEntity(content, ContentType.APPLICATION_JSON));
        }
        return (ElasticsearchResponse)this.httpClient.execute((ClassicHttpRequest)httpTypeRequest, this::handleHttpResponse);
    }

    private ElasticsearchResponse sendHttpPutRequest(String url, String content) {
        HttpPut httpTypeRequest = new HttpPut(url);
        if (StringUtils.isNotBlank((CharSequence)content)) {
            httpTypeRequest.setEntity((HttpEntity)new StringEntity(content, ContentType.APPLICATION_JSON));
        }
        return (ElasticsearchResponse)this.httpClient.execute((ClassicHttpRequest)httpTypeRequest, this::handleHttpResponse);
    }

    private ElasticsearchResponse sendHttpDeleteRequest(String url) {
        HttpDelete httpDeleteRequest = new HttpDelete(url);
        return (ElasticsearchResponse)this.httpClient.execute((ClassicHttpRequest)httpDeleteRequest, this::handleHttpResponse);
    }

    private ElasticsearchResponse sendHttpGetRequest(String url) {
        HttpGet httpGetRequest = new HttpGet(url);
        return (ElasticsearchResponse)this.httpClient.execute((ClassicHttpRequest)httpGetRequest, this::handleHttpResponse);
    }

    private ElasticsearchResponse sendHttpHeadRequest(String url) {
        HttpHead httpHeadRequest = new HttpHead(url);
        return (ElasticsearchResponse)this.httpClient.execute((ClassicHttpRequest)httpHeadRequest, this::handleHttpResponse);
    }

    private String getCreateIndexRequestContent() {
        return " {\"aliases\": {  \"" + this.elasticsearchConfiguration.getIndexAlias() + "\": {    \"is_write_index\" : true  }}}";
    }

    private String getTurnOffWriteOnAllAnalyticsIndexes() {
        return "{\"actions\": [  {    \"add\": {      \"index\": \"" + this.elasticsearchConfiguration.getIndexPrefix() + "*\",      \"alias\": \"" + this.elasticsearchConfiguration.getIndexAlias() + "\",      \"is_write_index\": false    }  }]}";
    }

    private String getCreateDocumentRequestContent(String id, StatisticData data) {
        JSONObject jsonObject = this.createCUDHeaderRequestContent(id);
        String timestampString = String.valueOf(data.getTimestamp());
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("id", id);
        fields.put("timestamp", timestampString);
        fields.put("userId", String.valueOf(data.getUserId()));
        fields.put("spaceId", String.valueOf(data.getSpaceId()));
        fields.put("module", data.getModule());
        fields.put("subModule", data.getSubModule());
        fields.put("operation", data.getOperation());
        fields.put("status", String.valueOf(data.getStatus().ordinal()));
        fields.put("errorCode", String.valueOf(data.getErrorCode()));
        fields.put("errorMessage", data.getErrorMessage());
        fields.put("duration", String.valueOf(data.getDuration()));
        fields.put("isAnalytics", "true");
        if (data.getParameters() != null && !data.getParameters().isEmpty()) {
            fields.putAll(data.getParameters());
        }
        Document document = new Document(String.valueOf(id), null, null, (Set)null, fields);
        if (data.getListParameters() != null && !data.getListParameters().isEmpty()) {
            document.setListFields(data.getListParameters());
        }
        JSONObject createRequest = new JSONObject();
        createRequest.put("create", (Object)jsonObject);
        return createRequest.toString() + "\n" + document.toJSON() + "\n";
    }

    private JSONObject createCUDHeaderRequestContent(String id) {
        JSONObject cudHeader = new JSONObject();
        cudHeader.put("_index", (Object)this.elasticsearchConfiguration.getIndexAlias());
        cudHeader.put("_id", (Object)id);
        return cudHeader;
    }

    private ElasticsearchResponse handleHttpResponse(ClassicHttpResponse httpResponse) throws IOException {
        HttpEntity entity = httpResponse.getEntity();
        int statusCode = httpResponse.getCode();
        return new ElasticsearchResponse(EntityUtils.toString((HttpEntity)entity), statusCode);
    }

    private boolean isError(ElasticsearchResponse response) {
        return this.isError(response.getStatusCode());
    }

    private boolean isError(int status) {
        return status / 100 != 2;
    }

    private ElasticsearchResponse handleESResponse(ElasticsearchResponse response, String uri, String content) {
        if (this.isError(response) || StringUtils.contains((CharSequence)response.getMessage(), (CharSequence)"\"errors\":true")) {
            throw new IllegalStateException(String.format("Error message returned from ES: %s. URI: %s. Content: %s", response.getMessage(), uri, content));
        }
        if (StringUtils.contains((CharSequence)response.getMessage(), (CharSequence)"\"type\":\"version_conflict_engine_exception\"")) {
            LOG.warn("ID conflict in some content: {}", new Object[]{response.getMessage()});
        }
        return response;
    }

    private void checkIndexTemplateExistence() {
        if (!this.sendIsIndexTemplateExistsRequest()) {
            String indexTemplate = this.elasticsearchConfiguration.getIndexTemplateName();
            this.sendPostRequest("_index_template/" + indexTemplate, this.elasticsearchConfiguration.getIndexTemplateMapping());
            if (this.sendIsIndexTemplateExistsRequest()) {
                LOG.info("Index Template {} created.", new Object[]{indexTemplate});
            } else {
                throw new IllegalStateException("Error while creating Index Template " + indexTemplate);
            }
        }
    }

    private void sendRolloverRequest() {
        LOG.info((Object)"Analytics Indices rollover process start");
        ElasticsearchResponse response = this.sendGetRequest(this.elasticsearchConfiguration.getIndexPrefix() + "_*?allow_no_indices=true&ignore_unavailable=true");
        String indexListJsonString = response.getMessage();
        JSONObject jsonObject = new JSONObject(indexListJsonString);
        List<String> outdatedIndices = jsonObject.keySet().stream().sorted((s1, s2) -> StringUtils.compare((String)s2, (String)s1)).skip(this.elasticsearchConfiguration.getMaxIndexCount()).filter(Objects::nonNull).toList();
        while (!outdatedIndices.isEmpty()) {
            List outdatedIndicesSubList = outdatedIndices.stream().limit(10L).toList();
            String outdatedIndiceNames = StringUtils.join(outdatedIndicesSubList, (String)",");
            LOG.info("Deleting {} outdated analytics Indices: [{}]", new Object[]{outdatedIndicesSubList.size(), outdatedIndiceNames});
            this.sendDeleteRequest(outdatedIndiceNames);
            outdatedIndices = outdatedIndices.stream().skip(10L).toList();
        }
        LOG.info((Object)"Analytics Indices rollover process finished successfully.");
    }

    private final String getIndex() {
        return this.getIndex(System.currentTimeMillis() / this.getIndexPerDaysMs());
    }

    @Cacheable(value={"analytics.indexName"})
    private final String getIndex(long indexPeriodIndex) {
        long l = indexPeriodIndex;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        return (String)AnnotationCacheAspect.aspectOf().ajc$around$org_springframework_cache_aspectj_AbstractCacheAspect$1$2bc714b5((Object)this, (AroundClosure)new ElasticsearchAnalyticsStorage$AjcClosure5(objectArray), joinPoint);
    }

    private long getIndexPerDaysMs() {
        return 86400000L * Math.max(this.elasticsearchConfiguration.getIndexPerDays(), 1L);
    }

    static {
        ElasticsearchAnalyticsStorage.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(ElasticsearchAnalyticsStorage.class);
        DAY_DATE_FORMATTER = DateTimeFormatter.ofPattern(DAY_DATE_FORMAT).withResolverStyle(ResolverStyle.LENIENT);
    }

    static /* synthetic */ boolean sendIsIndexExistsRequest_aroundBody0(ElasticsearchAnalyticsStorage ajc$this, String esIndex, JoinPoint joinPoint) {
        ElasticsearchResponse responseExists = ajc$this.sendGetRequest(esIndex, false);
        return responseExists.getStatusCode() == 200;
    }

    static /* synthetic */ void sendCreateIndex_aroundBody2(ElasticsearchAnalyticsStorage ajc$this, String index, JoinPoint joinPoint) {
        ajc$this.sendPutRequest(index, ajc$this.getCreateIndexRequestContent());
        CompletableFuture.runAsync(ajc$this::sendRolloverRequest);
    }

    static /* synthetic */ String getIndex_aroundBody4(ElasticsearchAnalyticsStorage ajc$this, long indexPeriodIndex, JoinPoint joinPoint) {
        long periodEpochMs = indexPeriodIndex * ajc$this.getIndexPerDaysMs();
        String indexSuffix = DAY_DATE_FORMATTER.format(Instant.ofEpochMilli(periodEpochMs).atZone(ZoneOffset.UTC));
        return ajc$this.elasticsearchConfiguration.getIndexPrefix() + "_" + indexSuffix;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ElasticsearchAnalyticsStorage.java", ElasticsearchAnalyticsStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "sendIsIndexExistsRequest", "io.meeds.analytics.elasticsearch.storage.ElasticsearchAnalyticsStorage", "java.lang.String", "esIndex", "", "boolean"), 227);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "sendCreateIndex", "io.meeds.analytics.elasticsearch.storage.ElasticsearchAnalyticsStorage", "java.lang.String", "index", "", "void"), 233);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12", "getIndex", "io.meeds.analytics.elasticsearch.storage.ElasticsearchAnalyticsStorage", "long", "indexPeriodIndex", "", "java.lang.String"), 424);
    }
}

