/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.ModelPartResultMemento;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.implicit.ImplicitModelPartResultBuilderBasic;
import org.hibernate.query.results.implicit.ImplicitModelPartResultBuilderEmbeddable;
import org.hibernate.query.results.implicit.ImplicitModelPartResultBuilderEntity;
import org.hibernate.spi.NavigablePath;

public class ImplicitModelPartResultMemento
implements ModelPartResultMemento {
    private final NavigablePath navigablePath;
    private final ModelPart referencedModelPart;

    public ImplicitModelPartResultMemento(NavigablePath navigablePath, ModelPart referencedModelPart) {
        this.navigablePath = navigablePath;
        this.referencedModelPart = referencedModelPart;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ResultBuilder resolve(Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        if (this.referencedModelPart instanceof BasicValuedModelPart) {
            return new ImplicitModelPartResultBuilderBasic(this.navigablePath, (BasicValuedModelPart)this.referencedModelPart);
        }
        if (this.referencedModelPart instanceof EmbeddableValuedModelPart) {
            return new ImplicitModelPartResultBuilderEmbeddable(this.navigablePath, (EmbeddableValuedModelPart)this.referencedModelPart);
        }
        if (this.referencedModelPart instanceof EntityValuedModelPart) {
            return new ImplicitModelPartResultBuilderEntity(this.navigablePath, (EntityValuedModelPart)this.referencedModelPart);
        }
        throw new IllegalStateException("Unknown type of model part : " + this.referencedModelPart);
    }
}

