/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.index.impl;

import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.index.IndexingServiceConnector;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.simple.JSONObject;

public abstract class ElasticIndexingServiceConnector
extends IndexingServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(ElasticIndexingServiceConnector.class);
    private static final Integer REPLICAS_NUMBER_DEFAULT = 0;
    private static final String REPLICAS_NUMBER_PROPERTY_NAME = "exo.es.indexing.replica.number.default";
    private static final Integer SHARDS_NUMBER_DEFAULT = 5;
    private static final String SHARDS_PROPERTY_NAME = "exo.es.indexing.shard.number.default";
    private static final String MAPPING_FILE_PATH_PARAM = "mapping.file.path";
    protected String indexAlias;
    protected String currentIndex;
    protected String previousIndex;
    protected String mapping;
    protected boolean reindexOnUpgrade;
    protected Integer shards = SHARDS_NUMBER_DEFAULT;
    protected Integer replicas = REPLICAS_NUMBER_DEFAULT;

    protected ElasticIndexingServiceConnector(InitParams initParams) {
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.currentIndex = param.getProperty("index_current");
        this.previousIndex = param.getProperty("index_previous");
        String reindexOnUpgradeString = param.getProperty("reindexOnUpgrade");
        if (StringUtils.isBlank((CharSequence)this.currentIndex)) {
            throw new IllegalStateException("Connector ES index name is mandatory.");
        }
        this.indexAlias = param.getProperty("index_alias");
        if (StringUtils.isBlank((CharSequence)this.indexAlias)) {
            this.indexAlias = this.currentIndex;
        }
        boolean bl = this.reindexOnUpgrade = StringUtils.isNotBlank((CharSequence)reindexOnUpgradeString) && reindexOnUpgradeString.trim().equalsIgnoreCase("true");
        if (StringUtils.isNotBlank((CharSequence)param.getProperty("replica.number"))) {
            this.replicas = Integer.valueOf(param.getProperty("replica.number"));
        } else if (StringUtils.isNotBlank((CharSequence)PropertyManager.getProperty((String)REPLICAS_NUMBER_PROPERTY_NAME))) {
            this.replicas = Integer.valueOf(PropertyManager.getProperty((String)REPLICAS_NUMBER_PROPERTY_NAME));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getProperty("shard.number"))) {
            this.shards = Integer.valueOf(param.getProperty("shard.number"));
        } else if (StringUtils.isNotBlank((CharSequence)PropertyManager.getProperty((String)SHARDS_PROPERTY_NAME))) {
            this.shards = Integer.valueOf(PropertyManager.getProperty((String)SHARDS_PROPERTY_NAME));
        }
        if (initParams.containsKey((Object)MAPPING_FILE_PATH_PARAM)) {
            String mappingFilePath = initParams.getValueParam(MAPPING_FILE_PATH_PARAM).getValue();
            try {
                PortalContainer container = PortalContainer.getInstance();
                ConfigurationManager configurationManager = (ConfigurationManager)container.getComponentInstanceOfType(ConfigurationManager.class);
                InputStream mappingFileIS = configurationManager.getInputStream(mappingFilePath);
                this.mapping = IOUtil.getStreamContentAsString((InputStream)mappingFileIS);
            }
            catch (Exception e) {
                LOG.error("Can't read elasticsearch index mapping from path {}", new Object[]{mappingFilePath, e});
            }
        }
    }

    public String getMapping() {
        if (StringUtils.isNotBlank((CharSequence)this.mapping)) {
            return this.mapping;
        }
        JSONObject notAnalyzedField = new JSONObject();
        notAnalyzedField.put((Object)"type", (Object)"text");
        notAnalyzedField.put((Object)"index", (Object)false);
        JSONObject keywordMapping = new JSONObject();
        keywordMapping.put((Object)"type", (Object)"keyword");
        JSONObject properties = new JSONObject();
        properties.put((Object)"permissions", (Object)keywordMapping);
        properties.put((Object)"sites", (Object)keywordMapping);
        properties.put((Object)"url", (Object)notAnalyzedField);
        JSONObject mappingProperties = new JSONObject();
        mappingProperties.put((Object)"properties", (Object)properties);
        return mappingProperties.toJSONString();
    }

    public String getCurrentIndex() {
        return this.currentIndex;
    }

    public String getPreviousIndex() {
        return this.previousIndex;
    }

    public void setPreviousIndex(String previousIndex) {
        this.previousIndex = previousIndex;
    }

    public boolean isReindexOnUpgrade() {
        return this.reindexOnUpgrade;
    }

    public String getIndexAlias() {
        return this.indexAlias;
    }

    public Integer getShards() {
        return this.shards;
    }

    public void setShards(Integer shards) {
        this.shards = shards;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    @Override
    public String delete(String id) {
        return id;
    }

    public boolean isNeedIngestPipeline() {
        return false;
    }

    public String getPipelineName() {
        return null;
    }

    public String getReindexPipelineName() {
        return null;
    }

    public String getAttachmentProcessor() {
        return null;
    }
}

