/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent.jdk8backported;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.util.concurrent.jdk8backported.Unsafe;

public class ThreadLocalRandomUtil {
    private static final int PROBE_INCREMENT = -1640531527;
    private static final long SEEDER_INCREMENT = -4942790177534073029L;
    private static final sun.misc.Unsafe U = Unsafe.getUnsafe();
    private static final long SEED;
    private static final long PROBE;
    private static final AtomicInteger probeGenerator;
    private static final AtomicLong seeder;

    private static long mix64(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        return z ^ z >>> 33;
    }

    private ThreadLocalRandomUtil() {
    }

    static final void localInit() {
        int p = probeGenerator.addAndGet(-1640531527);
        int probe = p == 0 ? 1 : p;
        long seed = ThreadLocalRandomUtil.mix64(seeder.getAndAdd(-4942790177534073029L));
        Thread t = Thread.currentThread();
        U.putLong(t, SEED, seed);
        U.putInt(t, PROBE, probe);
    }

    static final int getProbe() {
        return U.getInt(Thread.currentThread(), PROBE);
    }

    static final int advanceProbe(int probe) {
        probe ^= probe << 13;
        probe ^= probe >>> 17;
        probe ^= probe << 5;
        U.putInt(Thread.currentThread(), PROBE, probe);
        return probe;
    }

    static {
        try {
            SEED = U.objectFieldOffset(Thread.class.getDeclaredField("threadLocalRandomSeed"));
            PROBE = U.objectFieldOffset(Thread.class.getDeclaredField("threadLocalRandomProbe"));
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
        probeGenerator = new AtomicInteger();
        seeder = new AtomicLong(ThreadLocalRandomUtil.mix64(System.currentTimeMillis()) ^ ThreadLocalRandomUtil.mix64(System.nanoTime()));
        if (AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("java.util.secureRandomSeed");
            }
        }).booleanValue()) {
            byte[] seedBytes = SecureRandom.getSeed(8);
            long s = (long)seedBytes[0] & 0xFFL;
            for (int i = 1; i < 8; ++i) {
                s = s << 8 | (long)seedBytes[i] & 0xFFL;
            }
            seeder.set(s);
        }
    }
}

