/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa;

import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.social.core.jpa.storage.dao.UserSpaceBindingDAO;
import org.exoplatform.social.core.jpa.storage.entity.UserSpaceBindingEntity;

public class UserSpaceBindingDAOImpl
extends GenericDAOJPAImpl<UserSpaceBindingEntity, Long>
implements UserSpaceBindingDAO {
    @Override
    public List<UserSpaceBindingEntity> findUserBindingsByGroup(String group, String userName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocUserSpaceBinding.findUserBindingsByGroup", UserSpaceBindingEntity.class);
        query.setParameter("group", (Object)group);
        query.setParameter("userName", (Object)userName);
        return query.getResultList();
    }

    @Override
    public List<UserSpaceBindingEntity> findUserAllBindingsByGroup(String group) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocUserSpaceBinding.findUserAllBindingsByGroup", UserSpaceBindingEntity.class);
        query.setParameter("group", (Object)group);
        return query.getResultList();
    }

    @Override
    public List<UserSpaceBindingEntity> findUserAllBindingsByUser(String userName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocUserSpaceBinding.findUserAllBindingsByUser", UserSpaceBindingEntity.class);
        query.setParameter("userName", (Object)userName);
        return query.getResultList();
    }

    @Override
    public void deleteAllUserBindings(String userName) {
        Query query = this.getEntityManager().createNamedQuery("SocUserSpaceBinding.deleteAllUserBindings");
        query.setParameter("userName", (Object)userName);
        query.executeUpdate();
    }

    @Override
    public List<UserSpaceBindingEntity> findUserSpaceBindingsBySpace(Long spaceId, String userName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocUserSpaceBinding.findAllUserBindingsByUserAndSpace", UserSpaceBindingEntity.class);
        query.setParameter("spaceId", (Object)spaceId);
        query.setParameter("userName", (Object)userName);
        return query.getResultList();
    }

    @Override
    public long countUserBindings(Long spaceId, String userName) {
        return (Long)this.getEntityManager().createNamedQuery("SocUserSpaceBinding.countAllUserBindingsByUserAndSpace").setParameter("userName", (Object)userName).setParameter("spaceId", (Object)spaceId).getSingleResult();
    }

    @Override
    public List<UserSpaceBindingEntity> findBoundUsersByBindingId(long bindingId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocUserSpaceBinding.findBoundUsersByBindingId", UserSpaceBindingEntity.class);
        query.setParameter("bindingId", (Object)bindingId);
        return query.getResultList();
    }

    @Override
    public UserSpaceBindingEntity findUserBindingByGroupBindingIdAndUsername(long groupBindingId, String username) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocUserSpaceBinding.findUserBindingByGroupBindingIdAndUsername", UserSpaceBindingEntity.class);
        query.setParameter("username", (Object)username);
        query.setParameter("groupBindingId", (Object)groupBindingId);
        List listResult = query.getResultList();
        if (listResult.size() > 0) {
            return (UserSpaceBindingEntity)listResult.get(0);
        }
        return null;
    }

    @Override
    public boolean isUserBoundAndMemberBefore(Long spaceId, String userName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocUserSpaceBinding.isUserBoundAndMemberBefore", UserSpaceBindingEntity.class);
        query.setParameter("spaceId", (Object)spaceId);
        query.setParameter("userName", (Object)userName);
        query.setMaxResults(1);
        return query.getResultList().size() > 0;
    }

    @Override
    public long countBoundUsers(Long spaceId) {
        return (Long)this.getEntityManager().createNamedQuery("SocUserSpaceBinding.countAllDistinctUserBindingsBySpace").setParameter("spaceId", (Object)spaceId).getSingleResult();
    }
}

