/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.storage.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.commons.file.storage.entity.NameSpaceEntity;

@Entity(name="FileInfoEntity")
@ExoEntity
@Table(name="FILES_FILES")
@NamedQueries(value={@NamedQuery(name="fileEntity.findByChecksum", query="SELECT t FROM FileInfoEntity t WHERE t.checksum = :checksum"), @NamedQuery(name="fileEntity.findDeletedFiles", query="SELECT t FROM FileInfoEntity t WHERE t.deleted = true and t.updatedDate < :updatedDate"), @NamedQuery(name="fileEntity.getAllByLimitOffset", query="SELECT t FROM FileInfoEntity t")})
public class FileInfoEntity {
    @Id
    @Column(name="FILE_ID")
    @SequenceGenerator(name="SEQ_FILES_FILES_FILE_ID", sequenceName="SEQ_FILES_FILES_FILE_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_FILES_FILES_FILE_ID")
    private Long id;
    @Column(name="NAME")
    private String name;
    @Column(name="MIMETYPE")
    private String mimetype;
    @Column(name="FILE_SIZE")
    private long size;
    @Column(name="UPDATED_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date updatedDate;
    @Column(name="UPDATER")
    private String updater;
    @Column(name="CHECKSUM")
    private String checksum;
    @Column(name="DELETED")
    private boolean deleted;
    @ManyToOne
    @JoinColumn(name="NAMESPACE_ID")
    private NameSpaceEntity nameSpaceEntity;

    public FileInfoEntity() {
    }

    public FileInfoEntity(String name, String mimetype, long size, Date updatedDate, String updater, String checksum, boolean deleted) {
        this.name = name;
        this.mimetype = mimetype;
        this.size = size;
        this.updatedDate = updatedDate;
        this.updater = updater;
        this.checksum = checksum;
        this.deleted = deleted;
    }

    public FileInfoEntity(long id, String name, String mimetype, long size, Date updatedDate, String updater, String checksum, boolean deleted) {
        this(name, mimetype, size, updatedDate, updater, checksum, deleted);
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    public String getUpdater() {
        return this.updater;
    }

    public void setUpdater(String updater) {
        this.updater = updater;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public NameSpaceEntity getNameSpaceEntity() {
        return this.nameSpaceEntity;
    }

    public FileInfoEntity setNameSpaceEntity(NameSpaceEntity nameSpaceEntity) {
        this.nameSpaceEntity = nameSpaceEntity;
        return this;
    }
}

