/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.ClassificationInferenceOptions;
import co.elastic.clients.elasticsearch.ml.FillMaskInferenceUpdateOptions;
import co.elastic.clients.elasticsearch.ml.InferenceConfigUpdateVariant;
import co.elastic.clients.elasticsearch.ml.NerInferenceUpdateOptions;
import co.elastic.clients.elasticsearch.ml.PassThroughInferenceUpdateOptions;
import co.elastic.clients.elasticsearch.ml.QuestionAnsweringInferenceUpdateOptions;
import co.elastic.clients.elasticsearch.ml.RegressionInferenceOptions;
import co.elastic.clients.elasticsearch.ml.TextClassificationInferenceUpdateOptions;
import co.elastic.clients.elasticsearch.ml.TextEmbeddingInferenceUpdateOptions;
import co.elastic.clients.elasticsearch.ml.TextExpansionInferenceUpdateOptions;
import co.elastic.clients.elasticsearch.ml.ZeroShotClassificationInferenceUpdateOptions;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class InferenceConfigUpdate
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<InferenceConfigUpdate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceConfigUpdate::setupInferenceConfigUpdateDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public InferenceConfigUpdate(InferenceConfigUpdateVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._inferenceConfigUpdateKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private InferenceConfigUpdate(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static InferenceConfigUpdate of(Function<Builder, ObjectBuilder<InferenceConfigUpdate>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isRegression() {
        return this._kind == Kind.Regression;
    }

    public RegressionInferenceOptions regression() {
        return (RegressionInferenceOptions)TaggedUnionUtils.get(this, Kind.Regression);
    }

    public boolean isClassification() {
        return this._kind == Kind.Classification;
    }

    public ClassificationInferenceOptions classification() {
        return (ClassificationInferenceOptions)TaggedUnionUtils.get(this, Kind.Classification);
    }

    public boolean isTextClassification() {
        return this._kind == Kind.TextClassification;
    }

    public TextClassificationInferenceUpdateOptions textClassification() {
        return (TextClassificationInferenceUpdateOptions)TaggedUnionUtils.get(this, Kind.TextClassification);
    }

    public boolean isZeroShotClassification() {
        return this._kind == Kind.ZeroShotClassification;
    }

    public ZeroShotClassificationInferenceUpdateOptions zeroShotClassification() {
        return (ZeroShotClassificationInferenceUpdateOptions)TaggedUnionUtils.get(this, Kind.ZeroShotClassification);
    }

    public boolean isFillMask() {
        return this._kind == Kind.FillMask;
    }

    public FillMaskInferenceUpdateOptions fillMask() {
        return (FillMaskInferenceUpdateOptions)TaggedUnionUtils.get(this, Kind.FillMask);
    }

    public boolean isNer() {
        return this._kind == Kind.Ner;
    }

    public NerInferenceUpdateOptions ner() {
        return (NerInferenceUpdateOptions)TaggedUnionUtils.get(this, Kind.Ner);
    }

    public boolean isPassThrough() {
        return this._kind == Kind.PassThrough;
    }

    public PassThroughInferenceUpdateOptions passThrough() {
        return (PassThroughInferenceUpdateOptions)TaggedUnionUtils.get(this, Kind.PassThrough);
    }

    public boolean isTextEmbedding() {
        return this._kind == Kind.TextEmbedding;
    }

    public TextEmbeddingInferenceUpdateOptions textEmbedding() {
        return (TextEmbeddingInferenceUpdateOptions)TaggedUnionUtils.get(this, Kind.TextEmbedding);
    }

    public boolean isTextExpansion() {
        return this._kind == Kind.TextExpansion;
    }

    public TextExpansionInferenceUpdateOptions textExpansion() {
        return (TextExpansionInferenceUpdateOptions)TaggedUnionUtils.get(this, Kind.TextExpansion);
    }

    public boolean isQuestionAnswering() {
        return this._kind == Kind.QuestionAnswering;
    }

    public QuestionAnsweringInferenceUpdateOptions questionAnswering() {
        return (QuestionAnsweringInferenceUpdateOptions)TaggedUnionUtils.get(this, Kind.QuestionAnswering);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInferenceConfigUpdateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::regression, RegressionInferenceOptions._DESERIALIZER, "regression");
        op.add(Builder::classification, ClassificationInferenceOptions._DESERIALIZER, "classification");
        op.add(Builder::textClassification, TextClassificationInferenceUpdateOptions._DESERIALIZER, "text_classification");
        op.add(Builder::zeroShotClassification, ZeroShotClassificationInferenceUpdateOptions._DESERIALIZER, "zero_shot_classification");
        op.add(Builder::fillMask, FillMaskInferenceUpdateOptions._DESERIALIZER, "fill_mask");
        op.add(Builder::ner, NerInferenceUpdateOptions._DESERIALIZER, "ner");
        op.add(Builder::passThrough, PassThroughInferenceUpdateOptions._DESERIALIZER, "pass_through");
        op.add(Builder::textEmbedding, TextEmbeddingInferenceUpdateOptions._DESERIALIZER, "text_embedding");
        op.add(Builder::textExpansion, TextExpansionInferenceUpdateOptions._DESERIALIZER, "text_expansion");
        op.add(Builder::questionAnswering, QuestionAnsweringInferenceUpdateOptions._DESERIALIZER, "question_answering");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InferenceConfigUpdate> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<InferenceConfigUpdate> regression(RegressionInferenceOptions v) {
            this._kind = Kind.Regression;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigUpdate> regression(Function<RegressionInferenceOptions.Builder, ObjectBuilder<RegressionInferenceOptions>> fn) {
            return this.regression(fn.apply(new RegressionInferenceOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigUpdate> classification(ClassificationInferenceOptions v) {
            this._kind = Kind.Classification;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigUpdate> classification(Function<ClassificationInferenceOptions.Builder, ObjectBuilder<ClassificationInferenceOptions>> fn) {
            return this.classification(fn.apply(new ClassificationInferenceOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigUpdate> textClassification(TextClassificationInferenceUpdateOptions v) {
            this._kind = Kind.TextClassification;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigUpdate> textClassification(Function<TextClassificationInferenceUpdateOptions.Builder, ObjectBuilder<TextClassificationInferenceUpdateOptions>> fn) {
            return this.textClassification(fn.apply(new TextClassificationInferenceUpdateOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigUpdate> zeroShotClassification(ZeroShotClassificationInferenceUpdateOptions v) {
            this._kind = Kind.ZeroShotClassification;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigUpdate> zeroShotClassification(Function<ZeroShotClassificationInferenceUpdateOptions.Builder, ObjectBuilder<ZeroShotClassificationInferenceUpdateOptions>> fn) {
            return this.zeroShotClassification(fn.apply(new ZeroShotClassificationInferenceUpdateOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigUpdate> fillMask(FillMaskInferenceUpdateOptions v) {
            this._kind = Kind.FillMask;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigUpdate> fillMask(Function<FillMaskInferenceUpdateOptions.Builder, ObjectBuilder<FillMaskInferenceUpdateOptions>> fn) {
            return this.fillMask(fn.apply(new FillMaskInferenceUpdateOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigUpdate> ner(NerInferenceUpdateOptions v) {
            this._kind = Kind.Ner;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigUpdate> ner(Function<NerInferenceUpdateOptions.Builder, ObjectBuilder<NerInferenceUpdateOptions>> fn) {
            return this.ner(fn.apply(new NerInferenceUpdateOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigUpdate> passThrough(PassThroughInferenceUpdateOptions v) {
            this._kind = Kind.PassThrough;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigUpdate> passThrough(Function<PassThroughInferenceUpdateOptions.Builder, ObjectBuilder<PassThroughInferenceUpdateOptions>> fn) {
            return this.passThrough(fn.apply(new PassThroughInferenceUpdateOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigUpdate> textEmbedding(TextEmbeddingInferenceUpdateOptions v) {
            this._kind = Kind.TextEmbedding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigUpdate> textEmbedding(Function<TextEmbeddingInferenceUpdateOptions.Builder, ObjectBuilder<TextEmbeddingInferenceUpdateOptions>> fn) {
            return this.textEmbedding(fn.apply(new TextEmbeddingInferenceUpdateOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigUpdate> textExpansion(TextExpansionInferenceUpdateOptions v) {
            this._kind = Kind.TextExpansion;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigUpdate> textExpansion(Function<TextExpansionInferenceUpdateOptions.Builder, ObjectBuilder<TextExpansionInferenceUpdateOptions>> fn) {
            return this.textExpansion(fn.apply(new TextExpansionInferenceUpdateOptions.Builder()).build());
        }

        public ObjectBuilder<InferenceConfigUpdate> questionAnswering(QuestionAnsweringInferenceUpdateOptions v) {
            this._kind = Kind.QuestionAnswering;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfigUpdate> questionAnswering(Function<QuestionAnsweringInferenceUpdateOptions.Builder, ObjectBuilder<QuestionAnsweringInferenceUpdateOptions>> fn) {
            return this.questionAnswering(fn.apply(new QuestionAnsweringInferenceUpdateOptions.Builder()).build());
        }

        @Override
        public InferenceConfigUpdate build() {
            this._checkSingleUse();
            return new InferenceConfigUpdate(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Regression("regression"),
        Classification("classification"),
        TextClassification("text_classification"),
        ZeroShotClassification("zero_shot_classification"),
        FillMask("fill_mask"),
        Ner("ner"),
        PassThrough("pass_through"),
        TextEmbedding("text_embedding"),
        TextExpansion("text_expansion"),
        QuestionAnswering("question_answering");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

