/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.rest;

import io.meeds.news.filter.NewsFilter;
import io.meeds.news.model.News;
import io.meeds.news.rest.NewsEntity;
import io.meeds.news.rest.NewsSearchResultEntity;
import io.meeds.news.search.NewsESSearchResult;
import io.meeds.news.service.NewsService;
import io.meeds.news.utils.EntityBuilder;
import io.meeds.news.utils.NewsUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.application.localization.LocalizationFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.utils.MentionUtils;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagFilter;
import org.exoplatform.social.rest.api.RestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"contents"})
@Tag(name="content/rest/contents", description="Managing contents")
public class NewsRest {
    private static final Log LOG = ExoLogger.getLogger(NewsRest.class);
    @Autowired
    private NewsService newsService;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private PortalContainer container;
    @Autowired
    private FavoriteService favoriteService;
    private Map<String, String> newsToDeleteQueue = new HashMap<String, String>();
    private ScheduledExecutorService scheduledExecutor;
    private static final int CACHE_DURATION_SECONDS = 31536000;

    @PostConstruct
    public void init() {
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
    }

    @PreDestroy
    public void destroy() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
    }

    @PostMapping(consumes={"application/json"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Create a news", method="POST", description="This creates the news if the authenticated user is a member of the space or a spaces super manager. The news is created in draft status, unless the publicationState property is set to 'posted'.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="News created"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="User not authorized to create the news"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<News> createNews(@RequestBody News news) {
        if (news == null || StringUtils.isEmpty((CharSequence)news.getSpaceId())) {
            return ResponseEntity.badRequest().build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            News createdNews = this.newsService.createNews(news, currentIdentity);
            return ResponseEntity.ok((Object)createdNews);
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not authorized to create news", new Object[]{currentIdentity.getUserId(), e});
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when creating the news " + news.getTitle()), (Throwable)e);
            return ResponseEntity.badRequest().build();
        }
    }

    @GetMapping(path={"canCreateNews/{spaceId}"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="check if the current user can create a news in the given space", method="GET", description="This checks if the current user can create a news in the given space")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User ability to create a news is returned"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="User not authorized to create a news"), @ApiResponse(responseCode="404", description="Space not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<Boolean> canCreateNews(@PathVariable(value="spaceId") String spaceId) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            if (StringUtils.isBlank((CharSequence)spaceId)) {
                return ResponseEntity.badRequest().build();
            }
            Space space = this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                return ResponseEntity.notFound().build();
            }
            return ResponseEntity.ok((Object)this.newsService.canCreateNews(space, currentIdentity));
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not autorized to check if we can create news", new Object[]{currentIdentity.getUserId(), e});
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when checking if the authenticated user can create a news", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    @PutMapping(path={"{id}"}, consumes={"application/json"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Create a news", method="PUT", description="This updates the news if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="News updated"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="User not authorized to update the news"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<News> updateNews(@PathVariable(value="id") String id, @Parameter(description="Post news") @RequestParam(name="post", required=false) boolean post, @Parameter(description="News object type to be updated") @RequestParam(value="type") String newsObjectType, @Parameter(description="News update action type to be done") @RequestParam(name="newsUpdateType", defaultValue="content", required=false) String newsUpdateType, @RequestBody News updatedNews) {
        if (updatedNews == null) {
            return ResponseEntity.badRequest().build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            News news = this.newsService.getNewsById(id, currentIdentity, false, newsObjectType);
            if (news == null) {
                return ResponseEntity.notFound().build();
            }
            news.setTitle(updatedNews.getTitle());
            news.setBody(updatedNews.getBody());
            news.setUploadId(updatedNews.getUploadId());
            news.setPublicationState(updatedNews.getPublicationState());
            news.setUpdaterFullName(updatedNews.getUpdaterFullName());
            news.setActivityPosted(updatedNews.isActivityPosted());
            news.setTargets(updatedNews.getTargets());
            news.setAudience(updatedNews.getAudience());
            news.setProperties(updatedNews.getProperties());
            news = this.newsService.updateNews(news, currentIdentity.getUserId(), post, updatedNews.isPublished(), newsObjectType, newsUpdateType);
            return ResponseEntity.ok((Object)news);
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not authorized to update news", new Object[]{currentIdentity.getUserId(), e});
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when updating the news " + id), (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    @DeleteMapping(path={"{id}"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Delete news", method="DELETE", description="This deletes the news")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="News deleted"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="User not authorized to delete the news"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteNews(@PathVariable(value="id") String id, @Parameter(description="news object to be deleted") @RequestParam(value="type") String newsObjectType, @Parameter(description="Time to effectively delete news") @RequestParam(name="delay", required=false) long delay) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            News news = this.newsService.getNewsById(id, currentIdentity, false, newsObjectType);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (delay > 0L) {
                this.newsToDeleteQueue.put(id, currentIdentity.getUserId());
                this.scheduledExecutor.schedule(() -> {
                    if (this.newsToDeleteQueue.containsKey(id)) {
                        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
                        RequestLifeCycle.begin((ExoContainer)this.container);
                        try {
                            this.newsToDeleteQueue.remove(id);
                            this.newsService.deleteNews(id, currentIdentity, newsObjectType);
                        }
                        catch (IllegalAccessException e) {
                            LOG.error("User '{}' attempts to delete a non authorized news", new Object[]{currentIdentity.getUserId(), e});
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Error when deleting the news with id " + id), (Throwable)e);
                        }
                        finally {
                            RequestLifeCycle.end();
                        }
                    }
                }, delay, TimeUnit.SECONDS);
            } else {
                this.newsToDeleteQueue.remove(id);
                this.newsService.deleteNews(id, currentIdentity, newsObjectType);
            }
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not autorized to delete news", new Object[]{currentIdentity.getUserId(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when deleting the news with id " + id), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PostMapping(value={"{id}/undoDelete"})
    @Secured(value={"users"})
    @Operation(summary="Undo deleting news if not yet effectively deleted", method="POST", description="Undo deleting news if not yet effectively deleted")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Forbidden operation"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response undoDeleteNews(@PathVariable(value="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"News identifier must not be null or empty").build();
        }
        if (this.newsToDeleteQueue.containsKey(id)) {
            String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
            String originalModifierUser = this.newsToDeleteQueue.get(id);
            if (!originalModifierUser.equals(authenticatedUser)) {
                LOG.warn("User {} attempts to cancel deletion of a news deleted by user {}", new Object[]{authenticatedUser, originalModifierUser});
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.newsToDeleteQueue.remove(id);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("News with id {} was already deleted or isn't planned to be deleted" + id)).build();
    }

    @GetMapping(path={"{id}"}, produces={"application/json"})
    @Operation(summary="Get a news", method="GET", description="This gets the news with the given id if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="News returned"), @ApiResponse(responseCode="401", description="User not authorized to get the news"), @ApiResponse(responseCode="404", description="News not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<News> getNewsById(@PathVariable(value="id") String id, @Parameter(description="fields") @RequestParam(name="fields", required=false) String fields, @Parameter(description="News object type to be fetched") @RequestParam(value="type") String newsObjectType, @Parameter(description="Is edit mode") @RequestParam(name="editMode", defaultValue="false", required=false) boolean editMode) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                return ResponseEntity.badRequest().build();
            }
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            News news = this.newsService.getNewsById(id, currentIdentity, editMode, newsObjectType);
            if (news == null || news.isDeleted()) {
                return ResponseEntity.notFound().build();
            }
            Locale userLocale = LocalizationFilter.getCurrentLocale();
            news.setBody(MentionUtils.substituteRoleWithLocale((String)news.getBody(), (Locale)userLocale));
            org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(currentIdentity.getUserId());
            if (userIdentity != null) {
                news.setFavorite(this.favoriteService.isFavorite(new Favorite("news", news.getId(), "", Long.parseLong(userIdentity.getId()))));
            }
            if (StringUtils.isNotEmpty((CharSequence)fields) && fields.equals("spaces")) {
                News filteredNews = new News();
                ArrayList<String> spacesList = new ArrayList<String>();
                String newsActivities = news.getActivities();
                for (String newsActivity : newsActivities.split(";")) {
                    String spaceId = newsActivity.split(":")[0];
                    spacesList.add(spaceId);
                }
                filteredNews.setSharedInSpacesList(spacesList);
                return ResponseEntity.ok((Object)filteredNews);
            }
            return ResponseEntity.ok((Object)news);
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} attempt to access unauthorized news with id {}", new Object[]{authenticatedUser, id});
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news " + id), (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    @PostMapping(path={"markAsRead/{id}"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="mark a news article as read", method="POST", description="This marks a news article as read by the user who accessed its details.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User not authorized to get the news"), @ApiResponse(responseCode="404", description="News not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response markNewsAsRead(@PathVariable(value="id") String id) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            News news = this.newsService.getNewsById(id, currentIdentity, false, NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase());
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            this.newsService.markAsRead(news, authenticatedUser);
            return Response.ok((Object)"ok").type("application/json").build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} has no access rights on news with id {}", new Object[]{authenticatedUser, id});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error("Error while marking news with id: {} as read", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GetMapping(produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Get news list", method="GET", description="This gets the list of news with the given search text, of the given author, in the given space or spaces, with the given publication state, with the given pinned state if the authenticated user is a member of the spaces or a super manager.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="News list returned"), @ApiResponse(responseCode="401", description="User not authorized to get the news list"), @ApiResponse(responseCode="404", description="News list not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<NewsEntity> getNews(@Parameter(description="News author") @RequestParam(value="author") String author, @Parameter(description="News spaces") @RequestParam(name="spaces", required=false) String spaces, @Parameter(description="News filter") @RequestParam(value="filter") String filter, @Parameter(description="search text") @RequestParam(name="text", required=false) String text, @Parameter(description="News pagination offset") @RequestParam(name="offset", defaultValue="0", required=false) int offset, @Parameter(description="News pagination limit") @RequestParam(name="limit", defaultValue="10") int limit, @Parameter(description="News total size") @RequestParam(name="returnSize", defaultValue="false", required=false) boolean returnSize, HttpServletRequest request) {
        try {
            List<News> news;
            String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
            if (StringUtils.isBlank((CharSequence)author) || !authenticatedUser.equals(author)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
            }
            NewsEntity newsEntity = new NewsEntity();
            ArrayList<String> spacesList = new ArrayList<String>();
            if (StringUtils.isNotEmpty((CharSequence)spaces)) {
                for (String spaceId : spaces.split(",")) {
                    Space space = this.spaceService.getSpaceById(spaceId);
                    if (space == null || !this.spaceService.isSuperManager(authenticatedUser) && !this.spaceService.isMember(space, authenticatedUser)) {
                        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
                    }
                    spacesList.add(spaceId);
                }
            }
            NewsFilter newsFilter = this.buildFilter(spacesList, filter, text, author, limit, offset);
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            if (StringUtils.isNotEmpty((CharSequence)text)) {
                String tagName;
                List tagNames;
                String lang = request.getLocale().getLanguage();
                newsFilter.setLang(lang);
                TagService tagService = (TagService)CommonsUtils.getService(TagService.class);
                long userIdentityId = RestUtils.getCurrentUserIdentityId();
                if (text.indexOf("#") == 0 && (tagNames = tagService.findTags(new TagFilter(tagName = text.replace("#", ""), 0L), userIdentityId)) != null && !tagNames.isEmpty()) {
                    newsFilter.setTagNames(tagNames.stream().map(e -> e.getName()).toList());
                }
                org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", currentIdentity.getUserId());
                news = this.newsService.searchNews(newsFilter, identity);
            } else {
                news = this.newsService.getNews(newsFilter, currentIdentity);
            }
            if (news != null) {
                Locale userLocale = LocalizationFilter.getCurrentLocale();
                news.stream().filter(Objects::nonNull).forEach(news1 -> news1.setBody(MentionUtils.substituteRoleWithLocale((String)news1.getBody(), (Locale)userLocale)));
            }
            newsEntity.setNews(news);
            newsEntity.setOffset(offset);
            newsEntity.setLimit(limit);
            if (returnSize) {
                newsEntity.setSize(this.newsService.getNewsCount(newsFilter));
            }
            return ResponseEntity.ok((Object)newsEntity);
        }
        catch (Exception e2) {
            LOG.error((Object)("Error when getting the news with params author=" + author + ", spaces=" + spaces), (Throwable)e2);
            return ResponseEntity.internalServerError().build();
        }
    }

    @GetMapping(path={"byTarget/{targetName}"}, produces={"application/json"})
    @Operation(summary="Get news list", method="GET", description="This gets the list of news by the given target.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="News list returned"), @ApiResponse(responseCode="401", description="User not authorized to get the news list"), @ApiResponse(responseCode="404", description="News list not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<NewsEntity> getNewsByTarget(@PathVariable(value="targetName") String targetName, @Parameter(description="News pagination offset") @RequestParam(name="offset", defaultValue="0", required=false) int offset, @Parameter(description="News pagination limit") @RequestParam(name="limit", defaultValue="10") int limit, @Parameter(description="News total size") @RequestParam(name="returnSize", required=false) boolean returnSize) {
        try {
            String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
            if (StringUtils.isBlank((CharSequence)targetName)) {
                return ResponseEntity.badRequest().build();
            }
            if (offset < 0) {
                ResponseEntity.badRequest().build();
            }
            if (limit < 0) {
                return ResponseEntity.badRequest().build();
            }
            NewsFilter newsFilter = this.buildFilter(null, "", "", authenticatedUser, limit, offset);
            NewsEntity newsEntity = new NewsEntity();
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            List<News> news = this.newsService.getNewsByTargetName(newsFilter, targetName, currentIdentity);
            Locale userLocale = LocalizationFilter.getCurrentLocale();
            news.forEach(news1 -> news1.setBody(MentionUtils.substituteRoleWithLocale((String)news1.getBody(), (Locale)userLocale)));
            newsEntity.setNews(news);
            newsEntity.setOffset(offset);
            newsEntity.setLimit(limit);
            if (returnSize) {
                newsEntity.setSize(news.size());
            }
            return ResponseEntity.ok((Object)newsEntity);
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news with target name=" + targetName), (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    @GetMapping(path={"byActivity/{activityId}"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Get a news identified by its activity or shared activity identifier", method="GET", description="This gets the news with the given id if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="News returned"), @ApiResponse(responseCode="401", description="User not authorized to get the news"), @ApiResponse(responseCode="404", description="News not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<News> getNewsByActivityId(@PathVariable(value="activityId") String activityId) {
        if (StringUtils.isBlank((CharSequence)activityId)) {
            return ResponseEntity.badRequest().build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            News news = this.newsService.getNewsByActivityId(activityId, currentIdentity);
            if (news == null) {
                return ResponseEntity.notFound().build();
            }
            Locale userLocale = LocalizationFilter.getCurrentLocale();
            news.setBody(MentionUtils.substituteRoleWithLocale((String)news.getBody(), (Locale)userLocale));
            org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(currentIdentity.getUserId());
            if (userIdentity != null) {
                news.setFavorite(this.favoriteService.isFavorite(new Favorite("news", news.getId(), "", Long.parseLong(userIdentity.getId()))));
            }
            return ResponseEntity.ok((Object)news);
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} attempt to access unauthorized news with id {}", new Object[]{currentIdentity.getUserId(), activityId});
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        catch (ObjectNotFoundException e) {
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news " + activityId), (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    @PatchMapping(path={"schedule"}, consumes={"application/json"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Schedule a news", method="POST", description="This schedules the news if the authenticated user is a member of the space or a spaces super manager. The news is created in staged status, after reaching a date of publication startPublishedDate, the publicationState property is set to 'posted'.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="News scheduled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="User not authorized to schedule the news"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<News> scheduleNews(@Parameter(description="News object type to be fetched") @RequestParam(value="type") String newsObjectType, @RequestBody News scheduledNews) {
        if (scheduledNews == null || StringUtils.isEmpty((CharSequence)scheduledNews.getId())) {
            return ResponseEntity.badRequest().build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            News news = this.newsService.getNewsById(scheduledNews.getId(), currentIdentity, false, newsObjectType);
            if (news == null) {
                return ResponseEntity.notFound().build();
            }
            news = this.newsService.scheduleNews(scheduledNews, currentIdentity, newsObjectType);
            return ResponseEntity.ok((Object)news);
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not autorized to schedule news", new Object[]{currentIdentity.getUserId(), e});
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when scheduling the news " + scheduledNews.getTitle()), (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    @GetMapping(path={"search"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Search the list of news available with query", method="GET", description="Search the list of news available with query")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<List<NewsSearchResultEntity>> search(@Parameter(description="Term to search") @RequestParam(name="query", required=false) String query, @Parameter(description="Properties to expand") @RequestParam(name="expand", required=false) String expand, @Parameter(description="Offset") @RequestParam(name="offset", defaultValue="0", required=false) int offset, @Parameter(description="Tag names used to search news") @RequestParam(name="tags", required=false) List<String> tagNames, @Parameter(description="Limit") @RequestParam(name="limit", defaultValue="10") int limit, @Parameter(description="Favorites") @RequestParam(name="favorites", defaultValue="false", required=false) boolean favorites) {
        if (StringUtils.isBlank((CharSequence)query) && !favorites && CollectionUtils.isEmpty(tagNames)) {
            return ResponseEntity.badRequest().build();
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        org.exoplatform.social.core.identity.model.Identity currentIdentity = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        if (offset < 0) {
            return ResponseEntity.badRequest().build();
        }
        if (limit < 0) {
            return ResponseEntity.badRequest().build();
        }
        NewsFilter filter = new NewsFilter();
        filter.setSearchText(query);
        filter.setFavorites(favorites);
        filter.setLimit(limit);
        filter.setOffset(offset);
        filter.setTagNames(tagNames);
        List<NewsESSearchResult> searchResults = this.newsService.search(currentIdentity, filter);
        List results = searchResults.stream().map(searchResult -> EntityBuilder.fromNewsSearchResult(this.favoriteService, searchResult, currentIdentity)).collect(Collectors.toList());
        return ResponseEntity.ok(results);
    }

    @GetMapping(path={"canScheduleNews/{spaceId}"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="check if the current user can schedule a news in the given space", method="GET", description="This checks if the current user can schedule a news in the given space")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User ability to schedule a news"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="User not authorized to schedule a news"), @ApiResponse(responseCode="404", description="Space not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<Boolean> canScheduleNews(@PathVariable(value="spaceId") String spaceId) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            if (StringUtils.isBlank((CharSequence)spaceId)) {
                return ResponseEntity.badRequest().build();
            }
            Space space = this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                return ResponseEntity.notFound().build();
            }
            return ResponseEntity.ok((Object)this.newsService.canScheduleNews(space, currentIdentity));
        }
        catch (Exception e) {
            LOG.error((Object)"Error when checking if the authenticated user can schedule a news", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    @GetMapping(path={"canPublishNews"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="check if the current user can publish a news to all users", method="GET", description="This checks if the current user can publish a news to all users")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User ability to publish a news is returned"), @ApiResponse(responseCode="401", description="User not authorized to publish a news")})
    public ResponseEntity<Boolean> canPublishNews(@RequestParam(name="spaceId", required=false) String spaceId) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            Space space;
            if (!StringUtils.isBlank((CharSequence)spaceId) && (space = this.spaceService.getSpaceById(spaceId)) == null) {
                return ResponseEntity.notFound().build();
            }
            return ResponseEntity.ok((Object)NewsUtils.canPublishNews(spaceId, currentIdentity));
        }
        catch (Exception e) {
            LOG.error((Object)"Error when checking if the authenticated user can publish a news to all users", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    private NewsFilter buildFilter(List<String> spaces, String filter, String text, String author, int limit, int offset) {
        NewsFilter newsFilter = new NewsFilter();
        newsFilter.setSpaces(spaces);
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            FilterType filterType = FilterType.valueOf(filter.toUpperCase());
            switch (filterType.ordinal()) {
                case 0: {
                    newsFilter.setPublishedNews(true);
                    break;
                }
                case 1: {
                    if (!StringUtils.isNotEmpty((CharSequence)author)) break;
                    newsFilter.setAuthor(author);
                    break;
                }
                case 2: {
                    if (StringUtils.isNotEmpty((CharSequence)author)) {
                        newsFilter.setAuthor(author);
                    }
                    newsFilter.setDraftNews(true);
                    break;
                }
                case 3: {
                    if (StringUtils.isNotEmpty((CharSequence)author)) {
                        newsFilter.setAuthor(author);
                    }
                    newsFilter.setScheduledNews(true);
                }
            }
            newsFilter.setOrder("UPDATED_DATE");
        }
        if (StringUtils.isNotEmpty((CharSequence)text) && text.indexOf("#") != 0) {
            newsFilter.setSearchText(text);
        }
        newsFilter.setLimit(limit);
        newsFilter.setOffset(offset);
        return newsFilter;
    }

    private static enum FilterType {
        PINNED,
        MYPOSTED,
        DRAFTS,
        SCHEDULED,
        ALL;

    }
}

