/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.DoubleSummaryStatistics;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.CacheAware;
import org.infinispan.stream.impl.intops.primitive.d.BoxedDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.DistinctDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.FilterDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.FlatMapDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.LimitDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToIntDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToLongDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToObjDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.PeekDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.SkipDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.SortedDoubleOperation;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.stream.impl.local.LocalIntCacheStream;
import org.infinispan.stream.impl.local.LocalLongCacheStream;

public class LocalDoubleCacheStream
extends AbstractLocalCacheStream<Double, DoubleStream>
implements DoubleStream {
    public LocalDoubleCacheStream(AbstractLocalCacheStream.StreamSupplier streamSupplier, boolean parallel, ComponentRegistry registry) {
        super(streamSupplier, parallel, registry);
    }

    LocalDoubleCacheStream(AbstractLocalCacheStream<?, ?> original) {
        super(original);
    }

    @Override
    public DoubleStream filter(DoublePredicate predicate) {
        this.registry.wireDependencies(predicate);
        this.intermediateOperations.add(new FilterDoubleOperation(predicate));
        return this;
    }

    @Override
    public DoubleStream map(DoubleUnaryOperator mapper) {
        this.registry.wireDependencies(mapper);
        this.intermediateOperations.add(new MapDoubleOperation(mapper));
        return this;
    }

    @Override
    public <U> Stream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        this.registry.wireDependencies(mapper);
        this.intermediateOperations.add(new MapToObjDoubleOperation<U>(mapper));
        return new LocalCacheStream(this);
    }

    @Override
    public IntStream mapToInt(DoubleToIntFunction mapper) {
        this.intermediateOperations.add(new MapToIntDoubleOperation(mapper));
        return new LocalIntCacheStream(this);
    }

    @Override
    public LongStream mapToLong(DoubleToLongFunction mapper) {
        this.intermediateOperations.add(new MapToLongDoubleOperation(mapper));
        return new LocalLongCacheStream(this);
    }

    @Override
    public DoubleStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        this.intermediateOperations.add(new FlatMapDoubleOperation(mapper));
        return this;
    }

    @Override
    public DoubleStream distinct() {
        this.intermediateOperations.add(DistinctDoubleOperation.getInstance());
        return this;
    }

    @Override
    public DoubleStream sorted() {
        this.intermediateOperations.add(SortedDoubleOperation.getInstance());
        return this;
    }

    @Override
    public DoubleStream peek(DoubleConsumer action) {
        this.intermediateOperations.add(new PeekDoubleOperation(action));
        return this;
    }

    @Override
    public DoubleStream limit(long maxSize) {
        this.intermediateOperations.add(new LimitDoubleOperation(maxSize));
        return this;
    }

    @Override
    public DoubleStream skip(long n) {
        this.intermediateOperations.add(new SkipDoubleOperation(n));
        return this;
    }

    @Override
    public void forEach(DoubleConsumer action) {
        this.injectCache(action);
        ((DoubleStream)this.createStream()).forEach(action);
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        this.injectCache(action);
        ((DoubleStream)this.createStream()).forEachOrdered(action);
    }

    private void injectCache(DoubleConsumer cacheAware) {
        if (cacheAware instanceof CacheAware) {
            ((CacheAware)((Object)cacheAware)).injectCache(this.registry.getComponent(Cache.class));
        }
    }

    @Override
    public double[] toArray() {
        return ((DoubleStream)this.createStream()).toArray();
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        return ((DoubleStream)this.createStream()).reduce(identity, op);
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        return ((DoubleStream)this.createStream()).reduce(op);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return ((DoubleStream)this.createStream()).collect(supplier, accumulator, combiner);
    }

    @Override
    public double sum() {
        return ((DoubleStream)this.createStream()).sum();
    }

    @Override
    public OptionalDouble min() {
        return ((DoubleStream)this.createStream()).min();
    }

    @Override
    public OptionalDouble max() {
        return ((DoubleStream)this.createStream()).max();
    }

    @Override
    public long count() {
        return ((DoubleStream)this.createStream()).count();
    }

    @Override
    public OptionalDouble average() {
        return ((DoubleStream)this.createStream()).average();
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        return ((DoubleStream)this.createStream()).summaryStatistics();
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        return ((DoubleStream)this.createStream()).anyMatch(predicate);
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        return ((DoubleStream)this.createStream()).allMatch(predicate);
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        return ((DoubleStream)this.createStream()).noneMatch(predicate);
    }

    @Override
    public OptionalDouble findFirst() {
        return ((DoubleStream)this.createStream()).findFirst();
    }

    @Override
    public OptionalDouble findAny() {
        return ((DoubleStream)this.createStream()).findAny();
    }

    @Override
    public Stream<Double> boxed() {
        this.intermediateOperations.add(BoxedDoubleOperation.getInstance());
        return new LocalCacheStream<Double>(this);
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        return ((DoubleStream)this.createStream()).iterator();
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        return ((DoubleStream)this.createStream()).spliterator();
    }
}

