/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.event;

import java.util.List;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.Ordered;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalApplicationListener;
import org.springframework.transaction.reactive.TransactionContext;
import org.springframework.transaction.reactive.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import reactor.core.publisher.Mono;

abstract class TransactionalApplicationListenerSynchronization<E extends ApplicationEvent>
implements Ordered {
    private final E event;
    private final TransactionalApplicationListener<E> listener;
    private final List<TransactionalApplicationListener.SynchronizationCallback> callbacks;

    public TransactionalApplicationListenerSynchronization(E event, TransactionalApplicationListener<E> listener, List<TransactionalApplicationListener.SynchronizationCallback> callbacks) {
        this.event = event;
        this.listener = listener;
        this.callbacks = callbacks;
    }

    public int getOrder() {
        return this.listener.getOrder();
    }

    public TransactionPhase getTransactionPhase() {
        return this.listener.getTransactionPhase();
    }

    public void processEventWithCallbacks() {
        this.callbacks.forEach(callback -> callback.preProcessEvent((ApplicationEvent)this.event));
        try {
            this.listener.processEvent(this.event);
        }
        catch (Error | RuntimeException ex) {
            this.callbacks.forEach(callback -> callback.postProcessEvent((ApplicationEvent)this.event, ex));
            throw ex;
        }
        this.callbacks.forEach(callback -> callback.postProcessEvent((ApplicationEvent)this.event, null));
    }

    public static <E extends ApplicationEvent> boolean register(E event, TransactionalApplicationListener<E> listener, List<TransactionalApplicationListener.SynchronizationCallback> callbacks) {
        TransactionContext txContext;
        org.springframework.transaction.reactive.TransactionSynchronizationManager rtsm;
        if (TransactionSynchronizationManager.isSynchronizationActive() && TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization(new PlatformSynchronization<E>(event, listener, callbacks));
            return true;
        }
        Object object = event.getSource();
        if (object instanceof TransactionContext && (rtsm = new org.springframework.transaction.reactive.TransactionSynchronizationManager(txContext = (TransactionContext)object)).isSynchronizationActive() && rtsm.isActualTransactionActive()) {
            rtsm.registerSynchronization(new ReactiveSynchronization<E>(event, listener, callbacks));
            return true;
        }
        return false;
    }

    private static class PlatformSynchronization<AE extends ApplicationEvent>
    extends TransactionalApplicationListenerSynchronization<AE>
    implements org.springframework.transaction.support.TransactionSynchronization {
        public PlatformSynchronization(AE event, TransactionalApplicationListener<AE> listener, List<TransactionalApplicationListener.SynchronizationCallback> callbacks) {
            super(event, listener, callbacks);
        }

        @Override
        public void beforeCommit(boolean readOnly) {
            if (this.getTransactionPhase() == TransactionPhase.BEFORE_COMMIT) {
                this.processEventWithCallbacks();
            }
        }

        @Override
        public void afterCompletion(int status) {
            TransactionPhase phase = this.getTransactionPhase();
            if (phase == TransactionPhase.AFTER_COMMIT && status == 0) {
                this.processEventWithCallbacks();
            } else if (phase == TransactionPhase.AFTER_ROLLBACK && status == 1) {
                this.processEventWithCallbacks();
            } else if (phase == TransactionPhase.AFTER_COMPLETION) {
                this.processEventWithCallbacks();
            }
        }
    }

    private static class ReactiveSynchronization<AE extends ApplicationEvent>
    extends TransactionalApplicationListenerSynchronization<AE>
    implements TransactionSynchronization {
        public ReactiveSynchronization(AE event, TransactionalApplicationListener<AE> listener, List<TransactionalApplicationListener.SynchronizationCallback> callbacks) {
            super(event, listener, callbacks);
        }

        @Override
        public Mono<Void> beforeCommit(boolean readOnly) {
            if (this.getTransactionPhase() == TransactionPhase.BEFORE_COMMIT) {
                return Mono.fromRunnable(this::processEventWithCallbacks);
            }
            return Mono.empty();
        }

        @Override
        public Mono<Void> afterCompletion(int status) {
            TransactionPhase phase = this.getTransactionPhase();
            if (phase == TransactionPhase.AFTER_COMMIT && status == 0) {
                return Mono.fromRunnable(this::processEventWithCallbacks);
            }
            if (phase == TransactionPhase.AFTER_ROLLBACK && status == 1) {
                return Mono.fromRunnable(this::processEventWithCallbacks);
            }
            if (phase == TransactionPhase.AFTER_COMPLETION) {
                return Mono.fromRunnable(this::processEventWithCallbacks);
            }
            return Mono.empty();
        }
    }
}

