/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class FrozenIndices
extends Base {
    private final long indicesCount;
    public static final JsonpDeserializer<FrozenIndices> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FrozenIndices::setupFrozenIndicesDeserializer);

    private FrozenIndices(Builder builder) {
        super(builder);
        this.indicesCount = ApiTypeHelper.requireNonNull(builder.indicesCount, this, "indicesCount");
    }

    public static FrozenIndices of(Function<Builder, ObjectBuilder<FrozenIndices>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long indicesCount() {
        return this.indicesCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("indices_count");
        generator.write(this.indicesCount);
    }

    protected static void setupFrozenIndicesDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::indicesCount, JsonpDeserializer.longDeserializer(), "indices_count");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<FrozenIndices> {
        private Long indicesCount;

        public final Builder indicesCount(long value) {
            this.indicesCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FrozenIndices build() {
            this._checkSingleUse();
            return new FrozenIndices(this);
        }
    }
}

