/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import java.util.Objects;
import org.springframework.aot.hint.ConditionalHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;

public class JavaSerializationHint
implements ConditionalHint {
    private final TypeReference type;
    @Nullable
    private final TypeReference reachableType;

    JavaSerializationHint(Builder builder) {
        this.type = builder.type;
        this.reachableType = builder.reachableType;
    }

    public TypeReference getType() {
        return this.type;
    }

    @Override
    @Nullable
    public TypeReference getReachableType() {
        return this.reachableType;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaSerializationHint that = (JavaSerializationHint)o;
        return this.type.equals(that.type) && Objects.equals(this.reachableType, that.reachableType);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.reachableType);
    }

    public static class Builder {
        private final TypeReference type;
        @Nullable
        private TypeReference reachableType;

        Builder(TypeReference type) {
            this.type = type;
        }

        public Builder onReachableType(TypeReference reachableType) {
            this.reachableType = reachableType;
            return this;
        }

        JavaSerializationHint build() {
            return new JavaSerializationHint(this);
        }
    }
}

