/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service.storage.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractWebNotifListData<K, V>
implements Serializable {
    private static final long serialVersionUID = -9014159315525998105L;
    private final LinkedList<V> list = new LinkedList();
    protected final K key;

    public AbstractWebNotifListData(K key, List<V> list) {
        this.list.addAll(list);
        this.key = key;
    }

    public AbstractWebNotifListData(K key) {
        this.key = key;
    }

    public List<V> getList() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }

    public List<V> subList(int from, int to) {
        if (from >= this.list.size()) {
            return Collections.emptyList();
        }
        if (to == -1) {
            return this.list;
        }
        int newTo = Math.min(to, this.list.size());
        return this.list.subList(from, newTo);
    }

    public void put(int index, V value, String ownerId) {
        this.beforePut();
        this.list.add(index, value);
        this.afterPut();
    }

    public void putAtTop(V value, String ownerId) {
        this.put(0, value, ownerId);
    }

    public void beforePut() {
    }

    public void afterPut() {
    }

    public void beforePutRef() {
    }

    public void afterPutRef() {
    }

    public void beforeMove(V value) {
        this.list.remove(value);
    }

    public void afterMove() {
    }

    public void beforeRemove() {
    }

    public void afterRemove() {
    }

    public void move(int index, V value, String ownerId) {
        this.beforeMove(value);
        this.list.add(index, value);
        this.afterMove();
    }

    public void moveTop(V value, String ownerId) {
        this.beforeMove(value);
        this.list.addFirst(value);
        this.afterMove();
    }

    public void remove(V value, String ownerId) {
        this.beforeRemove();
        this.list.remove(value);
        this.afterRemove();
    }

    public void insertLast(V value) {
        this.list.offerLast(value);
    }

    public boolean contains(V value) {
        return this.list.contains(value);
    }

    public void clear() {
        this.list.clear();
    }

    public boolean removeByValue(V value) {
        return this.list.remove(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractWebNotifListData)) {
            return false;
        }
        AbstractWebNotifListData that = (AbstractWebNotifListData)o;
        if (!this.list.equals(that.list)) {
            return false;
        }
        return this.key != null ? this.key.equals(that.key) : that.key == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.list != null ? this.list.hashCode() : 0);
        return result;
    }
}

