/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.crac.CheckpointException;
import org.crac.Context;
import org.crac.Core;
import org.crac.Resource;
import org.crac.RestoreException;
import org.crac.management.CRaCMXBean;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.Lifecycle;
import org.springframework.context.LifecycleProcessor;
import org.springframework.context.Phased;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.NativeDetector;
import org.springframework.core.SpringProperties;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultLifecycleProcessor
implements LifecycleProcessor,
BeanFactoryAware {
    public static final String CHECKPOINT_PROPERTY_NAME = "spring.context.checkpoint";
    public static final String EXIT_PROPERTY_NAME = "spring.context.exit";
    public static final String ON_REFRESH_VALUE = "onRefresh";
    private static boolean checkpointOnRefresh = "onRefresh".equalsIgnoreCase(SpringProperties.getProperty((String)"spring.context.checkpoint"));
    private static final boolean exitOnRefresh = "onRefresh".equalsIgnoreCase(SpringProperties.getProperty((String)"spring.context.exit"));
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile long timeoutPerShutdownPhase = 30000L;
    private volatile boolean running;
    @Nullable
    private volatile ConfigurableListableBeanFactory beanFactory;
    @Nullable
    private volatile Set<String> stoppedBeans;
    @Nullable
    private Object cracResource;

    public DefaultLifecycleProcessor() {
        if (!NativeDetector.inNativeImage() && ClassUtils.isPresent((String)"org.crac.Core", (ClassLoader)this.getClass().getClassLoader())) {
            this.cracResource = new CracDelegate().registerResource();
        } else if (checkpointOnRefresh) {
            throw new IllegalStateException("Checkpoint on refresh requires a CRaC-enabled JVM and 'org.crac:crac' on the classpath");
        }
    }

    public void setTimeoutPerShutdownPhase(long timeoutPerShutdownPhase) {
        this.timeoutPerShutdownPhase = timeoutPerShutdownPhase;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("DefaultLifecycleProcessor requires a ConfigurableListableBeanFactory: " + beanFactory);
        }
        ConfigurableListableBeanFactory clbf = (ConfigurableListableBeanFactory)beanFactory;
        this.beanFactory = clbf;
    }

    private ConfigurableListableBeanFactory getBeanFactory() {
        ConfigurableListableBeanFactory beanFactory = this.beanFactory;
        Assert.state((beanFactory != null ? 1 : 0) != 0, (String)"No BeanFactory available");
        return beanFactory;
    }

    @Override
    public void start() {
        this.stoppedBeans = null;
        this.startBeans(false);
        this.running = true;
    }

    @Override
    public void stop() {
        this.stopBeans();
        this.running = false;
    }

    @Override
    public void onRefresh() {
        if (checkpointOnRefresh) {
            checkpointOnRefresh = false;
            new CracDelegate().checkpointRestore();
        }
        if (exitOnRefresh) {
            Runtime.getRuntime().halt(0);
        }
        this.stoppedBeans = null;
        try {
            this.startBeans(true);
        }
        catch (ApplicationContextException ex) {
            this.stopBeans();
            throw ex;
        }
        this.running = true;
    }

    @Override
    public void onClose() {
        this.stopBeans();
        this.running = false;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    void stopForRestart() {
        if (this.running) {
            this.stoppedBeans = Collections.newSetFromMap(new ConcurrentHashMap());
            this.stopBeans();
            this.running = false;
        }
    }

    void restartAfterStop() {
        if (this.stoppedBeans != null) {
            this.startBeans(true);
            this.stoppedBeans = null;
            this.running = true;
        }
    }

    private void startBeans(boolean autoStartupOnly) {
        Map<String, Lifecycle> lifecycleBeans = this.getLifecycleBeans();
        TreeMap phases = new TreeMap();
        lifecycleBeans.forEach((beanName, bean2) -> {
            if (!autoStartupOnly || this.isAutoStartupCandidate((String)beanName, (Lifecycle)bean2)) {
                int startupPhase = this.getPhase((Lifecycle)bean2);
                phases.computeIfAbsent(startupPhase, phase -> new LifecycleGroup((int)phase, this.timeoutPerShutdownPhase, lifecycleBeans, autoStartupOnly)).add((String)beanName, (Lifecycle)bean2);
            }
        });
        if (!phases.isEmpty()) {
            phases.values().forEach(LifecycleGroup::start);
        }
    }

    private boolean isAutoStartupCandidate(String beanName, Lifecycle bean2) {
        SmartLifecycle smartLifecycle;
        Set<String> stoppedBeans = this.stoppedBeans;
        return stoppedBeans != null ? stoppedBeans.contains(beanName) : bean2 instanceof SmartLifecycle && (smartLifecycle = (SmartLifecycle)bean2).isAutoStartup();
    }

    private void doStart(Map<String, ? extends Lifecycle> lifecycleBeans, String beanName, boolean autoStartupOnly) {
        Lifecycle bean2 = lifecycleBeans.remove(beanName);
        if (bean2 != null && bean2 != this) {
            String[] dependenciesForBean;
            for (String dependency : dependenciesForBean = this.getBeanFactory().getDependenciesForBean(beanName)) {
                this.doStart(lifecycleBeans, dependency, autoStartupOnly);
            }
            if (!(bean2.isRunning() || autoStartupOnly && !this.toBeStarted(beanName, bean2))) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Starting bean '" + beanName + "' of type [" + bean2.getClass().getName() + "]"));
                }
                try {
                    bean2.start();
                }
                catch (Throwable ex) {
                    throw new ApplicationContextException("Failed to start bean '" + beanName + "'", ex);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Successfully started bean '" + beanName + "'"));
                }
            }
        }
    }

    private boolean toBeStarted(String beanName, Lifecycle bean2) {
        SmartLifecycle smartLifecycle;
        Set<String> stoppedBeans = this.stoppedBeans;
        return stoppedBeans != null ? stoppedBeans.contains(beanName) : !(bean2 instanceof SmartLifecycle) || (smartLifecycle = (SmartLifecycle)bean2).isAutoStartup();
    }

    private void stopBeans() {
        Map<String, Lifecycle> lifecycleBeans = this.getLifecycleBeans();
        TreeMap phases = new TreeMap(Comparator.reverseOrder());
        lifecycleBeans.forEach((beanName, bean2) -> {
            int shutdownPhase = this.getPhase((Lifecycle)bean2);
            phases.computeIfAbsent(shutdownPhase, phase -> new LifecycleGroup((int)phase, this.timeoutPerShutdownPhase, lifecycleBeans, false)).add((String)beanName, (Lifecycle)bean2);
        });
        if (!phases.isEmpty()) {
            phases.values().forEach(LifecycleGroup::stop);
        }
    }

    private void doStop(Map<String, ? extends Lifecycle> lifecycleBeans, String beanName, CountDownLatch latch, Set<String> countDownBeanNames) {
        block13: {
            Lifecycle bean2 = lifecycleBeans.remove(beanName);
            if (bean2 != null) {
                String[] dependentBeans;
                for (String dependentBean : dependentBeans = this.getBeanFactory().getDependentBeans(beanName)) {
                    this.doStop(lifecycleBeans, dependentBean, latch, countDownBeanNames);
                }
                try {
                    if (bean2.isRunning()) {
                        Set<String> stoppedBeans = this.stoppedBeans;
                        if (stoppedBeans != null) {
                            stoppedBeans.add(beanName);
                        }
                        if (bean2 instanceof SmartLifecycle) {
                            SmartLifecycle smartLifecycle = (SmartLifecycle)bean2;
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace((Object)("Asking bean '" + beanName + "' of type [" + bean2.getClass().getName() + "] to stop"));
                            }
                            countDownBeanNames.add(beanName);
                            smartLifecycle.stop(() -> {
                                latch.countDown();
                                countDownBeanNames.remove(beanName);
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug((Object)("Bean '" + beanName + "' completed its stop procedure"));
                                }
                            });
                        } else {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace((Object)("Stopping bean '" + beanName + "' of type [" + bean2.getClass().getName() + "]"));
                            }
                            bean2.stop();
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Successfully stopped bean '" + beanName + "'"));
                            }
                        }
                    } else if (bean2 instanceof SmartLifecycle) {
                        latch.countDown();
                    }
                }
                catch (Throwable ex) {
                    if (!this.logger.isWarnEnabled()) break block13;
                    this.logger.warn((Object)("Failed to stop bean '" + beanName + "'"), ex);
                }
            }
        }
    }

    protected Map<String, Lifecycle> getLifecycleBeans() {
        String[] beanNames;
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        LinkedHashMap<String, Lifecycle> beans2 = new LinkedHashMap<String, Lifecycle>();
        for (String beanName : beanNames = beanFactory.getBeanNamesForType(Lifecycle.class, false, false)) {
            Object bean2;
            Object beanNameToCheck;
            String beanNameToRegister = BeanFactoryUtils.transformedBeanName((String)beanName);
            boolean isFactoryBean = beanFactory.isFactoryBean(beanNameToRegister);
            Object object = beanNameToCheck = isFactoryBean ? "&" + beanName : beanName;
            if ((!beanFactory.containsSingleton(beanNameToRegister) || isFactoryBean && !this.matchesBeanType(Lifecycle.class, (String)beanNameToCheck, (BeanFactory)beanFactory)) && !this.matchesBeanType(SmartLifecycle.class, (String)beanNameToCheck, (BeanFactory)beanFactory) || (bean2 = beanFactory.getBean((String)beanNameToCheck)) == this || !(bean2 instanceof Lifecycle)) continue;
            Lifecycle lifecycle = (Lifecycle)bean2;
            beans2.put(beanNameToRegister, lifecycle);
        }
        return beans2;
    }

    private boolean matchesBeanType(Class<?> targetType, String beanName, BeanFactory beanFactory) {
        Class beanType = beanFactory.getType(beanName);
        return beanType != null && targetType.isAssignableFrom(beanType);
    }

    protected int getPhase(Lifecycle bean2) {
        int n;
        if (bean2 instanceof Phased) {
            Phased phased = (Phased)((Object)bean2);
            n = phased.getPhase();
        } else {
            n = 0;
        }
        return n;
    }

    private class CracDelegate {
        private CracDelegate() {
        }

        public Object registerResource() {
            DefaultLifecycleProcessor.this.logger.debug((Object)"Registering JVM checkpoint/restore callback for Spring-managed lifecycle beans");
            CracResourceAdapter resourceAdapter = new CracResourceAdapter();
            Core.getGlobalContext().register((Resource)resourceAdapter);
            return resourceAdapter;
        }

        public void checkpointRestore() {
            DefaultLifecycleProcessor.this.logger.info((Object)"Triggering JVM checkpoint/restore");
            try {
                Core.checkpointRestore();
            }
            catch (UnsupportedOperationException ex) {
                throw new ApplicationContextException("CRaC checkpoint not supported on current JVM", ex);
            }
            catch (CheckpointException ex) {
                throw new ApplicationContextException("Failed to take CRaC checkpoint on refresh", ex);
            }
            catch (RestoreException ex) {
                throw new ApplicationContextException("Failed to restore CRaC checkpoint on refresh", ex);
            }
        }
    }

    private class LifecycleGroup {
        private final int phase;
        private final long timeout;
        private final Map<String, ? extends Lifecycle> lifecycleBeans;
        private final boolean autoStartupOnly;
        private final List<LifecycleGroupMember> members = new ArrayList<LifecycleGroupMember>();
        private int smartMemberCount;

        public LifecycleGroup(int phase, long timeout, Map<String, ? extends Lifecycle> lifecycleBeans, boolean autoStartupOnly) {
            this.phase = phase;
            this.timeout = timeout;
            this.lifecycleBeans = lifecycleBeans;
            this.autoStartupOnly = autoStartupOnly;
        }

        public void add(String name, Lifecycle bean2) {
            this.members.add(new LifecycleGroupMember(name, bean2));
            if (bean2 instanceof SmartLifecycle) {
                ++this.smartMemberCount;
            }
        }

        public void start() {
            if (this.members.isEmpty()) {
                return;
            }
            if (DefaultLifecycleProcessor.this.logger.isDebugEnabled()) {
                DefaultLifecycleProcessor.this.logger.debug((Object)("Starting beans in phase " + this.phase));
            }
            for (LifecycleGroupMember member : this.members) {
                DefaultLifecycleProcessor.this.doStart(this.lifecycleBeans, member.name, this.autoStartupOnly);
            }
        }

        public void stop() {
            if (this.members.isEmpty()) {
                return;
            }
            if (DefaultLifecycleProcessor.this.logger.isDebugEnabled()) {
                DefaultLifecycleProcessor.this.logger.debug((Object)("Stopping beans in phase " + this.phase));
            }
            CountDownLatch latch = new CountDownLatch(this.smartMemberCount);
            Set<String> countDownBeanNames = Collections.synchronizedSet(new LinkedHashSet());
            HashSet<String> lifecycleBeanNames = new HashSet<String>(this.lifecycleBeans.keySet());
            for (LifecycleGroupMember member : this.members) {
                if (lifecycleBeanNames.contains(member.name)) {
                    DefaultLifecycleProcessor.this.doStop(this.lifecycleBeans, member.name, latch, countDownBeanNames);
                    continue;
                }
                if (!(member.bean instanceof SmartLifecycle)) continue;
                latch.countDown();
            }
            try {
                latch.await(this.timeout, TimeUnit.MILLISECONDS);
                if (latch.getCount() > 0L && !countDownBeanNames.isEmpty() && DefaultLifecycleProcessor.this.logger.isInfoEnabled()) {
                    DefaultLifecycleProcessor.this.logger.info((Object)("Shutdown phase " + this.phase + " ends with " + countDownBeanNames.size() + " bean" + (countDownBeanNames.size() > 1 ? "s" : "") + " still running after timeout of " + this.timeout + "ms: " + countDownBeanNames));
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class CracResourceAdapter
    implements Resource {
        @Nullable
        private CyclicBarrier barrier;

        private CracResourceAdapter() {
        }

        public void beforeCheckpoint(Context<? extends Resource> context) {
            this.barrier = new CyclicBarrier(2);
            Thread thread = new Thread(() -> {
                this.awaitPreventShutdownBarrier();
                this.awaitPreventShutdownBarrier();
            }, "prevent-shutdown");
            thread.setDaemon(false);
            thread.start();
            this.awaitPreventShutdownBarrier();
            DefaultLifecycleProcessor.this.logger.debug((Object)"Stopping Spring-managed lifecycle beans before JVM checkpoint");
            DefaultLifecycleProcessor.this.stopForRestart();
        }

        public void afterRestore(Context<? extends Resource> context) {
            DefaultLifecycleProcessor.this.logger.info((Object)"Restarting Spring-managed lifecycle beans after JVM restore");
            DefaultLifecycleProcessor.this.restartAfterStop();
            this.barrier = null;
            if (!checkpointOnRefresh) {
                DefaultLifecycleProcessor.this.logger.info((Object)("Spring-managed lifecycle restart completed (restored JVM running for " + CRaCMXBean.getCRaCMXBean().getUptimeSinceRestore() + " ms)"));
            }
        }

        private void awaitPreventShutdownBarrier() {
            try {
                if (this.barrier != null) {
                    this.barrier.await();
                }
            }
            catch (Exception ex) {
                DefaultLifecycleProcessor.this.logger.trace((Object)"Exception from prevent-shutdown barrier", (Throwable)ex);
            }
        }
    }

    private record LifecycleGroupMember(String name, Lifecycle bean) {
    }
}

