/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ClusterSearchStatus;
import co.elastic.clients.elasticsearch._types.ShardFailure;
import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClusterDetails
implements JsonpSerializable {
    private final ClusterSearchStatus status;
    private final String indices;
    @Nullable
    private final Long took;
    private final boolean timedOut;
    @Nullable
    private final ShardStatistics shards;
    private final List<ShardFailure> failures;
    public static final JsonpDeserializer<ClusterDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterDetails::setupClusterDetailsDeserializer);

    private ClusterDetails(Builder builder) {
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.indices = ApiTypeHelper.requireNonNull(builder.indices, this, "indices");
        this.took = builder.took;
        this.timedOut = ApiTypeHelper.requireNonNull(builder.timedOut, this, "timedOut");
        this.shards = builder.shards;
        this.failures = ApiTypeHelper.unmodifiable(builder.failures);
    }

    public static ClusterDetails of(Function<Builder, ObjectBuilder<ClusterDetails>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ClusterSearchStatus status() {
        return this.status;
    }

    public final String indices() {
        return this.indices;
    }

    @Nullable
    public final Long took() {
        return this.took;
    }

    public final boolean timedOut() {
        return this.timedOut;
    }

    @Nullable
    public final ShardStatistics shards() {
        return this.shards;
    }

    public final List<ShardFailure> failures() {
        return this.failures;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("indices");
        generator.write(this.indices);
        if (this.took != null) {
            generator.writeKey("took");
            generator.write(this.took.longValue());
        }
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        if (this.shards != null) {
            generator.writeKey("_shards");
            this.shards.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.failures)) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (ShardFailure item0 : this.failures) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupClusterDetailsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::status, ClusterSearchStatus._DESERIALIZER, "status");
        op.add(Builder::indices, JsonpDeserializer.stringDeserializer(), "indices");
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(ShardFailure._DESERIALIZER), "failures");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterDetails> {
        private ClusterSearchStatus status;
        private String indices;
        @Nullable
        private Long took;
        private Boolean timedOut;
        @Nullable
        private ShardStatistics shards;
        @Nullable
        private List<ShardFailure> failures;

        public final Builder status(ClusterSearchStatus value) {
            this.status = value;
            return this;
        }

        public final Builder indices(String value) {
            this.indices = value;
            return this;
        }

        public final Builder took(@Nullable Long value) {
            this.took = value;
            return this;
        }

        public final Builder timedOut(boolean value) {
            this.timedOut = value;
            return this;
        }

        public final Builder shards(@Nullable ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final Builder failures(List<ShardFailure> list) {
            this.failures = Builder._listAddAll(this.failures, list);
            return this;
        }

        public final Builder failures(ShardFailure value, ShardFailure ... values) {
            this.failures = Builder._listAdd(this.failures, value, values);
            return this;
        }

        public final Builder failures(Function<ShardFailure.Builder, ObjectBuilder<ShardFailure>> fn) {
            return this.failures(fn.apply(new ShardFailure.Builder()).build(), new ShardFailure[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterDetails build() {
            this._checkSingleUse();
            return new ClusterDetails(this);
        }
    }
}

