/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LayoutAclService {
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private UserACL userAcl;

    public boolean canAddSite(String username) {
        return this.userAcl.hasCreatePortalPermission(this.userAcl.getUserIdentity(username));
    }

    public boolean canEditSite(SiteKey siteKey, String username) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            return false;
        }
        return this.userAcl.hasEditPermission(portalConfig, this.userAcl.getUserIdentity(username));
    }

    public boolean canViewSite(SiteKey siteKey, String username) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            return false;
        }
        return this.userAcl.hasAccessPermission(portalConfig, this.userAcl.getUserIdentity(username));
    }

    public boolean canEditNavigation(SiteKey siteKey, String username) {
        return this.canEditSite(siteKey, username);
    }

    public boolean canViewNavigation(SiteKey siteKey, PageKey pageKey, String username) {
        return this.canViewSite(siteKey, username) && (pageKey == null || this.canViewPage(pageKey, username));
    }

    public boolean canViewPage(PageKey pageKey, String username) {
        Page page = this.layoutService.getPage(pageKey);
        if (page == null) {
            return false;
        }
        return this.userAcl.hasAccessPermission(page, this.userAcl.getUserIdentity(username));
    }

    public boolean canEditPage(PageKey pageKey, String username) {
        Page page = this.layoutService.getPage(pageKey);
        if (page == null) {
            return false;
        }
        return this.userAcl.hasEditPermission(page, this.userAcl.getUserIdentity(username));
    }

    public boolean isAdministrator(String username) {
        return this.userAcl.isAdministrator(this.userAcl.getUserIdentity(username));
    }

    public boolean hasPermission(String username, String expression) {
        return this.userAcl.hasPermission(this.userAcl.getUserIdentity(username), expression);
    }

    public String getAdministratorsGroup() {
        return this.userAcl.getAdminGroups();
    }

    public ConversationState getSuperUserConversationState() {
        return new ConversationState(this.userAcl.getUserIdentity(this.userAcl.getSuperUser()));
    }

    public long getSuperUserIdentityId() {
        Identity userIdentity = this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser());
        return userIdentity == null ? 0L : Long.parseLong(userIdentity.getId());
    }
}

