/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.data;

import org.exoplatform.portal.pom.data.ModelData;

public abstract class ModelChange {

    public static class Move
    extends ModelChange {
        private final String srcId;
        private final String dstId;
        private final String id;

        public Move(String srcId, String dstId, String id) {
            this.srcId = srcId;
            this.dstId = dstId;
            this.id = id;
        }

        public String getSrcId() {
            return this.srcId;
        }

        public String getDstId() {
            return this.dstId;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return "ModelChange.Move[srcId=" + this.srcId + ",dstId=" + this.dstId + ",id" + this.id + "]";
        }
    }

    public static class Destroy
    extends ModelChange {
        private final String id;

        public Destroy(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return "ModelChange.Destroy[id=" + this.id + "]";
        }
    }

    public static class Update
    extends ModelChange {
        private final ModelData object;

        public Update(ModelData object) {
            this.object = object;
        }

        public ModelData getObject() {
            return this.object;
        }

        public String toString() {
            return "ModelChange.Update[id=" + this.object.getStorageId() + "]";
        }
    }

    public static class Create
    extends ModelChange {
        private final String parentId;
        private final ModelData object;

        public Create(String parentId, ModelData object) {
            this.parentId = parentId;
            this.object = object;
        }

        public ModelData getObject() {
            return this.object;
        }

        public String toString() {
            return "ModelChange.Create[parentId=" + this.parentId + "id=" + this.object.getStorageId() + ",name=" + this.object.getStorageName() + "]";
        }
    }
}

