/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.cache.CachedIdentityStorage;
import org.exoplatform.social.core.storage.cache.CachedSpaceStorage;

public class SpaceUtils {
    private static final Log LOG = ExoLogger.getLogger(SpaceUtils.class);
    public static final String SPACE_GROUP = "/spaces";
    public static final String SPACE_GROUP_PREFIX = "/spaces/";
    public static final String PLATFORM_USERS_GROUP = "/platform/users";
    public static final String PLATFORM_EXTERNALS_GROUP = "/platform/externals";
    public static final String PLATFORM_PUBLISHER_GROUP = "/platform/web-contributors";
    public static final String SPACE_ADMIN_REFERENCE_NAME = "spaceAdmin";
    public static final String MANAGER = "manager";
    public static final String MEMBER = "member";
    public static final String INTERNAL = "internal";
    public static final String AUTHENTICATED = "authenticated";
    public static final String EVERYONE = "everyone";
    public static final String REDACTOR = "redactor";
    public static final String PUBLISHER = "publisher";
    public static final String PENDING = "pending";
    public static final String INVITED = "invited";
    public static final String IGNORED = "ignored";
    public static final String MENU_CONTAINER = "Menu";
    public static final String APPLICATION_CONTAINER = "Application";
    public static final String SPACE_URL = "SPACE_URL";
    public static final String SPACE_SETTINGS_PAGE = "settings";
    public static final String PUBLIC_SITE_SPACE_ID = "SPACE_ID";
    public static final String IS_PUBLIC_SITE_SPACE = "IS_SPACE_PUBLIC_SITE";
    public static final String CURRENT_SPACE = "CurrentSpace";
    private static final String NUMBER_REG_PATTERN = "\\d";
    private static final String UNDER_SCORE_STR = "_";
    private static final String SPACE_STR = " ";

    public static String cleanString(String str) {
        return Utils.cleanString((String)str);
    }

    public static boolean isSpaceContext() {
        return SpaceUtils.getSpaceByContext() != null;
    }

    public static String getSpaceUrlByContext() {
        Space space = SpaceUtils.getSpaceByContext();
        return space != null ? space.getUrl() : null;
    }

    public static Space getSpaceByContext() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        Object currentSpaceObject = pcontext.getAttribute(CURRENT_SPACE);
        if (currentSpaceObject != null) {
            if (Objects.equals(currentSpaceObject, "")) {
                return null;
            }
            return (Space)currentSpaceObject;
        }
        if (!pcontext.getSiteType().equals((Object)SiteType.GROUP) || !pcontext.getSiteName().startsWith(SPACE_GROUP)) {
            SpaceUtils.setSpaceByContext(pcontext, "");
            return null;
        }
        Space currentSpace = SpaceUtils.getSpaceService().getSpaceByGroupId(pcontext.getSiteName());
        SpaceUtils.setSpaceByContext(pcontext, currentSpace);
        return currentSpace;
    }

    public static void setSpaceByContext(PortalRequestContext context, Object space) {
        context.setAttribute(CURRENT_SPACE, space);
    }

    public static Identity getSpaceIdentityByContext() {
        Space space = SpaceUtils.getSpaceByContext();
        if (space != null) {
            IdentityManager identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
            return identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        }
        return null;
    }

    public static String createGroup(String spaceName, String creator) throws SpaceException {
        return SpaceUtils.createGroup(spaceName, spaceName, creator);
    }

    public static String createGroup(String groupLabel, String spaceName, String creator) throws SpaceException {
        String groupId;
        Group newGroup;
        OrganizationService organizationService = SpaceUtils.getOrganizationService();
        GroupHandler groupHandler = organizationService.getGroupHandler();
        try {
            Group parentGroup = groupHandler.findGroupById(SPACE_GROUP);
            newGroup = groupHandler.createGroupInstance();
            String shortName = Utils.cleanString((String)((String)StringUtils.firstNonBlank((CharSequence[])new String[]{groupLabel, spaceName})));
            groupId = parentGroup.getId() + "/" + shortName;
            if (SpaceUtils.getSpaceService().getSpaceByGroupId(groupId) != null) {
                shortName = SpaceUtils.buildGroupId(shortName, parentGroup.getId());
                groupId = parentGroup.getId() + "/" + shortName;
            }
            if (SpaceUtils.isSpaceNameExisted(spaceName)) {
                throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
            }
            newGroup.setGroupName(shortName);
            newGroup.setLabel(groupLabel);
            newGroup.setDescription("the " + parentGroup.getId() + "/" + shortName + " group");
            groupHandler.addChild(parentGroup, newGroup, true);
        }
        catch (Exception e) {
            if (e instanceof SpaceException) {
                SpaceException spaceException = (SpaceException)e;
                throw spaceException;
            }
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREATE_GROUP, (Throwable)e);
        }
        try {
            SpaceUtils.addCreatorToGroup(creator, groupId);
            return groupId;
        }
        catch (Exception e) {
            try {
                groupHandler.removeGroup(newGroup, true);
            }
            catch (Exception ex) {
                LOG.warn((Object)"Unable to rollback group creation after a failure in space group creation. Throw original exception to stop space creation only.", (Throwable)ex);
            }
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_CREATOR, (Throwable)e);
        }
    }

    public static void removeGroup(Space space) throws SpaceException {
        try {
            OrganizationService organizationService = SpaceUtils.getOrganizationService();
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group group = groupHandler.findGroupById(space.getGroupId());
            groupHandler.removeGroup(group, true);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_GROUP, (Throwable)e);
        }
    }

    public static void removeMembershipFromGroup(Space space) {
        if (space == null) {
            return;
        }
        if (space.getMembers() != null) {
            for (String userId : space.getMembers()) {
                SpaceUtils.removeUserFromGroupWithMemberMembership(userId, space.getGroupId());
            }
        }
        if (space.getManagers() != null) {
            for (String userId : space.getManagers()) {
                SpaceUtils.removeUserFromGroupWithManagerMembership(userId, space.getGroupId());
            }
        }
        if (space.getRedactors() != null) {
            for (String userId : space.getRedactors()) {
                SpaceUtils.removeUserFromGroupWithRedactorMembership(userId, space.getGroupId());
            }
        }
        if (space.getPublishers() != null) {
            for (String userId : space.getPublishers()) {
                SpaceUtils.removeUserFromGroupWithPublisherMembership(userId, space.getGroupId());
            }
        }
    }

    public static boolean isSpaceNameExisted(String spaceName) {
        return SpaceUtils.getSpaceService().getSpaceByPrettyName(Utils.cleanString((String)spaceName)) != null;
    }

    public static void addCreatorToGroup(String creator, String groupId) {
        SpaceUtils.addUserToGroupWithMemberMembership(creator, groupId);
        SpaceUtils.addUserToGroupWithManagerMembership(creator, groupId);
    }

    private static void addUserToGroupWithMembership(String remoteId, String groupId, String membership) {
        OrganizationService organizationService = SpaceUtils.getOrganizationService();
        try {
            MembershipHandler membershipHandler = organizationService.getMembershipHandler();
            Membership found = membershipHandler.findMembershipByUserGroupAndType(remoteId, groupId, membership);
            if (found == null && !"*".equalsIgnoreCase(membership)) {
                found = membershipHandler.findMembershipByUserGroupAndType(remoteId, groupId, "*");
            }
            if (found != null) {
                LOG.debug("user: {} was already added to group: {} with membership * or : {}", new Object[]{remoteId, groupId, membership});
                return;
            }
            User user = organizationService.getUserHandler().findUserByName(remoteId);
            MembershipType membershipType = organizationService.getMembershipTypeHandler().findMembershipType(membership);
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group existingGroup = groupHandler.findGroupById(groupId);
            membershipHandler.linkMembership(user, existingGroup, membershipType, true);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to add user: " + remoteId + " to group: " + groupId + " with membership: " + membership, e);
        }
        finally {
            Space space;
            SpaceUtils.clearIdentityCaching("organization", remoteId);
            if (groupId.startsWith(SPACE_GROUP) && (space = SpaceUtils.getSpaceService().getSpaceByGroupId(groupId)) != null) {
                SpaceUtils.clearIdentityCaching("space", space.getPrettyName());
                SpaceUtils.clearSpaceCache(space.getId());
            }
        }
    }

    public static void addUserToGroupWithMemberMembership(String remoteId, String groupId) {
        SpaceUtils.addUserToGroupWithMembership(remoteId, groupId, MEMBER);
    }

    public static void addUserToGroupWithRedactorMembership(String remoteId, String groupId) {
        SpaceUtils.addUserToGroupWithMembership(remoteId, groupId, REDACTOR);
    }

    public static void addUserToGroupWithPublisherMembership(String remoteId, String groupId) {
        SpaceUtils.addUserToGroupWithMembership(remoteId, groupId, PUBLISHER);
    }

    public static void addUserToGroupWithManagerMembership(String remoteId, String groupId) {
        SpaceUtils.addUserToGroupWithMembership(remoteId, groupId, MANAGER);
    }

    private static void removeUserFromGroupWithMembership(String remoteId, String groupId, String membership) {
        try {
            Space space;
            OrganizationService organizationService = SpaceUtils.getOrganizationService();
            MembershipHandler memberShipHandler = organizationService.getMembershipHandler();
            if (MEMBER.equals(membership)) {
                Collection memberships = memberShipHandler.findMembershipsByUserAndGroup(remoteId, groupId);
                if (CollectionUtils.isEmpty((Collection)memberships)) {
                    LOG.debug((Object)("User: " + remoteId + " is not a member of group: " + groupId));
                    return;
                }
                for (Membership mbShip : memberships) {
                    memberShipHandler.removeMembership(mbShip.getId(), true);
                }
            } else {
                Membership memberShip = memberShipHandler.findMembershipByUserGroupAndType(remoteId, groupId, membership);
                Membership any = memberShipHandler.findMembershipByUserGroupAndType(remoteId, groupId, "*");
                if (any != null) {
                    memberShipHandler.removeMembership(any.getId(), true);
                }
                if (memberShip == null) {
                    LOG.debug((Object)("User: " + remoteId + " is not a " + membership + " of group: " + groupId));
                    return;
                }
                UserHandler userHandler = organizationService.getUserHandler();
                User user = userHandler.findUserByName(remoteId);
                memberShipHandler.removeMembership(memberShip.getId(), true);
                MembershipType mbShipTypeMember = organizationService.getMembershipTypeHandler().findMembershipType(MEMBER);
                GroupHandler groupHandler = organizationService.getGroupHandler();
                memberShipHandler.linkMembership(user, groupHandler.findGroupById(groupId), mbShipTypeMember, true);
            }
            SpaceUtils.clearIdentityCaching("organization", remoteId);
            if (groupId.startsWith(SPACE_GROUP) && (space = SpaceUtils.getSpaceService().getSpaceByGroupId(groupId)) != null) {
                SpaceUtils.clearIdentityCaching("space", space.getPrettyName());
                SpaceUtils.clearSpaceCache(space.getId());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to remove user: " + remoteId + " to group: " + groupId + " with membership: " + membership), (Throwable)e);
        }
    }

    public static void removeUserFromGroupWithMemberMembership(String remoteId, String groupId) {
        SpaceUtils.removeUserFromGroupWithMembership(remoteId, groupId, MEMBER);
    }

    public static void removeUserFromGroupWithRedactorMembership(String remoteId, String groupId) {
        SpaceUtils.removeUserFromGroupWithMembership(remoteId, groupId, REDACTOR);
    }

    public static void removeUserFromGroupWithPublisherMembership(String remoteId, String groupId) {
        SpaceUtils.removeUserFromGroupWithMembership(remoteId, groupId, PUBLISHER);
    }

    public static void removeUserFromGroupWithManagerMembership(String remoteId, String groupId) {
        SpaceUtils.removeUserFromGroupWithMembership(remoteId, groupId, MANAGER);
    }

    public static void removeUserFromGroupWithAnyMembership(String remoteId, String groupId) {
        SpaceUtils.removeUserFromGroupWithMembership(remoteId, groupId, "*");
    }

    public static NavigationContext getGroupNavigationContext(String groupId) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
        return navService.loadNavigation(SiteKey.group((String)groupId));
    }

    public static OrganizationService getOrganizationService() {
        PortalContainer portalContainer = PortalContainer.getInstance();
        return (OrganizationService)portalContainer.getComponentInstanceOfType(OrganizationService.class);
    }

    public static String buildGroupId(String prettyName, String parentGroupId) {
        String checkedGroupId = prettyName;
        String mainPatternGroupId = null;
        String numberPattern = NUMBER_REG_PATTERN;
        mainPatternGroupId = checkedGroupId.substring(checkedGroupId.lastIndexOf(UNDER_SCORE_STR) + 1).matches(numberPattern) ? checkedGroupId.substring(0, checkedGroupId.lastIndexOf(UNDER_SCORE_STR)) : checkedGroupId;
        boolean hasNext = true;
        int extendPattern = 0;
        while (hasNext) {
            IdentityManager idm;
            Identity identity;
            checkedGroupId = Utils.cleanString((String)(mainPatternGroupId + SPACE_STR + ++extendPattern));
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            if (SpaceUtils.getSpaceService().getSpaceByGroupId(parentGroupId + "/" + checkedGroupId) != null || (identity = (idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class)).getOrCreateSpaceIdentity(checkedGroupId)) != null) continue;
            hasNext = false;
        }
        return checkedGroupId;
    }

    public static SpaceService getSpaceService() {
        return (SpaceService)ExoContainerContext.getService(SpaceService.class);
    }

    private static void clearIdentityCaching(String providerId, String remoteId) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        CachedIdentityStorage cachedIdentityStorage = (CachedIdentityStorage)container.getComponentInstanceOfType(CachedIdentityStorage.class);
        cachedIdentityStorage.clearIdentityCache(providerId, remoteId, false);
    }

    private static void clearSpaceCache(String spaceId) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        CachedSpaceStorage cachedSpaceStorage = (CachedSpaceStorage)container.getComponentInstanceOfType(CachedSpaceStorage.class);
        cachedSpaceStorage.clearSpaceCached(spaceId);
    }
}

