/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage.cache;

import java.util.Locale;
import java.util.Map;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.dao.DescriptionDAO;
import org.exoplatform.portal.mop.storage.DescriptionStorageImpl;
import org.exoplatform.portal.mop.storage.cache.model.DescriptionCacheKey;
import org.exoplatform.portal.mop.storage.cache.model.DescriptionCacheSelector;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CacheDescriptionStorage
extends DescriptionStorageImpl {
    private static final Log LOG = ExoLogger.getExoLogger(CacheDescriptionStorage.class);
    public static final String DESCRIPTION_CACHE_NAME = "portal.DescriptionService";
    private final FutureExoCache<DescriptionCacheKey, State, Object> descriptionFutureCache;
    private final ExoCache<DescriptionCacheKey, State> descriptionCache;

    public CacheDescriptionStorage(CacheService cacheService, DescriptionDAO descriptionDAO) {
        super(descriptionDAO);
        this.descriptionCache = cacheService.getCacheInstance(DESCRIPTION_CACHE_NAME);
        this.descriptionFutureCache = new FutureExoCache((Loader)new Loader<DescriptionCacheKey, State, Object>(){

            public State retrieve(Object context, DescriptionCacheKey cacheKey) throws Exception {
                State description = CacheDescriptionStorage.super.getDescription(cacheKey.getId(), cacheKey.getLocale(), cacheKey.isIncludeParent());
                return description == null ? State.NULL_OBJECT : description;
            }
        }, this.descriptionCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String id, Locale locale, State description) {
        try {
            super.setDescription(id, locale, description);
        }
        finally {
            this.clearCacheEntries(id);
        }
    }

    @Override
    public void setDescription(String id, State description) {
        try {
            super.setDescription(id, description);
        }
        finally {
            this.clearCacheEntries(id);
        }
    }

    @Override
    public void setDescriptions(String id, Map<Locale, State> descriptions) {
        try {
            super.setDescriptions(id, descriptions);
        }
        finally {
            this.clearCacheEntries(id);
        }
    }

    @Override
    public State getDescription(String id, Locale locale, boolean checkParent) {
        State desccription = (State)this.descriptionFutureCache.get(null, (Object)new DescriptionCacheKey(id, locale, checkParent));
        return desccription == null || desccription.isNull() ? null : desccription;
    }

    private void clearCacheEntries(String id) {
        try {
            this.descriptionCache.select((CachedObjectSelector)new DescriptionCacheSelector(id));
        }
        catch (Exception e) {
            LOG.warn((Object)"Error selecting cache entries to clear, clear all entries", (Throwable)e);
            this.descriptionCache.clearCache();
        }
    }
}

