/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.recovery;

import io.meeds.spring.web.localization.HttpRequestLocaleWrapper;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.rest.UserFieldValidator;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.application.JspBasedWebHandler;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.json.JSONObject;

public class PasswordRecoveryHandler
extends JspBasedWebHandler {
    public static final QualifiedName TOKEN = QualifiedName.create((String)"gtn", (String)"token");
    public static final QualifiedName LANG = QualifiedName.create((String)"gtn", (String)"lang");
    public static final QualifiedName INIT_URL = QualifiedName.create((String)"gtn", (String)"initialURI");
    public static final String NAME = "forgot-password";
    public static final String FORM_URL_PARAM = "formUrl";
    public static final String ACTION_PARAM = "action";
    public static final String RESET_PASSWORD_ACTION_NAME = "resetPassword";
    public static final String INITIAL_URI_PARAM = INIT_URL.getName();
    public static final String EXPIRED_ACTION_NAME = "expired";
    public static final String SEND_ACTION_NAME = "send";
    public static final String ERROR_MESSAGE_PARAM = "error";
    public static final String TOKEN_ID_PARAM = "tokenId";
    public static final String SUCCESS_MESSAGE_PARAM = "success";
    public static final String USERNAME_PARAM = "username";
    public static final String PASSWORD_PARAM = "password";
    public static final String PASSWORD_CONFIRM_PARAM = "password2";
    public static final UserFieldValidator PASSWORD_VALIDATOR = new UserFieldValidator("password", false, false, 8, 255);
    public static final String FORGOT_PASSWORD_JSP_PATH = "/WEB-INF/jsp/forgotpassword/forgot_password.jsp";
    private ServletContext servletContext;
    private PasswordRecoveryService passwordRecoveryService;
    private ResourceBundleService resourceBundleService;
    private OrganizationService organizationService;

    public PasswordRecoveryHandler(PortalContainer container, PasswordRecoveryService passwordRecoveryService, ResourceBundleService resourceBundleService, OrganizationService organizationService, LocaleConfigService localeConfigService, BrandingService brandingService, JavascriptConfigService javascriptConfigService, SkinService skinService) {
        super(localeConfigService, brandingService, javascriptConfigService, skinService);
        this.servletContext = container.getPortalContext();
        this.passwordRecoveryService = passwordRecoveryService;
        this.resourceBundleService = resourceBundleService;
        this.organizationService = organizationService;
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        HttpRequestLocaleWrapper request = new HttpRequestLocaleWrapper(controllerContext.getRequest());
        HttpServletResponse response = controllerContext.getResponse();
        Locale locale = request.getLocale();
        ResourceBundle bundle = this.resourceBundleService.getResourceBundle(this.resourceBundleService.getSharedResourceBundleNames(), locale);
        String token = controllerContext.getParameter(TOKEN);
        String initialURI = this.escapeXssCharacters(controllerContext.getParameter(INIT_URL));
        String requestAction = request.getParameter(ACTION_PARAM);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String contextPath = this.servletContext.getContextPath();
        String forgotPasswordPath = this.passwordRecoveryService.getPasswordRecoverURL(token, I18N.toTagIdentifier((Locale)locale));
        parameters.put(FORM_URL_PARAM, contextPath + forgotPasswordPath);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            String username = this.passwordRecoveryService.verifyToken(token, NAME);
            if (username == null) {
                parameters.put(ACTION_PARAM, EXPIRED_ACTION_NAME);
                return this.dispatch(controllerContext, (HttpServletRequest)request, response, parameters);
            }
            if (RESET_PASSWORD_ACTION_NAME.equalsIgnoreCase(requestAction)) {
                String password = request.getParameter(PASSWORD_PARAM);
                String confirmPass = request.getParameter(PASSWORD_CONFIRM_PARAM);
                String requestedUsername = request.getParameter(USERNAME_PARAM);
                if (this.validateUserAndPassword(username, requestedUsername, password, confirmPass, parameters, bundle, locale)) {
                    if (this.passwordRecoveryService.changePass(token, NAME, username, password)) {
                        response.sendRedirect(contextPath + "/login");
                        return true;
                    }
                    parameters.put(ERROR_MESSAGE_PARAM, bundle.getString("gatein.forgotPassword.resetPasswordFailure"));
                }
                parameters.put(PASSWORD_PARAM, password);
                parameters.put(PASSWORD_CONFIRM_PARAM, confirmPass);
            }
            parameters.put(USERNAME_PARAM, this.escapeXssCharacters(username));
            parameters.put(TOKEN_ID_PARAM, token);
            parameters.put(ACTION_PARAM, RESET_PASSWORD_ACTION_NAME);
        } else if (SEND_ACTION_NAME.equalsIgnoreCase(requestAction)) {
            String username = request.getParameter(USERNAME_PARAM);
            if (StringUtils.isBlank((CharSequence)username)) {
                parameters.put(ERROR_MESSAGE_PARAM, bundle.getString("gatein.forgotPassword.emptyUserOrEmail"));
            } else {
                User user = this.findUser(username);
                if (user == null || !user.isEnabled()) {
                    parameters.put(SUCCESS_MESSAGE_PARAM, bundle.getString("gatein.forgotPassword.emailSendSuccessful"));
                } else if (this.passwordRecoveryService.sendRecoverPasswordEmail(user, locale, (HttpServletRequest)request)) {
                    parameters.put(SUCCESS_MESSAGE_PARAM, bundle.getString("gatein.forgotPassword.emailSendSuccessful"));
                } else {
                    parameters.put(ERROR_MESSAGE_PARAM, bundle.getString("gatein.forgotPassword.emailSendFailure"));
                }
                parameters.put(USERNAME_PARAM, this.escapeXssCharacters(username));
            }
        }
        if (initialURI != null) {
            parameters.put(INITIAL_URI_PARAM, initialURI);
        }
        return this.dispatch(controllerContext, (HttpServletRequest)request, response, parameters);
    }

    public String getHandlerName() {
        return NAME;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    protected void extendApplicationParameters(JSONObject applicationParameters, Map<String, Object> additionalParameters) {
        additionalParameters.forEach((arg_0, arg_1) -> ((JSONObject)applicationParameters).put(arg_0, arg_1));
    }

    private boolean dispatch(ControllerContext controllerContext, HttpServletRequest request, HttpServletResponse response, Map<String, Object> parameters) throws Exception {
        super.prepareDispatch(controllerContext, "PORTLET/social/ForgotPassword", Collections.emptyList(), Collections.singletonList("portal/login"), params -> this.extendApplicationParameters((JSONObject)params, parameters));
        this.servletContext.getRequestDispatcher(FORGOT_PASSWORD_JSP_PATH).include((ServletRequest)request, (ServletResponse)response);
        return true;
    }

    private boolean validateUserAndPassword(String tokenUsername, String requestedUsername, String password, String confirmPass, Map<String, Object> parameters, ResourceBundle bundle, Locale locale) {
        if (requestedUsername == null || !requestedUsername.equals(tokenUsername)) {
            String errorMessage = bundle.getString("gatein.forgotPassword.usernameChanged");
            errorMessage = errorMessage.replace("{0}", tokenUsername);
            parameters.put(ERROR_MESSAGE_PARAM, errorMessage);
            return false;
        }
        if (!StringUtils.equals((CharSequence)password, (CharSequence)confirmPass)) {
            parameters.put(ERROR_MESSAGE_PARAM, bundle.getString("gatein.forgotPassword.confirmPasswordNotMatch"));
            return false;
        }
        String errorMessage = PASSWORD_VALIDATOR.validate(locale, password);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            parameters.put(ERROR_MESSAGE_PARAM, errorMessage);
            return false;
        }
        return true;
    }

    private User findUser(String usernameOrEmail) throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName(usernameOrEmail, UserStatus.ANY);
        if (user == null && usernameOrEmail.contains("@")) {
            Query query = new Query();
            query.setEmail(usernameOrEmail);
            ListAccess list = this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
            if (list != null && list.getSize() > 0) {
                user = ((User[])list.load(0, 1))[0];
            }
        }
        return user;
    }

    private String escapeXssCharacters(String message) {
        message = message == null ? null : message.replace("&", "&amp").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;").replace("/", "&#x2F;");
        return message;
    }
}

