/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.io.OutputStream;

public class BufferingOutputStream
extends OutputStream {
    private final OutputStream out;
    private byte[] buffer;
    private boolean open;
    private int offset;
    private final int size;

    public BufferingOutputStream(OutputStream out, int bufferSize) {
        if (out == null) {
            throw new NullPointerException("No null output stream");
        }
        if (bufferSize < 1) {
            throw new IllegalArgumentException("No buffer size under 1");
        }
        this.out = out;
        this.buffer = new byte[bufferSize];
        this.size = bufferSize;
        this.open = true;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.open) {
            throw new IOException("closed");
        }
        if (this.offset >= this.size) {
            this.out.write(this.buffer);
            this.offset = 0;
        }
        this.buffer[this.offset++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.open) {
            throw new IOException("closed");
        }
        if (this.offset + len >= this.size) {
            this.out.write(this.buffer, 0, this.offset);
            this.offset = 0;
            while (len >= this.size) {
                this.out.write(b, off, this.size);
                off += this.size;
                len -= this.size;
            }
        }
        System.arraycopy(b, off, this.buffer, this.offset, len);
        this.offset += len;
    }

    @Override
    public void flush() throws IOException {
        if (!this.open) {
            throw new IOException("closed");
        }
        if (this.offset > 0) {
            this.out.write(this.buffer, 0, this.offset);
            this.offset = 0;
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            throw new IOException("closed");
        }
        if (this.offset > 0) {
            this.out.write(this.buffer, 0, this.offset);
            this.offset = 0;
        }
        this.open = false;
        this.out.close();
    }
}

