/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.portal.jdbc.entity.ComponentEntity;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.SiteType;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Entity(name="GateInPage")
@SequenceGenerator(name="SEQ_GTN_ID_GENERATOR", sequenceName="SEQ_GTN_PAGE_ID", allocationSize=1)
@Table(name="PORTAL_PAGES")
@NamedQueries(value={@NamedQuery(name="PageEntity.deleteByOwner", query="DELETE GateInPage p WHERE p.owner.id = :ownerId"), @NamedQuery(name="PageEntity.findByKey", query="SELECT p FROM GateInPage p WHERE p.name = :name AND p.owner.siteType = :ownerType AND p.owner.name = :ownerId")})
public class PageEntity
extends ComponentEntity
implements Serializable {
    private static final long serialVersionUID = -6195451978995765259L;
    @Id
    @SequenceGenerator(name="SEQ_PAGE_ID_GENERATOR", sequenceName="SEQ_PAGE_ID_GENERATOR", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_PAGE_ID_GENERATOR")
    @Column(name="ID")
    protected Long id;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="SITE_ID")
    private SiteEntity owner;
    @Column(name="SHOW_MAX_WINDOW")
    private boolean showMaxWindow;
    @Column(name="HIDE_SHARED_LAYOUT")
    private boolean hideSharedLayout;
    @Column(name="DISPLAY_NAME", length=200)
    private String displayName;
    @Column(name="NAME", length=200)
    private String name;
    @Column(name="DESCRIPTION", length=2000)
    private String description;
    @Column(name="FACTORY_ID", length=200)
    private String factoryId;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="PAGE_TYPE")
    private PageType pageType;
    @Column(name="LINK")
    private String link;
    @Column(name="PROFILES")
    private String profiles;
    @Column(name="PAGE_BODY", length=5000)
    private String pageBody = PageEntity.getJSONString(new JSONArray());
    @Transient
    private List<ComponentEntity> children = new LinkedList<ComponentEntity>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public SiteEntity getOwner() {
        return this.owner;
    }

    public void setOwner(SiteEntity owner) {
        this.owner = owner;
    }

    public boolean isShowMaxWindow() {
        return this.showMaxWindow;
    }

    public boolean isHideSharedLayout() {
        return this.hideSharedLayout;
    }

    public SiteType getOwnerType() {
        if (this.getOwner() != null) {
            return this.getOwner().getSiteType();
        }
        return null;
    }

    public String getOwnerId() {
        if (this.getOwner() != null) {
            return this.getOwner().getName();
        }
        return null;
    }

    public void setShowMaxWindow(boolean showMaxWindow) {
        this.showMaxWindow = showMaxWindow;
    }

    public void setHideSharedLayout(boolean hideSharedLayout) {
        this.hideSharedLayout = hideSharedLayout;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getPageBody() {
        return this.pageBody;
    }

    public void setPageBody(String pageBody) {
        this.pageBody = pageBody;
    }

    public String getProfiles() {
        return this.profiles;
    }

    public void setProfiles(String profiles) {
        this.profiles = profiles;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public void setFactoryId(String factoryId) {
        this.factoryId = factoryId;
    }

    public List<ComponentEntity> getChildren() {
        return this.children;
    }

    public void setChildren(List<ComponentEntity> children) {
        this.children = children;
    }

    public PageType getPageType() {
        return this.pageType;
    }

    public void setPageType(PageType pageType) {
        this.pageType = pageType;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject obj = super.toJSON();
        JSONArray jChildren = new JSONArray();
        for (ComponentEntity child : this.getChildren()) {
            jChildren.add((Object)child.toJSON());
        }
        obj.put((Object)"children", (Object)jChildren);
        return obj;
    }

    @Override
    public ComponentEntity.TYPE getType() {
        return ComponentEntity.TYPE.PAGE;
    }
}

